/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.highlight;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.lucene.highlight.HighlightedTerm;
import org.apache.lucene.search.uhighlight.Passage;
import org.apache.lucene.search.uhighlight.PassageFormatter;

@API(value=API.Status.INTERNAL)
public class WholeTextFormatter
extends PassageFormatter {
    private final String fieldName;

    public WholeTextFormatter(String fieldName) {
        this.fieldName = fieldName;
    }

    public Object format(Passage[] passages, String content) {
        int[] highlightStarts = new int[passages.length];
        int[] highlightEnds = new int[passages.length];
        boolean hasMatches = false;
        for (int p = 0; p < passages.length; ++p) {
            Passage passage = passages[p];
            for (int i = 0; i < passage.getNumMatches(); ++i) {
                hasMatches = true;
                int start = passage.getMatchStarts()[i];
                int end = passage.getMatchEnds()[i];
                while (i + 1 < passage.getNumMatches() && passage.getMatchStarts()[i + 1] < end) {
                    end = passage.getMatchEnds()[++i];
                }
                end = Math.min(end, passage.getEndOffset());
                highlightStarts[p] = start;
                highlightEnds[p] = end;
            }
        }
        if (!hasMatches) {
            return new HighlightedTerm(this.fieldName, content, new int[0], new int[0]);
        }
        return new HighlightedTerm(this.fieldName, content, highlightStarts, highlightEnds);
    }
}

