/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.highlight;

import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerCombinationProvider;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerWrapper;
import com.apple.foundationdb.record.lucene.LuceneDocumentFromRecord;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.LuceneIndexExpressions;
import com.apple.foundationdb.record.lucene.LuceneRecordCursor;
import com.apple.foundationdb.record.lucene.LuceneScanQueryParameters;
import com.apple.foundationdb.record.lucene.highlight.HighlightedTerm;
import com.apple.foundationdb.record.lucene.highlight.SnippetFormatter;
import com.apple.foundationdb.record.lucene.highlight.WholeTextFormatter;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBQueriedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.util.StringUtils;
import com.google.protobuf.Message;
import java.io.IOException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.uhighlight.PassageFormatter;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;

public class LuceneHighlighting {
    private LuceneHighlighting() {
    }

    private static Set<String> getPrefixTerms(@Nonnull Set<String> terms) {
        Set<String> result = Collections.emptySet();
        Iterator<String> iter = terms.iterator();
        while (iter.hasNext()) {
            String term = iter.next();
            if (!term.endsWith("*")) continue;
            term = term.substring(0, term.length() - 1);
            if (result.isEmpty()) {
                result = new HashSet<String>();
            }
            result.add(term);
            iter.remove();
        }
        return result;
    }

    private static boolean isMatch(@Nonnull String candidate, @Nonnull Set<String> terms, @Nonnull Set<String> prefixes) {
        for (String term : terms) {
            if (!StringUtils.containsIgnoreCase((String)candidate, (String)term)) continue;
            return true;
        }
        for (String term : prefixes) {
            if (!StringUtils.containsIgnoreCase((String)candidate, (String)term)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    private static Set<String> getFieldTerms(@Nonnull Map<String, Set<String>> termMap, @Nonnull String fieldName) {
        Set<String> forAll;
        HashSet<String> terms = new HashSet<String>();
        Set<String> forField = termMap.get(fieldName);
        if (forField != null) {
            terms.addAll(forField);
        }
        if ((forAll = termMap.get("")) != null) {
            terms.addAll(forAll);
        }
        return terms;
    }

    @Nonnull
    public static <M extends Message> List<HighlightedTerm> highlightedTermsForMessage(@Nullable FDBQueriedRecord<M> queriedRecord, @Nullable String nestedName) {
        if (queriedRecord == null) {
            return Collections.emptyList();
        }
        IndexEntry indexEntry = queriedRecord.getIndexEntry();
        if (!(indexEntry instanceof LuceneRecordCursor.ScoreDocIndexEntry)) {
            return Collections.emptyList();
        }
        LuceneRecordCursor.ScoreDocIndexEntry docIndexEntry = (LuceneRecordCursor.ScoreDocIndexEntry)indexEntry;
        if (docIndexEntry.getLuceneQueryHighlightParameters() == null) {
            return Collections.emptyList();
        }
        return LuceneHighlighting.highlightedTermsForMessage(queriedRecord, queriedRecord.getRecord(), nestedName, docIndexEntry.getIndexKey(), docIndexEntry.getTermMap(), docIndexEntry.getAnalyzerSelector(), docIndexEntry.getLuceneQueryHighlightParameters());
    }

    @Nonnull
    public static <M extends Message> List<HighlightedTerm> highlightedTermsForMessage(@Nonnull FDBRecord<M> rec, M message, @Nullable String nestedName, @Nonnull KeyExpression expression, @Nonnull Map<String, Set<String>> termMap, @Nonnull LuceneAnalyzerCombinationProvider analyzerSelector, @Nonnull LuceneScanQueryParameters.LuceneQueryHighlightParameters luceneQueryHighlightParameters) {
        if (nestedName != null && (expression = LuceneHighlighting.getNestedFields(expression, nestedName)) == null) {
            return Collections.emptyList();
        }
        ArrayList<HighlightedTerm> result = new ArrayList<HighlightedTerm>();
        LuceneIndexExpressions.getFields(expression, new LuceneDocumentFromRecord.FDBRecordSource<M>(rec, message), (source, fieldName, value, type, fieldNameOverride, namedFieldPath, namedFieldSuffix, stored, sorted, overriddenKeyRanges, groupingKeyIndex, keyIndex, fieldConfigsIgnored) -> {
            Object o;
            if (type != LuceneIndexExpressions.DocumentFieldType.TEXT) {
                return;
            }
            Object termName = nestedName == null ? fieldName : nestedName + "_" + fieldName;
            Set<String> terms = LuceneHighlighting.getFieldTerms(termMap, (String)termName);
            if (terms.isEmpty()) {
                return;
            }
            Set<String> prefixes = LuceneHighlighting.getPrefixTerms(terms);
            if (value instanceof String && LuceneHighlighting.isMatch((String)value, terms, prefixes) && (o = LuceneHighlighting.highlight(analyzerSelector, luceneQueryHighlightParameters, fieldName, (String)value, (String)termName)) instanceof HighlightedTerm) {
                result.add((HighlightedTerm)o);
            }
        }, null);
        return result;
    }

    @Nullable
    private static Object highlight(@Nonnull LuceneAnalyzerCombinationProvider analyzerSelector, @Nonnull LuceneScanQueryParameters.LuceneQueryHighlightParameters luceneQueryHighlightParameters, String fieldName, String value, String termName) {
        LuceneAnalyzerWrapper queryAnalyzer = analyzerSelector.provideIndexAnalyzer();
        UnifiedHighlighter highlighter = LuceneHighlighting.makeHighlighter(fieldName, queryAnalyzer.getAnalyzer(), luceneQueryHighlightParameters.getSnippedSize());
        try {
            return highlighter.highlightWithoutSearcher(termName, luceneQueryHighlightParameters.getQuery(), value, luceneQueryHighlightParameters.getMaxMatchCount());
        }
        catch (IOException e) {
            throw LuceneExceptions.toRecordCoreException("Unexpected error processing highlights", e, new Object[0]);
        }
    }

    @Nullable
    private static KeyExpression getNestedFields(@Nonnull KeyExpression expression, @Nonnull String nestedName) {
        if (expression instanceof GroupingKeyExpression) {
            expression = ((GroupingKeyExpression)expression).getGroupedSubKey();
        }
        ArrayList<KeyExpression> expressions = new ArrayList<KeyExpression>();
        if (expression instanceof ThenKeyExpression) {
            for (KeyExpression child : ((ThenKeyExpression)expression).getChildren()) {
                if (!(child instanceof NestingKeyExpression) || !((NestingKeyExpression)child).getParent().getFieldName().equals(nestedName)) continue;
                expressions.add(((NestingKeyExpression)child).getChild());
            }
        }
        if (expressions.isEmpty()) {
            return null;
        }
        if (expressions.size() == 1) {
            return (KeyExpression)expressions.get(0);
        }
        return Key.Expressions.concat(expressions);
    }

    public static UnifiedHighlighter makeHighlighter(String fieldName, Analyzer analyzer, int snippetSize) {
        UnifiedHighlighter highlighter = new UnifiedHighlighter(null, analyzer);
        Supplier<BreakIterator> breakIterSupplier = BreakIterator::getWordInstance;
        highlighter.setBreakIterator(breakIterSupplier);
        if (snippetSize > 0) {
            highlighter.setFormatter((PassageFormatter)new SnippetFormatter(fieldName, breakIterSupplier, snippetSize));
        } else {
            highlighter.setFormatter((PassageFormatter)new WholeTextFormatter(fieldName));
        }
        return highlighter;
    }
}

