/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.lucene.LuceneLogMessageKeys;
import com.apple.foundationdb.record.lucene.directory.AgilityContext;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.slf4j.Logger;

class MergeUtils {
    MergeUtils() {
    }

    public static void logExecutingMerge(@Nonnull Logger logger, @Nonnull String staticMessage, @Nonnull AgilityContext agilityContext, @Nonnull Subspace indexSubspace, @Nullable Tuple key, @Nonnull MergeTrigger mergeTrigger) {
        if (logger.isDebugEnabled()) {
            KeyValueLogMessage message = MergeUtils.baseLogMessage(staticMessage, agilityContext, indexSubspace, key, mergeTrigger);
            MergeUtils.logWithExceptionIfNotAgile(logger, agilityContext, message);
        }
    }

    static void logFoundMerges(@Nonnull Logger logger, @Nonnull String staticMessage, @Nonnull AgilityContext context, @Nonnull Subspace indexSubspace, @Nullable Tuple key, @Nonnull MergeTrigger mergeTrigger, @Nullable MergePolicy.MergeSpecification merges, @Nullable Exception exceptionAtCreation) {
        if (merges != null && logger.isDebugEnabled()) {
            KeyValueLogMessage message = MergeUtils.baseLogMessage(staticMessage, context, indexSubspace, key, mergeTrigger);
            message.addKeyAndValue((Object)LuceneLogMessageKeys.MERGE_SOURCE, (Object)MergeUtils.simpleSpec(merges));
            MergeUtils.logWithExceptionIfNotAgile(logger, context, message);
            MergeUtils.logWithCreationMessageIfNotAgile(logger, staticMessage, context, indexSubspace, key, mergeTrigger, merges, exceptionAtCreation);
        }
    }

    private static void logWithCreationMessageIfNotAgile(@Nonnull Logger logger, @Nonnull String staticMessage, @Nonnull AgilityContext context, @Nonnull Subspace indexSubspace, @Nullable Tuple key, @Nonnull MergeTrigger mergeTrigger, @Nonnull MergePolicy.MergeSpecification merges, @Nullable Exception exceptionAtCreation) {
        if (!(context instanceof AgilityContext.Agile)) {
            KeyValueLogMessage message = MergeUtils.baseLogMessage(staticMessage, context, indexSubspace, key, mergeTrigger);
            message.addKeyAndValue((Object)LuceneLogMessageKeys.MERGE_SOURCE, (Object)MergeUtils.simpleSpec(merges));
            logger.debug(String.valueOf(message) + " (Creation)", (Throwable)exceptionAtCreation);
        }
    }

    private static void logWithExceptionIfNotAgile(@Nonnull Logger logger, @Nonnull AgilityContext context, KeyValueLogMessage message) {
        if (context instanceof AgilityContext.Agile) {
            logger.debug(message.toString());
        } else {
            logger.debug(message.toString(), (Throwable)new Exception());
        }
    }

    @Nonnull
    private static KeyValueLogMessage baseLogMessage(@Nonnull String staticMessage, @Nonnull AgilityContext context, @Nonnull Subspace indexSubspace, @Nullable Tuple key, @Nonnull MergeTrigger mergeTrigger) {
        return KeyValueLogMessage.build((String)staticMessage, (Object[])new Object[]{LogMessageKeys.INDEX_SUBSPACE, indexSubspace, LogMessageKeys.KEY, key, LuceneLogMessageKeys.MERGE_TRIGGER, mergeTrigger, LogMessageKeys.AGILITY_CONTEXT, context.getClass().getSimpleName()});
    }

    private static String simpleSpec(@Nonnull MergePolicy.MergeSpecification merges) {
        return merges.merges.stream().map(merge -> merge.segments.stream().map(segment -> segment.info.name).collect(Collectors.joining(",", "", ""))).collect(Collectors.joining(";"));
    }
}

