/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.directory.FDBIndexInput;
import java.io.IOException;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.IndexInput;

public class PrefetchableBufferedChecksumIndexInput
extends BufferedChecksumIndexInput {
    private final IndexInput indexInput;
    private static final int PREFETCH_BLOCKS = 10;
    private int greatestFetchedBlock;
    private int maximumFetchedBlock;
    private final boolean supportsPrefetch;

    public PrefetchableBufferedChecksumIndexInput(IndexInput indexInput) {
        super(indexInput);
        this.indexInput = indexInput;
        this.supportsPrefetch = indexInput instanceof FDBIndexInput;
    }

    public void setExpectedBytes(long numberOfBytesToPrefetch) {
        if (this.supportsPrefetch) {
            this.maximumFetchedBlock = ((FDBIndexInput)this.indexInput).getBlock(numberOfBytesToPrefetch - 1L);
            this.greatestFetchedBlock = ((FDBIndexInput)this.indexInput).getBlock(0L) - 1;
            this.checkBuffer(0L);
        }
    }

    public void checkBuffer(long length) {
        if (this.supportsPrefetch) {
            int blocksToBuffer;
            int idealPointToReadTo = ((FDBIndexInput)this.indexInput).getBlock(this.indexInput.getFilePointer() + length) + 10;
            if (idealPointToReadTo > this.maximumFetchedBlock) {
                idealPointToReadTo = this.maximumFetchedBlock;
                blocksToBuffer = idealPointToReadTo - this.greatestFetchedBlock;
            } else {
                blocksToBuffer = idealPointToReadTo - this.greatestFetchedBlock - 1;
            }
            if (blocksToBuffer > 0) {
                this.greatestFetchedBlock += ((FDBIndexInput)this.indexInput).prefetch(this.greatestFetchedBlock + 1, blocksToBuffer);
            }
        }
    }

    public byte readByte() throws IOException {
        try {
            this.checkBuffer(1L);
            return super.readByte();
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        try {
            this.checkBuffer(len);
            super.readBytes(b, offset, len);
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }
}

