/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.record.lucene.codec.LazyCloseable;
import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsReader;
import org.apache.lucene.codecs.lucene84.Lucene84PostingsFormat;
import org.apache.lucene.codecs.lucene84.LuceneOptimizedPostingsReader;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;

public class LuceneOptimizedPostingsFormat
extends PostingsFormat {
    PostingsFormat postingsFormat;
    static boolean allowCheckDataIntegrity = true;

    public static boolean shouldAllowCheckDataIntegrity() {
        return allowCheckDataIntegrity;
    }

    public LuceneOptimizedPostingsFormat() {
        this((PostingsFormat)new Lucene84PostingsFormat());
    }

    public LuceneOptimizedPostingsFormat(PostingsFormat postingsFormat) {
        super("RL" + postingsFormat.getName());
        this.postingsFormat = postingsFormat;
    }

    public static void setAllowCheckDataIntegrity(boolean allow) {
        allowCheckDataIntegrity = allow;
    }

    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return this.postingsFormat.fieldsConsumer(state);
    }

    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new LazyFieldsProducer(state);
    }

    private static class LazyFieldsProducer
    extends FieldsProducer {
        private final LazyCloseable<FieldsProducer> fieldsProducer = LazyCloseable.supply(() -> {
            LuceneOptimizedPostingsReader postingsReader = new LuceneOptimizedPostingsReader(state);
            return new BlockTreeTermsReader((PostingsReaderBase)postingsReader, state);
        });

        private LazyFieldsProducer(SegmentReadState state) {
        }

        public void close() throws IOException {
            this.fieldsProducer.close();
        }

        public void checkIntegrity() throws IOException {
            if (allowCheckDataIntegrity) {
                this.fieldsProducer.get().checkIntegrity();
            }
        }

        public Iterator<String> iterator() {
            return this.fieldsProducer.getUnchecked().iterator();
        }

        public Terms terms(String field) throws IOException {
            return this.fieldsProducer.get().terms(field);
        }

        public int size() {
            return this.fieldsProducer.getUnchecked().size();
        }

        public long ramBytesUsed() {
            return this.fieldsProducer.getUnchecked().ramBytesUsed();
        }
    }
}

