/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.lucene.synonym.SynonymMapRegistryImpl;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.synonym.SynonymGraphFilter;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class RegistrySynonymGraphFilterFactory
extends TokenFilterFactory {
    private final SynonymMap map;
    private final boolean ignoreCase;

    public RegistrySynonymGraphFilterFactory(Map<String, String> args) {
        super(args);
        String synonymName = this.get(args, "synonyms");
        this.ignoreCase = this.getBoolean(args, "ignoreCase", true);
        this.map = SynonymMapRegistryImpl.instance().getSynonymMap(synonymName);
    }

    public TokenStream create(TokenStream input) {
        if (this.map == null) {
            return input;
        }
        return new SynonymGraphFilter(input, this.map, this.ignoreCase);
    }
}

