/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.ByteArrayContinuation;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.cursors.BaseCursor;
import com.apple.foundationdb.record.lucene.LuceneContinuationProto;
import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.LuceneRecordContextProperties;
import com.apple.foundationdb.record.lucene.directory.FDBDirectoryManager;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.ByteString;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spell.DirectSpellChecker;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneSpellCheckRecordCursor
implements BaseCursor<IndexEntry> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneSpellCheckRecordCursor.class);
    @Nonnull
    private final Executor executor;
    @Nonnull
    private final IndexMaintainerState state;
    private final int limit;
    @Nonnull
    private final String wordToSpellCheck;
    @Nonnull
    private final DirectSpellChecker spellchecker;
    @Nullable
    private final FDBStoreTimer timer;
    private IndexReader indexReader;
    @Nullable
    private List<IndexEntry> spellcheckSuggestions = null;
    private int currentPosition = 0;
    @Nullable
    private final Tuple groupingKey;
    @Nullable
    private final Integer partitionId;
    private final List<String> fields;
    private boolean closed;

    public LuceneSpellCheckRecordCursor(@Nonnull List<String> fields, @Nonnull String wordToSpellCheck, @Nonnull Executor executor, ScanProperties scanProperties, @Nonnull IndexMaintainerState state, @Nullable Tuple groupingKey, @Nullable Integer partitionId) {
        this.fields = fields;
        this.wordToSpellCheck = wordToSpellCheck;
        this.executor = executor;
        this.state = state;
        this.limit = Math.min(scanProperties.getExecuteProperties().getReturnedRowLimitOrMax(), (Integer)state.context.getPropertyStorage().getPropertyValue(LuceneRecordContextProperties.LUCENE_SPELLCHECK_SEARCH_UPPER_LIMIT));
        this.groupingKey = groupingKey;
        this.partitionId = partitionId;
        this.spellchecker = new DirectSpellChecker();
        this.timer = state.context.getTimer();
        this.closed = false;
    }

    @Nonnull
    public CompletableFuture<RecordCursorResult<IndexEntry>> onNext() {
        CompletableFuture<IndexEntry> spellcheckResult = CompletableFuture.supplyAsync(() -> {
            if (this.spellcheckSuggestions == null) {
                try {
                    this.spellcheck();
                }
                catch (IOException e) {
                    throw LuceneExceptions.toRecordCoreException("Spellcheck suggestions lookup failure", e, new Object[0]);
                }
            }
            return this.currentPosition < this.spellcheckSuggestions.size() ? this.spellcheckSuggestions.get(this.currentPosition) : null;
        }, this.executor);
        return spellcheckResult.thenApply(r -> {
            if (r == null) {
                return RecordCursorResult.exhausted();
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Suggestion read as an index entry={}", (Object)this.spellcheckSuggestions.get(this.currentPosition));
            }
            return RecordCursorResult.withNextValue((Object)r, (RecordCursorContinuation)this.continuationHelper(this.spellcheckSuggestions.get(this.currentPosition++)));
        });
    }

    @Nonnull
    private RecordCursorContinuation continuationHelper(@Nonnull IndexEntry lookupResult) {
        LuceneContinuationProto.LuceneSpellCheckIndexContinuation.Builder continuationBuilder = LuceneContinuationProto.LuceneSpellCheckIndexContinuation.newBuilder().setValue(ByteString.copyFromUtf8((String)lookupResult.toString()));
        continuationBuilder.setLocation(this.currentPosition);
        return ByteArrayContinuation.fromNullable((byte[])continuationBuilder.build().toByteArray());
    }

    public void close() {
        if (this.indexReader != null) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.indexReader});
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Nonnull
    public Executor getExecutor() {
        return this.executor;
    }

    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        visitor.visitEnter((RecordCursor)this);
        return visitor.visitLeave((RecordCursor)this);
    }

    private synchronized IndexReader getIndexReader() throws IOException {
        return FDBDirectoryManager.getManager(this.state).getIndexReader(this.groupingKey, this.partitionId);
    }

    private void spellcheck() throws IOException {
        if (this.spellcheckSuggestions != null) {
            return;
        }
        long startTime = System.nanoTime();
        this.indexReader = this.getIndexReader();
        ArrayList suggestionResults = new ArrayList();
        for (String field : this.fields) {
            Arrays.stream(this.spellchecker.suggestSimilar(new Term(field, this.wordToSpellCheck), this.limit, this.indexReader)).map(suggestion -> new Suggestion(field, (SuggestWord)suggestion)).forEach(suggestionResults::add);
        }
        this.spellcheckSuggestions = suggestionResults.stream().collect(Collectors.toMap(suggestion -> suggestion.suggestWord.string, Function.identity(), LuceneSpellCheckRecordCursor::mergeTwoSuggestWords)).values().stream().sorted(Comparator.comparing(s -> Float.valueOf(s.suggestWord.score)).reversed().thenComparing(Comparator.comparing(s -> s.suggestWord.freq).reversed()).thenComparing(s -> s.suggestWord.string)).limit(this.limit).map(suggestion -> {
            Tuple key = Tuple.from((Object[])new Object[]{suggestion.indexField, suggestion.suggestWord.string});
            if (this.groupingKey != null) {
                key = this.groupingKey.addAll(key);
            }
            return new IndexEntry(this.state.index, key, Tuple.from((Object[])new Object[]{Float.valueOf(suggestion.suggestWord.score)}));
        }).collect(Collectors.toList());
        if (this.timer != null) {
            this.timer.recordSinceNanoTime((StoreTimer.Event)LuceneEvents.Events.LUCENE_SPELLCHECK_SCAN, startTime);
            this.timer.increment((StoreTimer.Count)LuceneEvents.Counts.LUCENE_SCAN_SPELLCHECKER_SUGGESTIONS, this.spellcheckSuggestions.size());
        }
    }

    private static Suggestion mergeTwoSuggestWords(Suggestion a, Suggestion b) {
        int freq = a.suggestWord.freq + b.suggestWord.freq;
        String field = a.suggestWord.freq == b.suggestWord.freq ? (a.indexField.compareTo(b.indexField) < 0 ? a.indexField : b.indexField) : (a.suggestWord.freq > b.suggestWord.freq ? a.indexField : b.indexField);
        SuggestWord newSuggestWord = new SuggestWord();
        newSuggestWord.freq = freq;
        newSuggestWord.score = a.suggestWord.score;
        newSuggestWord.string = a.suggestWord.string;
        return new Suggestion(field, newSuggestWord);
    }

    private static class Suggestion {
        final String indexField;
        final SuggestWord suggestWord;

        public Suggestion(String indexField, SuggestWord suggestWord) {
            this.indexField = indexField;
            this.suggestWord = suggestWord;
        }
    }
}

