/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.LuceneScanParameters;
import com.apple.foundationdb.record.lucene.LuceneScanSpellCheck;
import com.apple.foundationdb.record.lucene.LuceneScanTypes;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.planprotos.LuceneRecordQueryPlanProto;
import com.apple.foundationdb.record.planprotos.PIndexScanParameters;
import com.apple.foundationdb.record.planprotos.PLuceneScanSpellCheckParameters;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanParameters;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.util.LogMessageKeys;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class LuceneScanSpellCheckParameters
extends LuceneScanParameters
implements PlanSerializable {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash((Object)"Lucene-Scan-Spell-Check");
    @Nonnull
    final String key;
    final boolean isParameter;

    protected LuceneScanSpellCheckParameters(@Nonnull PlanSerializationContext serializationContext, @Nonnull PLuceneScanSpellCheckParameters luceneScanSpellCheckParametersProto) {
        super(serializationContext, Objects.requireNonNull(luceneScanSpellCheckParametersProto.getSuper()));
        this.key = "TODO";
        this.isParameter = false;
    }

    protected LuceneScanSpellCheckParameters(@Nonnull ScanComparisons groupComparisons, @Nonnull String key, boolean isParameter) {
        super(LuceneScanTypes.BY_LUCENE_SPELL_CHECK, groupComparisons);
        this.key = key;
        this.isParameter = isParameter;
    }

    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash((PlanHashable.PlanHashMode)mode, (Object[])new Object[]{BASE_HASH, this.scanType, this.groupComparisons, this.key, this.isParameter});
    }

    @Override
    @Nonnull
    public LuceneScanSpellCheck bind(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index, @Nonnull EvaluationContext context) {
        String wordToSpellCheck;
        List<String> fields = LuceneScanSpellCheckParameters.indexTextFields(index, store.getRecordMetaData());
        String string = wordToSpellCheck = this.isParameter ? (String)context.getBinding(this.key) : this.key;
        if (wordToSpellCheck.contains(":")) {
            String[] fieldAndWord = wordToSpellCheck.split(":", 2);
            if (fields.stream().noneMatch(name -> name.equals(fieldAndWord[0]))) {
                throw new RecordCoreException("Invalid field name in Lucene index query", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.FIELD_NAME, fieldAndWord[0]}).addLogInfo(new Object[]{LogMessageKeys.INDEX_FIELDS, fields});
            }
            fields = List.of(fieldAndWord[0]);
            wordToSpellCheck = fieldAndWord[1];
        }
        return new LuceneScanSpellCheck(this.scanType, this.getGroupKey(store, context), fields, wordToSpellCheck);
    }

    @Nonnull
    public ExplainTokensWithPrecedence explain() {
        return ExplainTokensWithPrecedence.of((ExplainTokens)new ExplainTokens().addToString((Object)(this.getGroupScanDetails() + " " + (this.isParameter ? "$" : "") + this.key)));
    }

    @Override
    public void getPlannerGraphDetails(@Nonnull ImmutableList.Builder<String> detailsBuilder, @Nonnull ImmutableMap.Builder<String, Attribute> attributeMapBuilder) {
        super.getPlannerGraphDetails(detailsBuilder, attributeMapBuilder);
        if (this.isParameter) {
            detailsBuilder.add((Object)"param: {{param}}");
            attributeMapBuilder.put((Object)"param", (Object)Attribute.gml((Object)this.key));
        } else {
            detailsBuilder.add((Object)"key: {{key}}");
            attributeMapBuilder.put((Object)"key", (Object)Attribute.gml((Object)this.key));
        }
    }

    @Nonnull
    public IndexScanParameters translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
        return this;
    }

    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedTo() {
        return ImmutableSet.of();
    }

    @Nonnull
    public IndexScanParameters rebase(@Nonnull AliasMap translationMap) {
        return this;
    }

    public boolean semanticEquals(@Nullable Object other, @Nonnull AliasMap aliasMap) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        LuceneScanSpellCheckParameters that = (LuceneScanSpellCheckParameters)other;
        if (this.isParameter != that.isParameter) {
            return false;
        }
        return this.key.equals(that.key);
    }

    public int semanticHashCode() {
        int result = super.hashCode();
        result = 31 * result + this.key.hashCode();
        result = 31 * result + (this.isParameter ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + " " + (this.isParameter ? "$" : "") + this.key;
    }

    @Override
    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object o) {
        return this.semanticEquals(o, AliasMap.emptyMap());
    }

    @Override
    public int hashCode() {
        return this.semanticHashCode();
    }

    @Nonnull
    public PLuceneScanSpellCheckParameters toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PLuceneScanSpellCheckParameters.newBuilder().setSuper(this.toLuceneScanParametersProto(serializationContext)).build();
    }

    @Nonnull
    public PIndexScanParameters toIndexScanParametersProto(@Nonnull PlanSerializationContext serializationContext) {
        return PIndexScanParameters.newBuilder().setExtension(LuceneRecordQueryPlanProto.luceneScanSpellCheckParameters, (Object)this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static LuceneScanSpellCheckParameters fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PLuceneScanSpellCheckParameters luceneScanSpellCheckParametersProto) {
        return new LuceneScanSpellCheckParameters(serializationContext, luceneScanSpellCheckParametersProto);
    }

    public static class Deserializer
    implements PlanDeserializer<PLuceneScanSpellCheckParameters, LuceneScanSpellCheckParameters> {
        @Nonnull
        public Class<PLuceneScanSpellCheckParameters> getProtoMessageClass() {
            return PLuceneScanSpellCheckParameters.class;
        }

        @Nonnull
        public LuceneScanSpellCheckParameters fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PLuceneScanSpellCheckParameters luceneScanSpellCheckParametersProto) {
            return LuceneScanSpellCheckParameters.fromProto(serializationContext, luceneScanSpellCheckParametersProto);
        }
    }
}

