/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.PipelineOperation;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.cursors.BaseCursor;
import com.apple.foundationdb.record.cursors.CursorLimitManager;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerCombinationProvider;
import com.apple.foundationdb.record.lucene.LuceneContinuationProto;
import com.apple.foundationdb.record.lucene.LuceneCursorContinuation;
import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.LuceneIndexExpressions;
import com.apple.foundationdb.record.lucene.LucenePartitionInfoProto;
import com.apple.foundationdb.record.lucene.LucenePartitioner;
import com.apple.foundationdb.record.lucene.LuceneScanQueryParameters;
import com.apple.foundationdb.record.lucene.directory.FDBDirectoryManager;
import com.apple.foundationdb.record.lucene.search.LuceneOptimizedIndexSearcher;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.EXPERIMENTAL)
public class LuceneRecordCursor
implements BaseCursor<IndexEntry> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneRecordCursor.class);
    private final int pageSize;
    @Nonnull
    private final Executor executor;
    @Nullable
    private final ExecutorService executorService;
    @Nonnull
    private final CursorLimitManager limitManager;
    @Nullable
    private final FDBStoreTimer timer;
    private int limitRemaining;
    private int skip;
    private int leftToSkip;
    @Nullable
    private RecordCursorResult<IndexEntry> nextResult;
    final IndexMaintainerState state;
    private IndexReader indexReader;
    private final Query query;
    private final Sort sort;
    private IndexSearcher searcher;
    private RecordCursor<IndexEntry> lookupResults = null;
    private int currentPosition = 0;
    private final List<KeyExpression> fields;
    @Nullable
    private ScoreDoc searchAfter = null;
    private boolean exhausted = false;
    @Nullable
    private final Tuple groupingKey;
    @Nullable
    Integer partitionId;
    @Nullable
    Tuple partitionKey;
    @Nonnull
    LucenePartitioner partitioner;
    @Nullable
    private final List<String> storedFields;
    @Nonnull
    private final Set<String> storedFieldsToReturn;
    @Nullable
    private final List<LuceneIndexExpressions.DocumentFieldType> storedFieldTypes;
    @Nullable
    private final LuceneScanQueryParameters.LuceneQueryHighlightParameters luceneQueryHighlightParameters;
    @Nullable
    private final Map<String, Set<String>> termMap;
    @Nonnull
    private final LuceneAnalyzerCombinationProvider analyzerSelector;
    @Nonnull
    private final LuceneAnalyzerCombinationProvider autoCompleteAnalyzerSelector;
    private boolean closed;
    private boolean sortedByPartitioningKey = false;
    private boolean withContinuation = false;
    private boolean continuationPartitionSanitized = false;
    private boolean dontResetSearchAfter = false;
    private Tuple searchAfterPartitioningKey = null;
    private boolean isReverseSort = false;

    LuceneRecordCursor(@Nonnull Executor executor, @Nullable ExecutorService executorService, @Nonnull LucenePartitioner partitioner, int pageSize, @Nonnull ScanProperties scanProperties, @Nonnull IndexMaintainerState state, @Nonnull Query query, @Nullable Sort sort, byte[] continuation, @Nullable Tuple groupingKey, @Nullable LucenePartitionInfoProto.LucenePartitionInfo partitionInfo, @Nullable LuceneScanQueryParameters.LuceneQueryHighlightParameters luceneQueryHighlightParameters, @Nullable Map<String, Set<String>> termMap, @Nullable List<String> storedFields, @Nullable List<LuceneIndexExpressions.DocumentFieldType> storedFieldTypes, @Nonnull LuceneAnalyzerCombinationProvider analyzerSelector, @Nonnull LuceneAnalyzerCombinationProvider autoCompleteAnalyzerSelector) {
        this.state = state;
        this.executor = executor;
        this.pageSize = pageSize;
        this.executorService = executorService;
        this.storedFields = storedFields;
        this.storedFieldsToReturn = Sets.newHashSet((Object[])new String[]{"_p"});
        if (this.storedFields != null) {
            this.storedFieldsToReturn.addAll(storedFields);
        }
        this.storedFieldTypes = storedFieldTypes;
        this.limitManager = new CursorLimitManager(state.context, scanProperties);
        this.limitRemaining = scanProperties.getExecuteProperties().getReturnedRowLimitOrMax();
        this.leftToSkip = this.skip = scanProperties.getExecuteProperties().getSkip();
        this.timer = state.context.getTimer();
        this.query = query;
        this.sort = sort;
        this.partitioner = partitioner;
        if (partitionInfo != null) {
            this.partitionId = partitionInfo.getId();
            this.partitionKey = LucenePartitioner.getPartitionKey(partitionInfo);
        }
        if (sort != null && partitioner.isPartitioningEnabled()) {
            LucenePartitioner.PartitionedSortContext sortCriteria = partitioner.isSortedByPartitionField(sort);
            this.sortedByPartitioningKey = sortCriteria.isByPartitionField;
            this.isReverseSort = sortCriteria.isReverse;
            if (this.sortedByPartitioningKey) {
                this.storedFieldsToReturn.add(partitioner.getPartitionFieldNameInLucene());
                if (sortCriteria.updatedSortFields != null) {
                    sort.setSort(sortCriteria.updatedSortFields);
                }
            }
        }
        if (continuation != null) {
            this.withContinuation = true;
            try {
                LuceneContinuationProto.LuceneIndexContinuation parsed = LuceneContinuationProto.LuceneIndexContinuation.parseFrom(continuation);
                this.searchAfter = LuceneCursorContinuation.toScoreDoc(parsed);
                if (parsed.hasPartitionId() != parsed.hasPartitionKey()) {
                    throw new RecordCoreException("Invalid continuation for Lucene index", new Object[]{"hasPartitionId", parsed.hasPartitionId(), "hasPartitionKey", parsed.hasPartitionKey()});
                }
                if (parsed.hasPartitionId()) {
                    this.partitionId = parsed.getPartitionId();
                    this.partitionKey = Tuple.fromBytes((byte[])parsed.getPartitionKey().toByteArray());
                }
                if (this.sortedByPartitioningKey) {
                    Object searchAfterPartitioningField = null;
                    Object searchAfterPrimaryKeyField = null;
                    if (this.searchAfter instanceof FieldDoc) {
                        FieldDoc fieldDoc = (FieldDoc)this.searchAfter;
                        if (fieldDoc.fields != null && fieldDoc.fields.length > 1) {
                            searchAfterPartitioningField = fieldDoc.fields[0];
                            searchAfterPrimaryKeyField = fieldDoc.fields[1];
                        }
                    }
                    if (searchAfterPartitioningField == null || searchAfterPrimaryKeyField == null) {
                        throw new RecordCoreException("expecting partitioning field in continuation token", new Object[0]);
                    }
                    assert (searchAfterPrimaryKeyField instanceof BytesRef);
                    this.searchAfterPartitioningKey = Tuple.from((Object[])new Object[]{searchAfterPartitioningField}).addAll(Tuple.fromBytes((byte[])((BytesRef)searchAfterPrimaryKeyField).bytes));
                }
            }
            catch (Exception e) {
                throw new RecordCoreException("Invalid continuation for Lucene index", new Object[]{"ContinuationValues", continuation, "exception", e});
            }
        }
        this.fields = state.index.getRootExpression().normalizeKeyForPositions();
        this.groupingKey = groupingKey;
        this.luceneQueryHighlightParameters = luceneQueryHighlightParameters;
        this.termMap = termMap;
        this.analyzerSelector = analyzerSelector;
        this.autoCompleteAnalyzerSelector = autoCompleteAnalyzerSelector;
        this.closed = false;
    }

    @Nonnull
    public CompletableFuture<RecordCursorResult<IndexEntry>> onNext() {
        if (this.nextResult != null && !this.nextResult.hasNext()) {
            return CompletableFuture.completedFuture(this.nextResult);
        }
        return this.handleCrossPartitionDiscontinuity().thenCompose(noval -> {
            CompletableFuture scanPages = AsyncUtil.whileTrue(() -> {
                if (this.leftToSkip < this.pageSize) {
                    return CompletableFuture.completedFuture(false);
                }
                try {
                    TopDocs topDocs = this.searchForTopDocs(this.pageSize);
                    this.leftToSkip -= topDocs.scoreDocs.length;
                }
                catch (IndexNotFoundException indexNotFoundException) {
                    this.nextResult = RecordCursorResult.exhausted();
                }
                catch (IOException ioException) {
                    throw LuceneExceptions.toRecordCoreException("Record Cursor failed", ioException, LogMessageKeys.QUERY, this.query);
                }
                return CompletableFuture.completedFuture(this.leftToSkip >= this.pageSize);
            }, (Executor)this.executor);
            return scanPages.thenCompose(vignore -> {
                if (this.lookupResults == null || !this.exhausted && (this.leftToSkip > 0 || (this.currentPosition + this.skip) % this.pageSize == 0) && this.limitRemaining > 0) {
                    return CompletableFuture.supplyAsync(() -> {
                        try {
                            this.maybePerformScan();
                        }
                        catch (IndexNotFoundException indexNotFoundException) {
                            this.nextResult = RecordCursorResult.exhausted();
                            return CompletableFuture.completedFuture(this.nextResult);
                        }
                        catch (IOException ioException) {
                            throw LuceneExceptions.toRecordCoreException("Record Cursor failed", ioException, LogMessageKeys.QUERY, this.query);
                        }
                        return this.lookupResults.onNext().thenCompose(this::switchToNextPartitionAndContinue);
                    }, this.executor).thenCompose(Function.identity());
                }
                return this.lookupResults.onNext().thenCompose(this::switchToNextPartitionAndContinue);
            });
        });
    }

    private CompletableFuture<Void> handleCrossPartitionDiscontinuity() {
        if (!this.withContinuation || this.continuationPartitionSanitized || !this.partitioner.isPartitioningEnabled()) {
            return AsyncUtil.DONE;
        }
        return this.partitioner.getPartitionMetaInfoById(Objects.requireNonNull(this.partitionId), this.groupingKey).thenCompose(partitionInfo -> {
            CompletionStage getProperContinuationPartition;
            this.partitionKey = LucenePartitioner.getPartitionKey(partitionInfo);
            if (this.searchAfterPartitioningKey != null && (LucenePartitioner.isOlderThan(this.searchAfterPartitioningKey, partitionInfo) || LucenePartitioner.isNewerThan(this.searchAfterPartitioningKey, partitionInfo))) {
                this.dontResetSearchAfter = true;
                getProperContinuationPartition = this.partitioner.findPartitionInfo(this.groupingKey, this.searchAfterPartitioningKey).thenCompose(properPartitionInfo -> {
                    if (properPartitionInfo != null) {
                        this.partitionId = properPartitionInfo.getId();
                        this.partitionKey = LucenePartitioner.getPartitionKey(properPartitionInfo);
                        Objects.requireNonNull(this.searchAfter).doc = Math.min(this.searchAfter.doc, properPartitionInfo.getCount() - 1);
                    }
                    return AsyncUtil.DONE;
                });
            } else {
                if (this.searchAfter != null) {
                    this.searchAfter.doc = Math.min(this.searchAfter.doc, partitionInfo.getCount() - 1);
                }
                getProperContinuationPartition = AsyncUtil.DONE;
            }
            return getProperContinuationPartition.thenApply(ignored -> {
                this.continuationPartitionSanitized = true;
                return null;
            });
        });
    }

    private CompletableFuture<RecordCursorResult<IndexEntry>> switchToNextPartitionAndContinue(RecordCursorResult<IndexEntry> recordCursorResult) {
        if (recordCursorResult.hasNext() || this.partitionKey == null || recordCursorResult.getNoNextReason() != RecordCursor.NoNextReason.SOURCE_EXHAUSTED) {
            return CompletableFuture.completedFuture(recordCursorResult);
        }
        CompletionStage<LucenePartitionInfoProto.LucenePartitionInfo> nextPartitionFuture = this.sortedByPartitioningKey && !this.isReverseSort ? this.partitioner.getPartitionMetaInfoById(this.partitionId, this.groupingKey).thenCompose(curPartition -> LucenePartitioner.getNextNewerPartitionInfo(this.state.context, this.groupingKey, LucenePartitioner.getPartitionKey(curPartition), this.state.indexSubspace)) : LucenePartitioner.getNextOlderPartitionInfo(this.state.context, Objects.requireNonNull(this.groupingKey), this.partitionKey, this.state.indexSubspace);
        return nextPartitionFuture.thenCompose(nextPartition -> {
            if (nextPartition != null && nextPartition.getId() != this.partitionId.intValue()) {
                this.exhausted = false;
                this.partitionKey = LucenePartitioner.getPartitionKey(nextPartition);
                this.partitionId = nextPartition.getId();
                if (!this.dontResetSearchAfter) {
                    this.searchAfter = null;
                    this.searchAfterPartitioningKey = null;
                } else {
                    this.dontResetSearchAfter = false;
                }
                this.currentPosition = 0;
                if (this.skip > 0) {
                    this.skip = this.leftToSkip;
                }
                try {
                    this.maybePerformScan();
                    return this.lookupResults.onNext().thenCompose(this::switchToNextPartitionAndContinue);
                }
                catch (IOException ioException) {
                    throw LuceneExceptions.toRecordCoreException(ioException.getMessage(), ioException, LogMessageKeys.QUERY, this.query);
                }
            }
            return CompletableFuture.completedFuture(this.nextResult);
        });
    }

    public void close() {
        if (this.indexReader != null) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.indexReader});
        }
        this.indexReader = null;
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Nonnull
    public Executor getExecutor() {
        return this.executor;
    }

    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        visitor.visitEnter((RecordCursor)this);
        return visitor.visitLeave((RecordCursor)this);
    }

    private synchronized IndexReader getIndexReader() throws IOException {
        return FDBDirectoryManager.getManager(this.state).getIndexReader(this.groupingKey, this.partitionId);
    }

    private void maybePerformScan() throws IOException {
        if (this.lookupResults != null) {
            this.lookupResults.close();
        }
        int limit = this.limitRemaining == Integer.MAX_VALUE ? this.pageSize : Math.min(this.limitRemaining + this.leftToSkip, this.pageSize);
        TopDocs newTopDocs = this.searchForTopDocs(limit);
        this.lookupResults = RecordCursor.fromIterator((Executor)this.executor, Arrays.stream(newTopDocs.scoreDocs).iterator()).skip(this.leftToSkip).mapPipelined(this::buildIndexEntryFromScoreDocAsync, this.state.store.getPipelineSize(PipelineOperation.KEY_TO_RECORD)).mapResult(result -> {
            if (result.hasNext() && this.limitManager.tryRecordScan()) {
                LuceneCursorContinuation continuationFromDoc = LuceneCursorContinuation.fromScoreDoc(Objects.requireNonNull((ScoreDocIndexEntry)((Object)((Object)result.get()))).scoreDoc, this.partitionId, this.partitionKey);
                ++this.currentPosition;
                if (this.limitRemaining != Integer.MAX_VALUE) {
                    --this.limitRemaining;
                }
                this.nextResult = RecordCursorResult.withNextValue((Object)((IndexEntry)result.get()), (RecordCursorContinuation)continuationFromDoc);
            } else if (this.exhausted) {
                this.nextResult = RecordCursorResult.exhausted();
            } else if (this.limitRemaining <= 0) {
                LuceneCursorContinuation continuationFromDoc = LuceneCursorContinuation.fromScoreDoc(this.searchAfter, this.partitionId, this.partitionKey);
                this.nextResult = RecordCursorResult.withoutNextValue((RecordCursorContinuation)continuationFromDoc, (RecordCursor.NoNextReason)RecordCursor.NoNextReason.RETURN_LIMIT_REACHED);
            } else {
                Optional stoppedReason = this.limitManager.getStoppedReason();
                if (stoppedReason.isEmpty()) {
                    throw new RecordCoreException("limit manager stopped LuceneRecordCursor but did not report a reason", new Object[0]);
                }
                this.nextResult = RecordCursorResult.withoutNextValue((RecordCursorContinuation)LuceneCursorContinuation.fromScoreDoc(this.searchAfter, this.partitionId, this.partitionKey), (RecordCursor.NoNextReason)((RecordCursor.NoNextReason)stoppedReason.get()));
            }
            return this.nextResult;
        });
        this.leftToSkip = Math.max(0, this.leftToSkip - newTopDocs.scoreDocs.length);
    }

    private TopDocs searchForTopDocs(int limit) throws IOException {
        long startTime = System.nanoTime();
        this.indexReader = this.getIndexReader();
        this.searcher = new LuceneOptimizedIndexSearcher(this.indexReader, this.executorService);
        Object newTopDocs = this.searchAfter != null && this.sort != null ? this.searcher.searchAfter(this.searchAfter, this.query, limit, this.sort) : (this.searchAfter != null ? this.searcher.searchAfter(this.searchAfter, this.query, limit) : (this.sort != null ? this.searcher.search(this.query, limit, this.sort) : this.searcher.search(this.query, limit)));
        if (newTopDocs.scoreDocs.length < limit) {
            this.exhausted = true;
        }
        if (newTopDocs.scoreDocs.length != 0) {
            this.searchAfter = newTopDocs.scoreDocs[newTopDocs.scoreDocs.length - 1];
        }
        if (this.timer != null) {
            this.timer.recordSinceNanoTime((StoreTimer.Event)LuceneEvents.Events.LUCENE_INDEX_SCAN, startTime);
            this.timer.increment((StoreTimer.Count)LuceneEvents.Counts.LUCENE_SCAN_MATCHED_DOCUMENTS, newTopDocs.scoreDocs.length);
        }
        return newTopDocs;
    }

    private CompletableFuture<ScoreDocIndexEntry> buildIndexEntryFromScoreDocAsync(@Nonnull ScoreDoc scoreDoc) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Tuple tuple;
                int[] keyPos;
                int i;
                Document document = this.searcher.doc(scoreDoc.doc, this.storedFieldsToReturn);
                IndexableField primaryKey = document.getField("_p");
                BytesRef pk = primaryKey.binaryValue();
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("document={}", (Object)document);
                    LOGGER.trace("primary key read={}", (Object)Tuple.fromBytes((byte[])pk.bytes, (int)pk.offset, (int)pk.length));
                }
                if (this.timer != null) {
                    this.timer.increment((StoreTimer.Count)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY);
                }
                Tuple setPrimaryKey = Tuple.fromBytes((byte[])pk.bytes);
                ArrayList fieldValues = Lists.newArrayList(this.fields);
                if (this.groupingKey != null) {
                    for (i = 0; i < this.groupingKey.size(); ++i) {
                        fieldValues.set(i, this.groupingKey.get(i));
                    }
                }
                if (this.storedFields != null) {
                    for (i = 0; i < this.storedFields.size(); ++i) {
                        if (this.storedFieldTypes.get(i) == null) continue;
                        Object value = null;
                        IndexableField docField = document.getField(this.storedFields.get(i));
                        if (docField != null) {
                            switch (this.storedFieldTypes.get(i)) {
                                case STRING: {
                                    value = docField.stringValue();
                                    break;
                                }
                                case BOOLEAN: {
                                    value = Boolean.valueOf(docField.stringValue());
                                    break;
                                }
                                case INT: 
                                case LONG: 
                                case DOUBLE: {
                                    value = docField.numericValue();
                                    break;
                                }
                            }
                        }
                        fieldValues.set(i, value);
                    }
                }
                if ((keyPos = this.state.index.getPrimaryKeyComponentPositions()) != null) {
                    ArrayList leftovers = Lists.newArrayList();
                    for (int i2 = 0; i2 < keyPos.length; ++i2) {
                        if (keyPos[i2] > -1) {
                            fieldValues.set(keyPos[i2], setPrimaryKey.get(i2));
                            continue;
                        }
                        leftovers.add(setPrimaryKey.get(i2));
                    }
                    tuple = Tuple.fromList((List)fieldValues).addAll((List)leftovers);
                } else {
                    tuple = Tuple.fromList((List)fieldValues).addAll(setPrimaryKey);
                }
                return new ScoreDocIndexEntry(scoreDoc, this.state.index, tuple, this.luceneQueryHighlightParameters, this.termMap, this.analyzerSelector, this.autoCompleteAnalyzerSelector);
            }
            catch (IOException e) {
                throw LuceneExceptions.toRecordCoreException("Failed to get document", e, "currentPosition", this.currentPosition);
            }
        }, this.executor);
    }

    public static final class ScoreDocIndexEntry
    extends IndexEntry {
        private final ScoreDoc scoreDoc;
        private final Map<String, Set<String>> termMap;
        private final LuceneAnalyzerCombinationProvider analyzerSelector;
        private final LuceneAnalyzerCombinationProvider autoCompleteAnalyzerSelector;
        private final LuceneScanQueryParameters.LuceneQueryHighlightParameters luceneQueryHighlightParameters;
        private final KeyExpression indexKey;

        public ScoreDoc getScoreDoc() {
            return this.scoreDoc;
        }

        public Map<String, Set<String>> getTermMap() {
            return this.termMap;
        }

        public LuceneAnalyzerCombinationProvider getAnalyzerSelector() {
            return this.analyzerSelector;
        }

        public LuceneAnalyzerCombinationProvider getAutoCompleteAnalyzerSelector() {
            return this.autoCompleteAnalyzerSelector;
        }

        public LuceneScanQueryParameters.LuceneQueryHighlightParameters getLuceneQueryHighlightParameters() {
            return this.luceneQueryHighlightParameters;
        }

        public KeyExpression getIndexKey() {
            return this.indexKey;
        }

        private ScoreDocIndexEntry(@Nonnull ScoreDoc scoreDoc, @Nonnull Index index, @Nonnull Tuple key, @Nullable LuceneScanQueryParameters.LuceneQueryHighlightParameters luceneQueryHighlightParameters, @Nullable Map<String, Set<String>> termMap, @Nonnull LuceneAnalyzerCombinationProvider analyzerSelector, @Nonnull LuceneAnalyzerCombinationProvider autoCompleteAnalyzerSelector) {
            super(index, key, TupleHelpers.EMPTY);
            this.scoreDoc = scoreDoc;
            this.luceneQueryHighlightParameters = luceneQueryHighlightParameters;
            this.termMap = termMap;
            this.analyzerSelector = analyzerSelector;
            this.autoCompleteAnalyzerSelector = autoCompleteAnalyzerSelector;
            this.indexKey = index.getRootExpression();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ScoreDocIndexEntry that = (ScoreDocIndexEntry)((Object)o);
            return this.scoreDoc.score == that.scoreDoc.score && this.scoreDoc.doc == that.scoreDoc.doc;
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), Float.valueOf(this.scoreDoc.score), this.scoreDoc.doc);
        }
    }
}

