/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerCombinationProvider;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerRegistryImpl;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerType;
import com.apple.foundationdb.record.lucene.LuceneComparisonQuery;
import com.apple.foundationdb.record.lucene.LuceneIndexExpressions;
import com.apple.foundationdb.record.lucene.LuceneQueryClause;
import com.apple.foundationdb.record.lucene.LuceneQueryType;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;

@API(value=API.Status.UNSTABLE)
public abstract class LuceneQueryFieldComparisonClause
extends LuceneQueryClause {
    @Nonnull
    protected final String field;
    @Nonnull
    protected final LuceneIndexExpressions.DocumentFieldType fieldType;
    @Nonnull
    protected final Comparisons.Comparison comparison;

    protected LuceneQueryFieldComparisonClause(@Nonnull LuceneQueryType querType, @Nonnull String field, @Nonnull LuceneIndexExpressions.DocumentFieldType fieldType, @Nonnull Comparisons.Comparison comparison) {
        super(querType);
        this.field = field;
        this.fieldType = fieldType;
        this.comparison = comparison;
    }

    @Nonnull
    public String getField() {
        return this.field;
    }

    @Nonnull
    public LuceneIndexExpressions.DocumentFieldType getFieldType() {
        return this.fieldType;
    }

    @Nonnull
    public Comparisons.Comparison getComparison() {
        return this.comparison;
    }

    @Override
    public void getPlannerGraphDetails(@Nonnull ImmutableList.Builder<String> detailsBuilder, @Nonnull ImmutableMap.Builder<String, Attribute> attributeMapBuilder) {
        detailsBuilder.add((Object)"field: {{field}}");
        attributeMapBuilder.put((Object)"field", (Object)Attribute.gml((Object)this.field));
        detailsBuilder.add((Object)"fieldType: {{fieldType}}");
        attributeMapBuilder.put((Object)"fieldType", (Object)Attribute.gml((Object)((Object)this.fieldType)));
        detailsBuilder.add((Object)"comparisonType: {{comparisonType}}");
        attributeMapBuilder.put((Object)"comparisonType", (Object)Attribute.gml((Object)this.comparison.getType()));
        detailsBuilder.add((Object)"comparison: {{comparison}}");
        attributeMapBuilder.put((Object)"comparison", (Object)Attribute.gml((Object)this.comparison.typelessString()));
    }

    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash((PlanHashable.PlanHashMode)mode, (Object[])new Object[]{this.field, this.fieldType, this.comparison});
    }

    public String toString() {
        return this.field + ":" + String.valueOf((Object)this.fieldType) + " " + String.valueOf(this.comparison);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LuceneQueryFieldComparisonClause that = (LuceneQueryFieldComparisonClause)o;
        if (!this.field.equals(that.field)) {
            return false;
        }
        if (this.fieldType != that.fieldType) {
            return false;
        }
        return this.comparison.equals(that.comparison);
    }

    public int hashCode() {
        int result = this.field.hashCode();
        result = 31 * result + this.fieldType.hashCode();
        result = 31 * result + this.comparison.hashCode();
        return result;
    }

    @Nonnull
    public static LuceneQueryFieldComparisonClause create(@Nonnull LuceneQueryType queryType, @Nonnull String field, @Nonnull LuceneIndexExpressions.DocumentFieldType fieldType, boolean fieldNameOverride, @Nullable String namedFieldSuffix, @Nonnull Comparisons.Comparison comparison) {
        switch (comparison.getType()) {
            case NOT_NULL: 
            case IS_NULL: {
                return new NullQuery(queryType, field, fieldType, comparison);
            }
            case EQUALS: 
            case NOT_EQUALS: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUALS: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUALS: 
            case IN: {
                break;
            }
            case STARTS_WITH: {
                if (fieldType == LuceneIndexExpressions.DocumentFieldType.STRING) break;
            }
            case TEXT_CONTAINS_ALL: 
            case TEXT_CONTAINS_ANY: 
            case TEXT_CONTAINS_PHRASE: 
            case TEXT_CONTAINS_PREFIX: 
            case TEXT_CONTAINS_ALL_PREFIXES: 
            case TEXT_CONTAINS_ANY_PREFIX: {
                if (fieldType == LuceneIndexExpressions.DocumentFieldType.TEXT) break;
            }
            default: {
                throw new RecordCoreException("comparison type not supported for Lucene: " + String.valueOf(comparison.getType()), new Object[0]);
            }
        }
        switch (fieldType) {
            case STRING: 
            case TEXT: {
                return new StringQuery(queryType, field, fieldType, comparison);
            }
            case INT: {
                return new IntQuery(queryType, field, fieldType, comparison, fieldNameOverride, namedFieldSuffix);
            }
            case LONG: {
                return new LongQuery(queryType, field, fieldType, comparison, fieldNameOverride, namedFieldSuffix);
            }
            case DOUBLE: {
                return new DoubleQuery(queryType, field, fieldType, comparison, fieldNameOverride, namedFieldSuffix);
            }
        }
        throw new RecordCoreException("unsupported Lucene index field type: " + String.valueOf((Object)fieldType), new Object[0]);
    }

    protected String applyFieldNameConversion(boolean fieldNameOverride, String field, String namedFieldSuffix, Object comparand) {
        if (!fieldNameOverride) {
            return field;
        }
        int location = field.lastIndexOf(namedFieldSuffix);
        if (location == -1) {
            throw new RecordCoreArgumentException("Cannot find the replacement suffix in Lucene field name", new Object[0]).addLogInfo("fieldName", (Object)field).addLogInfo("suffix", (Object)namedFieldSuffix);
        }
        if (!(comparand instanceof String)) {
            throw new RecordCoreArgumentException("Comparand type for Lucene field comparison must be a String", new Object[0]).addLogInfo("fieldName", (Object)field).addLogInfo("comparandType", (Object)comparand.getClass().getName());
        }
        return field.substring(0, location) + String.valueOf(comparand);
    }

    protected Comparisons.Comparison applyComparisonConversion(boolean fieldNameOverride, Comparisons.Comparison comparison) {
        if (fieldNameOverride) {
            return new Comparisons.NullComparison(Comparisons.Type.NOT_NULL);
        }
        return comparison;
    }

    protected static Query negate(@Nonnull Query query) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
        builder.add(query, BooleanClause.Occur.MUST_NOT);
        return builder.build();
    }

    static class NullQuery
    extends LuceneQueryFieldComparisonClause {
        public NullQuery(@Nonnull LuceneQueryType queryType, @Nonnull String field, @Nonnull LuceneIndexExpressions.DocumentFieldType fieldType, @Nonnull Comparisons.Comparison comparison) {
            super(queryType, field, fieldType, comparison);
        }

        @Override
        public LuceneQueryClause.BoundQuery bind(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index, @Nonnull EvaluationContext context) {
            TermRangeQuery allValues = new TermRangeQuery(this.field, null, null, true, true);
            if (this.comparison.getType() == Comparisons.Type.NOT_NULL) {
                return this.toBoundQuery((Query)allValues);
            }
            Query negatedQuery = NullQuery.negate((Query)allValues);
            return this.toBoundQuery(negatedQuery);
        }
    }

    static class StringQuery
    extends LuceneQueryFieldComparisonClause {
        public StringQuery(@Nonnull LuceneQueryType queryType, @Nonnull String field, @Nonnull LuceneIndexExpressions.DocumentFieldType fieldType, @Nonnull Comparisons.Comparison comparison) {
            super(queryType, field, fieldType, comparison);
        }

        @Override
        public LuceneQueryClause.BoundQuery bind(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index, @Nonnull EvaluationContext context) {
            Object comparand = this.comparison.getComparand(store, context);
            if (comparand == null) {
                return this.toBoundQuery((Query)new MatchNoDocsQuery());
            }
            switch (this.comparison.getType()) {
                case EQUALS: {
                    return this.toBoundQuery((Query)new TermQuery(new Term(this.field, (String)comparand)));
                }
                case NOT_EQUALS: {
                    BooleanQuery.Builder builder = new BooleanQuery.Builder();
                    builder.add((Query)TermRangeQuery.newStringRange((String)this.field, null, (String)((String)comparand), (boolean)true, (boolean)false), BooleanClause.Occur.SHOULD);
                    builder.add((Query)TermRangeQuery.newStringRange((String)this.field, (String)((String)comparand), null, (boolean)false, (boolean)true), BooleanClause.Occur.SHOULD);
                    return this.toBoundQuery((Query)builder.build());
                }
                case LESS_THAN: {
                    return this.toBoundQuery((Query)TermRangeQuery.newStringRange((String)this.field, null, (String)((String)comparand), (boolean)true, (boolean)false));
                }
                case LESS_THAN_OR_EQUALS: {
                    return this.toBoundQuery((Query)TermRangeQuery.newStringRange((String)this.field, null, (String)((String)comparand), (boolean)true, (boolean)true));
                }
                case GREATER_THAN: {
                    return this.toBoundQuery((Query)TermRangeQuery.newStringRange((String)this.field, (String)((String)comparand), null, (boolean)false, (boolean)true));
                }
                case GREATER_THAN_OR_EQUALS: {
                    return this.toBoundQuery((Query)TermRangeQuery.newStringRange((String)this.field, (String)((String)comparand), null, (boolean)true, (boolean)true));
                }
                case STARTS_WITH: 
                case TEXT_CONTAINS_PREFIX: {
                    return this.toBoundQuery((Query)new PrefixQuery(new Term(this.field, (String)comparand)));
                }
                case TEXT_CONTAINS_PHRASE: {
                    try {
                        Map<String, LuceneIndexExpressions.DocumentFieldDerivation> fieldInfos = LuceneIndexExpressions.getDocumentFieldDerivations(index, store.getRecordMetaData());
                        LuceneAnalyzerCombinationProvider analyzerSelector = LuceneAnalyzerRegistryImpl.instance().getLuceneAnalyzerCombinationProvider(index, LuceneAnalyzerType.FULL_TEXT, fieldInfos);
                        QueryParser parser = new QueryParser(this.field, analyzerSelector.provideQueryAnalyzer().getAnalyzer());
                        return this.toBoundQuery(parser.parse("\"" + String.valueOf(comparand) + "\""));
                    }
                    catch (Exception ex) {
                        throw new RecordCoreArgumentException("Unable to parse phrase for query", (Throwable)ex);
                    }
                }
                case IN: 
                case TEXT_CONTAINS_ANY: {
                    BooleanQuery.Builder builder = new BooleanQuery.Builder();
                    for (String value : (List)comparand) {
                        builder.add((Query)new TermQuery(new Term(this.field, value)), BooleanClause.Occur.SHOULD);
                    }
                    return this.toBoundQuery((Query)builder.build());
                }
                case TEXT_CONTAINS_ALL: {
                    BooleanQuery.Builder builder = new BooleanQuery.Builder();
                    for (String value : (List)comparand) {
                        builder.add((Query)new TermQuery(new Term(this.field, value)), BooleanClause.Occur.MUST);
                    }
                    return this.toBoundQuery((Query)builder.build());
                }
                case TEXT_CONTAINS_ALL_PREFIXES: {
                    BooleanQuery.Builder builder = new BooleanQuery.Builder();
                    for (String value : (List)comparand) {
                        builder.add((Query)new PrefixQuery(new Term(this.field, value)), BooleanClause.Occur.MUST);
                    }
                    return this.toBoundQuery((Query)builder.build());
                }
                case TEXT_CONTAINS_ANY_PREFIX: {
                    BooleanQuery.Builder builder = new BooleanQuery.Builder();
                    for (String value : (List)comparand) {
                        builder.add((Query)new PrefixQuery(new Term(this.field, value)), BooleanClause.Occur.SHOULD);
                    }
                    return this.toBoundQuery((Query)builder.build());
                }
            }
            throw new RecordCoreException("comparison type not supported for String: " + String.valueOf(this.comparison.getType()), new Object[0]);
        }
    }

    static class IntQuery
    extends LuceneQueryFieldComparisonClause {
        private final boolean fieldNameOverride;
        private final String namedFieldSuffix;

        public IntQuery(@Nonnull LuceneQueryType queryType, @Nonnull String field, @Nonnull LuceneIndexExpressions.DocumentFieldType fieldType, @Nonnull Comparisons.Comparison comparison, boolean fieldNameOverride, String namedFieldSuffix) {
            super(queryType, field, fieldType, comparison);
            this.fieldNameOverride = fieldNameOverride;
            this.namedFieldSuffix = namedFieldSuffix;
        }

        @Override
        public LuceneQueryClause.BoundQuery bind(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index, @Nonnull EvaluationContext context) {
            Object comparand = this.comparison.getComparand(store, context);
            if (comparand == null) {
                return this.toBoundQuery((Query)new MatchNoDocsQuery());
            }
            String appliedFieldName = this.applyFieldNameConversion(this.fieldNameOverride, this.field, this.namedFieldSuffix, comparand);
            Comparisons.Comparison appliedComparison = this.applyComparisonConversion(this.fieldNameOverride, this.comparison);
            switch (appliedComparison.getType()) {
                case EQUALS: {
                    return this.toBoundQuery(IntPoint.newExactQuery((String)appliedFieldName, (int)((Integer)comparand)));
                }
                case NOT_EQUALS: {
                    int value = (Integer)comparand;
                    BooleanQuery.Builder builder = new BooleanQuery.Builder();
                    builder.add(IntPoint.newRangeQuery((String)appliedFieldName, (int)Integer.MIN_VALUE, (int)(value - 1)), BooleanClause.Occur.SHOULD);
                    builder.add(IntPoint.newRangeQuery((String)appliedFieldName, (int)(value + 1), (int)Integer.MAX_VALUE), BooleanClause.Occur.SHOULD);
                    return this.toBoundQuery((Query)builder.build());
                }
                case LESS_THAN: {
                    return this.toBoundQuery(IntPoint.newRangeQuery((String)appliedFieldName, (int)Integer.MIN_VALUE, (int)((Integer)comparand - 1)));
                }
                case LESS_THAN_OR_EQUALS: {
                    return this.toBoundQuery(IntPoint.newRangeQuery((String)appliedFieldName, (int)Integer.MIN_VALUE, (int)((Integer)comparand)));
                }
                case GREATER_THAN: {
                    return this.toBoundQuery(IntPoint.newRangeQuery((String)appliedFieldName, (int)((Integer)comparand + 1), (int)Integer.MAX_VALUE));
                }
                case GREATER_THAN_OR_EQUALS: {
                    return this.toBoundQuery(IntPoint.newRangeQuery((String)appliedFieldName, (int)((Integer)comparand), (int)Integer.MAX_VALUE));
                }
                case IN: {
                    return this.toBoundQuery(IntPoint.newSetQuery((String)appliedFieldName, (Collection)((List)comparand)));
                }
                case NOT_NULL: {
                    return this.toBoundQuery(IntPoint.newRangeQuery((String)appliedFieldName, (int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE));
                }
            }
            throw new RecordCoreException("comparison type not supported for Integer: " + String.valueOf(this.comparison.getType()), new Object[0]);
        }
    }

    static class LongQuery
    extends LuceneQueryFieldComparisonClause {
        private final boolean fieldNameOverride;
        private final String namedFieldSuffix;

        public LongQuery(@Nonnull LuceneQueryType queryType, @Nonnull String field, @Nonnull LuceneIndexExpressions.DocumentFieldType fieldType, @Nonnull Comparisons.Comparison comparison, boolean fieldNameOverride, String namedFieldSuffix) {
            super(queryType, field, fieldType, comparison);
            this.fieldNameOverride = fieldNameOverride;
            this.namedFieldSuffix = namedFieldSuffix;
        }

        @Override
        public LuceneQueryClause.BoundQuery bind(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index, @Nonnull EvaluationContext context) {
            Object comparand = this.comparison.getComparand(store, context);
            if (comparand == null) {
                return this.toBoundQuery((Query)new MatchNoDocsQuery());
            }
            String appliedFieldName = this.applyFieldNameConversion(this.fieldNameOverride, this.field, this.namedFieldSuffix, comparand);
            Comparisons.Comparison appliedComparison = this.applyComparisonConversion(this.fieldNameOverride, this.comparison);
            switch (appliedComparison.getType()) {
                case EQUALS: {
                    return this.toBoundQuery(new LuceneComparisonQuery(LongPoint.newExactQuery((String)appliedFieldName, (long)((Long)comparand)), appliedFieldName, this.comparison.getType(), comparand));
                }
                case NOT_EQUALS: {
                    long value = (Long)comparand;
                    BooleanQuery.Builder builder = new BooleanQuery.Builder();
                    builder.add((Query)new LuceneComparisonQuery(LongPoint.newRangeQuery((String)appliedFieldName, (long)Long.MIN_VALUE, (long)(value - 1L)), appliedFieldName, this.comparison.getType(), comparand), BooleanClause.Occur.SHOULD);
                    builder.add((Query)new LuceneComparisonQuery(LongPoint.newRangeQuery((String)appliedFieldName, (long)(value + 1L), (long)Long.MAX_VALUE), appliedFieldName, this.comparison.getType(), comparand), BooleanClause.Occur.SHOULD);
                    return this.toBoundQuery((Query)builder.build());
                }
                case LESS_THAN: {
                    return this.toBoundQuery(new LuceneComparisonQuery(LongPoint.newRangeQuery((String)appliedFieldName, (long)Long.MIN_VALUE, (long)((Long)comparand - 1L)), appliedFieldName, this.comparison.getType(), comparand));
                }
                case LESS_THAN_OR_EQUALS: {
                    return this.toBoundQuery(new LuceneComparisonQuery(LongPoint.newRangeQuery((String)appliedFieldName, (long)Long.MIN_VALUE, (long)((Long)comparand)), appliedFieldName, this.comparison.getType(), comparand));
                }
                case GREATER_THAN: {
                    return this.toBoundQuery(new LuceneComparisonQuery(LongPoint.newRangeQuery((String)appliedFieldName, (long)((Long)comparand + 1L), (long)Long.MAX_VALUE), appliedFieldName, this.comparison.getType(), comparand));
                }
                case GREATER_THAN_OR_EQUALS: {
                    return this.toBoundQuery(new LuceneComparisonQuery(LongPoint.newRangeQuery((String)appliedFieldName, (long)((Long)comparand), (long)Long.MAX_VALUE), appliedFieldName, this.comparison.getType(), comparand));
                }
                case IN: {
                    return this.toBoundQuery(LongPoint.newSetQuery((String)appliedFieldName, (Collection)((List)comparand)));
                }
                case NOT_NULL: {
                    return this.toBoundQuery(LongPoint.newRangeQuery((String)appliedFieldName, (long)Long.MIN_VALUE, (long)Long.MAX_VALUE));
                }
            }
            throw new RecordCoreException("comparison type not supported for Long: " + String.valueOf(this.comparison.getType()), new Object[0]);
        }
    }

    static class DoubleQuery
    extends LuceneQueryFieldComparisonClause {
        private final boolean fieldNameOverride;
        private final String namedFieldSuffix;

        public DoubleQuery(@Nonnull LuceneQueryType queryType, @Nonnull String field, @Nonnull LuceneIndexExpressions.DocumentFieldType fieldType, @Nonnull Comparisons.Comparison comparison, boolean fieldNameOverride, String namedFieldSuffix) {
            super(queryType, field, fieldType, comparison);
            this.fieldNameOverride = fieldNameOverride;
            this.namedFieldSuffix = namedFieldSuffix;
        }

        @Override
        public LuceneQueryClause.BoundQuery bind(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index, @Nonnull EvaluationContext context) {
            Object comparand = this.comparison.getComparand(store, context);
            if (comparand == null) {
                return this.toBoundQuery((Query)new MatchNoDocsQuery());
            }
            String appliedFieldName = this.applyFieldNameConversion(this.fieldNameOverride, this.field, this.namedFieldSuffix, comparand);
            Comparisons.Comparison appliedComparison = this.applyComparisonConversion(this.fieldNameOverride, this.comparison);
            switch (appliedComparison.getType()) {
                case EQUALS: {
                    return this.toBoundQuery(DoublePoint.newExactQuery((String)appliedFieldName, (double)((Double)comparand)));
                }
                case NOT_EQUALS: {
                    double value = (Double)comparand;
                    BooleanQuery.Builder builder = new BooleanQuery.Builder();
                    builder.add(DoublePoint.newRangeQuery((String)appliedFieldName, (double)Double.MIN_VALUE, (double)(value - 1.0)), BooleanClause.Occur.SHOULD);
                    builder.add(DoublePoint.newRangeQuery((String)appliedFieldName, (double)(value + 1.0), (double)Double.MAX_VALUE), BooleanClause.Occur.SHOULD);
                    return this.toBoundQuery((Query)builder.build());
                }
                case LESS_THAN: {
                    return this.toBoundQuery(DoublePoint.newRangeQuery((String)appliedFieldName, (double)Double.MIN_VALUE, (double)((Double)comparand - 1.0)));
                }
                case LESS_THAN_OR_EQUALS: {
                    return this.toBoundQuery(DoublePoint.newRangeQuery((String)appliedFieldName, (double)Double.MIN_VALUE, (double)((Double)comparand)));
                }
                case GREATER_THAN: {
                    return this.toBoundQuery(DoublePoint.newRangeQuery((String)appliedFieldName, (double)((Double)comparand + 1.0), (double)Double.MAX_VALUE));
                }
                case GREATER_THAN_OR_EQUALS: {
                    return this.toBoundQuery(DoublePoint.newRangeQuery((String)appliedFieldName, (double)((Double)comparand), (double)Double.MAX_VALUE));
                }
                case IN: {
                    return this.toBoundQuery(DoublePoint.newSetQuery((String)appliedFieldName, (Collection)((List)comparand)));
                }
                case NOT_NULL: {
                    return this.toBoundQuery(DoublePoint.newRangeQuery((String)appliedFieldName, (double)Double.MIN_VALUE, (double)Double.MAX_VALUE));
                }
            }
            throw new RecordCoreException("comparison type not supported for Double: " + String.valueOf(this.comparison.getType()), new Object[0]);
        }
    }
}

