/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.LuceneQueryType;
import com.apple.foundationdb.record.lucene.LuceneScanQueryParameters;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.ComponentWithNoChildren;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class LuceneQueryComponent
implements QueryComponent,
ComponentWithNoChildren {
    @Nonnull
    private final LuceneQueryType type;
    @Nonnull
    private final String query;
    private final boolean queryIsParameter;
    @Nonnull
    private final List<String> fields;
    @Nullable
    private final LuceneScanQueryParameters.LuceneQueryHighlightParameters luceneQueryHighlightParameters;
    @Nullable
    private final Set<String> explicitFieldNames;
    private final boolean multiFieldSearch;

    public LuceneQueryComponent(String query, List<String> fields) {
        this(query, fields, fields.isEmpty());
    }

    public LuceneQueryComponent(String query, List<String> fields, boolean multiField) {
        this(LuceneQueryType.QUERY, query, false, fields, multiField);
    }

    public LuceneQueryComponent(LuceneQueryType type, String query, boolean queryIsParameter, List<String> fields, boolean multiFieldSearch) {
        this(type, query, queryIsParameter, fields, multiFieldSearch, null, null);
    }

    public LuceneQueryComponent(LuceneQueryType type, String query, boolean queryIsParameter, List<String> fields, boolean multiFieldSearch, @Nullable LuceneScanQueryParameters.LuceneQueryHighlightParameters luceneQueryHighlightParameters, @Nullable Set<String> explicitFieldNames) {
        this.type = type;
        this.query = query;
        this.queryIsParameter = queryIsParameter;
        this.fields = fields;
        this.multiFieldSearch = multiFieldSearch;
        this.luceneQueryHighlightParameters = luceneQueryHighlightParameters;
        if (explicitFieldNames != null) {
            Preconditions.checkArgument((fields.size() == 1 ? 1 : 0) != 0);
            String fieldName = (String)Iterables.getOnlyElement(fields);
            Preconditions.checkArgument((boolean)explicitFieldNames.stream().allMatch(explicitFieldName -> explicitFieldName.startsWith(fieldName)));
            this.explicitFieldNames = ImmutableSet.copyOf(explicitFieldNames);
        } else {
            this.explicitFieldNames = null;
        }
    }

    @Nonnull
    public <M extends Message> Boolean evalMessage(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable FDBRecord<M> rec, @Nullable Message message) {
        throw new RecordCoreException("Residual lucene components are not yet supported", new Object[0]);
    }

    public void validate(@Nonnull Descriptors.Descriptor descriptor) {
    }

    @Nonnull
    public GraphExpansion expand(@Nonnull Quantifier.ForEach baseQuantifier, @Nonnull Supplier<Quantifier.ForEach> outerQuantifierSupplier, @Nonnull List<String> fieldNamePrefix) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public LuceneQueryType getType() {
        return this.type;
    }

    @Nonnull
    public String getQuery() {
        return this.query;
    }

    public boolean isQueryIsParameter() {
        return this.queryIsParameter;
    }

    @Nonnull
    public List<String> getFields() {
        return this.fields;
    }

    public boolean isMultiFieldSearch() {
        return this.multiFieldSearch;
    }

    @Nullable
    public LuceneScanQueryParameters.LuceneQueryHighlightParameters getLuceneQueryHighlightParameters() {
        return this.luceneQueryHighlightParameters;
    }

    @Nullable
    public Set<String> getExplicitFieldNames() {
        return this.explicitFieldNames;
    }

    @Nonnull
    public LuceneQueryComponent withNewFields(@Nonnull List<String> fields, @Nullable Set<String> explicitFieldNames) {
        return new LuceneQueryComponent(this.type, this.query, this.queryIsParameter, fields, this.multiFieldSearch, this.luceneQueryHighlightParameters, explicitFieldNames);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LuceneQueryComponent that = (LuceneQueryComponent)o;
        if (this.queryIsParameter != that.queryIsParameter) {
            return false;
        }
        if (this.multiFieldSearch != that.multiFieldSearch) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        if (!this.query.equals(that.query)) {
            return false;
        }
        if (!this.fields.equals(that.fields)) {
            return false;
        }
        return Objects.equals(this.explicitFieldNames, that.explicitFieldNames);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.query.hashCode();
        result = 31 * result + (this.queryIsParameter ? 1 : 0);
        result = 31 * result + this.fields.hashCode();
        result = 31 * result + (this.multiFieldSearch ? 1 : 0);
        if (this.explicitFieldNames != null) {
            result = 31 * result + this.explicitFieldNames.hashCode();
        }
        return result;
    }

    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash((PlanHashable.PlanHashMode)mode, (Object[])new Object[]{this.type, this.query});
    }

    @Nonnull
    public String toString() {
        return "LuceneQuery(" + this.query + ")";
    }
}

