/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.LuceneQueryType;
import com.apple.foundationdb.record.lucene.query.BitSetQuery;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SynonymQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;

@API(value=API.Status.UNSTABLE)
public abstract class LuceneQueryClause
implements PlanHashable {
    @Nonnull
    private final LuceneQueryType queryType;

    protected LuceneQueryClause(@Nonnull LuceneQueryType queryType) {
        this.queryType = queryType;
    }

    @Nonnull
    public LuceneQueryType getQueryType() {
        return this.queryType;
    }

    public abstract BoundQuery bind(@Nonnull FDBRecordStoreBase<?> var1, @Nonnull Index var2, @Nonnull EvaluationContext var3);

    public abstract void getPlannerGraphDetails(@Nonnull ImmutableList.Builder<String> var1, @Nonnull ImmutableMap.Builder<String, Attribute> var2);

    @Nonnull
    protected BoundQuery toBoundQuery(@Nonnull Query luceneQuery) {
        return BoundQuery.ofLuceneQueryWithQueryType(luceneQuery, this.getQueryType());
    }

    @Nonnull
    protected static Map<String, Set<String>> getHighlightingTermsMap(@Nonnull Query query) {
        HashMap highlightingTermsMap = Maps.newHashMap();
        if (query instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)query;
            for (BooleanClause clause : booleanQuery.clauses()) {
                LuceneQueryClause.combineHighlightingTermsMaps(highlightingTermsMap, LuceneQueryClause.getHighlightingTermsMap(clause.getQuery()));
            }
        } else if (query instanceof TermQuery) {
            TermQuery termQuery = (TermQuery)query;
            Term term = termQuery.getTerm();
            highlightingTermsMap.putIfAbsent(term.field(), new HashSet());
            ((Set)highlightingTermsMap.get(term.field())).add(term.text().toLowerCase(Locale.ROOT));
        } else if (query instanceof PhraseQuery) {
            PhraseQuery phraseQuery = (PhraseQuery)query;
            for (Term term : phraseQuery.getTerms()) {
                highlightingTermsMap.putIfAbsent(term.field(), new HashSet());
                ((Set)highlightingTermsMap.get(term.field())).add(term.text().toLowerCase(Locale.ROOT));
            }
        } else if (query instanceof MultiPhraseQuery) {
            MultiPhraseQuery multiPhraseQuery = (MultiPhraseQuery)query;
            Term[][] term = multiPhraseQuery.getTermArrays();
            int clause = term.length;
            for (int i = 0; i < clause; ++i) {
                Term[] termArray;
                for (Term term2 : termArray = term[i]) {
                    highlightingTermsMap.putIfAbsent(term2.field(), new HashSet());
                    ((Set)highlightingTermsMap.get(term2.field())).add(term2.text().toLowerCase(Locale.ROOT));
                }
            }
        } else if (query instanceof BoostQuery) {
            BoostQuery boostQuery = (BoostQuery)query;
            LuceneQueryClause.combineHighlightingTermsMaps(highlightingTermsMap, LuceneQueryClause.getHighlightingTermsMap(boostQuery.getQuery()));
        } else if (query instanceof SynonymQuery) {
            SynonymQuery synonymQuery = (SynonymQuery)query;
            for (Term term : synonymQuery.getTerms()) {
                highlightingTermsMap.putIfAbsent(term.field(), new HashSet());
                ((Set)highlightingTermsMap.get(term.field())).add(term.text().toLowerCase(Locale.ROOT));
            }
        } else if (query instanceof SpanOrQuery) {
            SpanOrQuery spanOrQuery = (SpanOrQuery)query;
            for (SpanQuery clause : spanOrQuery.getClauses()) {
                LuceneQueryClause.combineHighlightingTermsMaps(highlightingTermsMap, LuceneQueryClause.getHighlightingTermsMap((Query)clause));
            }
        } else if (query instanceof SpanNearQuery) {
            SpanNearQuery spanNearQuery = (SpanNearQuery)query;
            for (SpanQuery clause : spanNearQuery.getClauses()) {
                LuceneQueryClause.combineHighlightingTermsMaps(highlightingTermsMap, LuceneQueryClause.getHighlightingTermsMap((Query)clause));
            }
        } else if (query instanceof SpanTermQuery) {
            SpanTermQuery spanTermQuery = (SpanTermQuery)query;
            Term term = spanTermQuery.getTerm();
            highlightingTermsMap.putIfAbsent(term.field(), new HashSet());
            ((Set)highlightingTermsMap.get(term.field())).add(term.text().toLowerCase(Locale.ROOT));
        } else if (query instanceof PrefixQuery) {
            PrefixQuery termQuery = (PrefixQuery)query;
            Term term = termQuery.getPrefix();
            highlightingTermsMap.putIfAbsent(term.field(), new HashSet());
            ((Set)highlightingTermsMap.get(term.field())).add(term.text().toLowerCase(Locale.ROOT) + "*");
        } else if (query instanceof BitSetQuery) {
            BitSetQuery bitsetQuery = (BitSetQuery)query;
            String field = bitsetQuery.getField();
            highlightingTermsMap.computeIfAbsent(field, key -> new HashSet()).add(field.toLowerCase(Locale.ROOT));
        } else if (query instanceof PointRangeQuery) {
            PointRangeQuery pointRangeQuery = (PointRangeQuery)query;
            String field = pointRangeQuery.getField();
            highlightingTermsMap.computeIfAbsent(field, key -> new HashSet()).add(field.toLowerCase(Locale.ROOT));
        } else {
            throw new RecordCoreException("This lucene query is not supported for highlighting", new Object[0]);
        }
        return highlightingTermsMap;
    }

    @Nonnull
    @CanIgnoreReturnValue
    protected static Map<String, Set<String>> combineHighlightingTermsMaps(@Nonnull Map<String, Set<String>> existingMap, @Nonnull Map<String, Set<String>> newMap) {
        newMap.forEach((field, newTerms) -> existingMap.merge((String)field, (Set<String>)newTerms, (o, n) -> {
            HashSet terms = Sets.newHashSet((Iterable)o);
            terms.addAll(n);
            return terms;
        }));
        return existingMap;
    }

    public static class BoundQuery {
        @Nonnull
        private final Query luceneQuery;
        @Nullable
        private final Map<String, Set<String>> highlightingTermsMap;

        public BoundQuery(@Nonnull Query luceneQuery) {
            this(luceneQuery, null);
        }

        public BoundQuery(@Nonnull Query luceneQuery, @Nullable Map<String, Set<String>> highlightingTermsMap) {
            this.luceneQuery = luceneQuery;
            this.highlightingTermsMap = highlightingTermsMap;
        }

        @Nonnull
        public Query getLuceneQuery() {
            return this.luceneQuery;
        }

        @Nullable
        public Map<String, Set<String>> getHighlightingTermsMap() {
            return this.highlightingTermsMap;
        }

        public static BoundQuery ofLuceneQueryWithQueryType(@Nonnull Query luceneQuery, @Nonnull LuceneQueryType queryType) {
            if (queryType == LuceneQueryType.QUERY_HIGHLIGHT) {
                return new BoundQuery(luceneQuery, LuceneQueryClause.getHighlightingTermsMap(luceneQuery));
            }
            return new BoundQuery(luceneQuery);
        }
    }
}

