/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.Range;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.lucene.LuceneConcurrency;
import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.LucenePrimaryKeySegmentIndex;
import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedStoredFieldsReader;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.KeyValueCursor;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.StandardDirectoryReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LucenePrimaryKeySegmentIndexV2
implements LucenePrimaryKeySegmentIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(LucenePrimaryKeySegmentIndexV2.class);
    @Nonnull
    private final FDBDirectory directory;
    @Nonnull
    private final Subspace subspace;

    public LucenePrimaryKeySegmentIndexV2(@Nonnull FDBDirectory directory, @Nonnull Subspace subspace) {
        this.directory = directory;
        this.subspace = subspace;
    }

    @Override
    @VisibleForTesting
    public List<List<Object>> readAllEntries() {
        AtomicReference list = new AtomicReference();
        this.directory.getAgilityContext().accept(aContext -> this.readAllEntries((FDBRecordContext)aContext, list));
        return (List)list.get();
    }

    private void readAllEntries(FDBRecordContext aContext, AtomicReference<List<List<Object>>> list) {
        List tuples;
        try (KeyValueCursor kvs = ((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.newBuilder((Subspace)this.subspace).setContext(aContext)).setScanProperties(ScanProperties.FORWARD_SCAN)).build();
             RecordCursor entries = kvs.map(kv -> this.subspace.unpack(kv.getKey()));){
            tuples = (List)LuceneConcurrency.asyncToSync(LuceneEvents.Waits.WAIT_LUCENE_FIND_PRIMARY_KEY, entries.asList(), aContext);
        }
        list.set(tuples.stream().map(t -> {
            List items = t.getItems();
            String name = this.directory.primaryKeySegmentName((Long)items.get(items.size() - 2));
            if (name != null) {
                items.set(items.size() - 2, name);
            }
            items.set(items.size() - 1, ((Long)items.get(items.size() - 1)).intValue());
            return items;
        }).collect(Collectors.toList()));
    }

    @Override
    public List<String> findSegments(@Nonnull Tuple primaryKey) throws IOException {
        try {
            return (List)this.directory.asyncToSync(LuceneEvents.Waits.WAIT_LUCENE_FIND_PRIMARY_KEY, this.directory.getAgilityContext().apply(context -> {
                Subspace keySubspace = this.subspace.subspace(primaryKey);
                KeyValueCursor kvs = ((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.newBuilder((Subspace)keySubspace).setContext(context)).setScanProperties(ScanProperties.FORWARD_SCAN)).build();
                return kvs.map(kv -> {
                    Tuple segdoc = keySubspace.unpack(kv.getKey());
                    long segid = segdoc.getLong(0);
                    String segmentName = this.directory.primaryKeySegmentName(segid);
                    if (segmentName != null) {
                        return segmentName;
                    }
                    return "#" + segid;
                }).asList().whenComplete((result, err) -> kvs.close());
            }));
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    @Override
    @Nullable
    public LucenePrimaryKeySegmentIndex.DocumentIndexEntry findDocument(@Nonnull DirectoryReader directoryReader, @Nonnull Tuple primaryKey) throws IOException {
        try {
            AtomicReference doc = new AtomicReference();
            this.directory.getAgilityContext().accept(aContext -> this.findDocument((FDBRecordContext)aContext, doc, directoryReader, primaryKey));
            return (LucenePrimaryKeySegmentIndex.DocumentIndexEntry)doc.get();
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    private void findDocument(FDBRecordContext aContext, AtomicReference<LucenePrimaryKeySegmentIndex.DocumentIndexEntry> doc, @Nonnull DirectoryReader directoryReader, @Nonnull Tuple primaryKey) {
        SegmentInfos segmentInfos = ((StandardDirectoryReader)FilterDirectoryReader.unwrap((DirectoryReader)directoryReader)).getSegmentInfos();
        Subspace keySubspace = this.subspace.subspace(primaryKey);
        try (KeyValueCursor kvs = ((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.newBuilder((Subspace)keySubspace).setContext(aContext)).setScanProperties(ScanProperties.FORWARD_SCAN)).build();
             RecordCursor documents = kvs.map(kv -> {
            Tuple segdoc = keySubspace.unpack(kv.getKey());
            long segid = segdoc.getLong(0);
            String segmentName = this.directory.primaryKeySegmentName(segid);
            if (segmentName == null) {
                return null;
            }
            for (int i = 0; i < segmentInfos.size(); ++i) {
                SegmentInfo segmentInfo = segmentInfos.info((int)i).info;
                if (!segmentInfo.name.equals(segmentName)) continue;
                int docid = (int)segdoc.getLong(1);
                return new LucenePrimaryKeySegmentIndex.DocumentIndexEntry(primaryKey, kv.getKey(), (IndexReader)((LeafReaderContext)directoryReader.leaves().get(i)).reader(), segmentName, docid);
            }
            return null;
        }).filter(Objects::nonNull);){
            doc.set(((Optional)this.directory.asyncToSync(LuceneEvents.Waits.WAIT_LUCENE_FIND_PRIMARY_KEY, documents.first())).orElse(null));
        }
    }

    @Override
    public void addOrDeletePrimaryKeyEntry(@Nonnull byte[] primaryKey, long segmentId, int docId, boolean add, String segmentName) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("pkey " + (add ? "Adding" : "Deling") + " #" + segmentId + "(" + segmentName + ")" + String.valueOf(Tuple.fromBytes((byte[])primaryKey)));
        }
        byte[] entryKey = ByteArrayUtil.join((byte[][])new byte[][]{this.subspace.getKey(), primaryKey, Tuple.from((Object[])new Object[]{segmentId, docId}).pack()});
        if (add) {
            this.directory.getAgilityContext().set(entryKey, new byte[0]);
        } else {
            this.directory.getAgilityContext().clear(entryKey);
        }
    }

    @Override
    public void clearForSegment(String segmentName) throws IOException {
        List<byte[]> primaryKeys = LuceneOptimizedStoredFieldsReader.getPrimaryKeys(segmentName, this.directory);
        long segmentId = this.directory.primaryKeySegmentId(segmentName, true);
        for (byte[] primaryKey : primaryKeys) {
            byte[] entryKey = ByteArrayUtil.join((byte[][])new byte[][]{this.subspace.getKey(), primaryKey, Tuple.from((Object[])new Object[]{segmentId}).pack()});
            this.directory.getAgilityContext().clear(Range.startsWith((byte[])entryKey));
        }
    }
}

