/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordStoreState;
import com.apple.foundationdb.record.lucene.LuceneAutoCompleteQueryClause;
import com.apple.foundationdb.record.lucene.LuceneBooleanQuery;
import com.apple.foundationdb.record.lucene.LuceneFunctionKeyExpression;
import com.apple.foundationdb.record.lucene.LuceneIndexExpressions;
import com.apple.foundationdb.record.lucene.LuceneIndexQueryPlan;
import com.apple.foundationdb.record.lucene.LuceneNotQuery;
import com.apple.foundationdb.record.lucene.LuceneQueryClause;
import com.apple.foundationdb.record.lucene.LuceneQueryComponent;
import com.apple.foundationdb.record.lucene.LuceneQueryFieldComparisonClause;
import com.apple.foundationdb.record.lucene.LuceneQueryMultiFieldSearchClause;
import com.apple.foundationdb.record.lucene.LuceneQuerySearchClause;
import com.apple.foundationdb.record.lucene.LuceneQueryType;
import com.apple.foundationdb.record.lucene.LuceneScanParameters;
import com.apple.foundationdb.record.lucene.LuceneScanQueryParameters;
import com.apple.foundationdb.record.lucene.LuceneScanSpellCheckParameters;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.expressions.EmptyKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.FunctionKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.query.QueryToKeyMatcher;
import com.apple.foundationdb.record.query.expressions.AndComponent;
import com.apple.foundationdb.record.query.expressions.AndOrComponent;
import com.apple.foundationdb.record.query.expressions.BaseField;
import com.apple.foundationdb.record.query.expressions.ComponentWithSingleChild;
import com.apple.foundationdb.record.query.expressions.FieldWithComparison;
import com.apple.foundationdb.record.query.expressions.NestedField;
import com.apple.foundationdb.record.query.expressions.NotComponent;
import com.apple.foundationdb.record.query.expressions.OneOfThemWithComponent;
import com.apple.foundationdb.record.query.expressions.OrComponent;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.PlanOrderingKey;
import com.apple.foundationdb.record.query.plan.PlannableIndexTypes;
import com.apple.foundationdb.record.query.plan.RecordQueryPlanner;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.planning.FilterSatisfiedMask;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LucenePlanner
extends RecordQueryPlanner {
    private static final Logger logger = LoggerFactory.getLogger(LucenePlanner.class);

    public LucenePlanner(@Nonnull RecordMetaData metaData, @Nonnull RecordStoreState recordStoreState, PlannableIndexTypes indexTypes, FDBStoreTimer timer) {
        super(metaData, recordStoreState, indexTypes, (StoreTimer)timer);
    }

    @Nullable
    protected RecordQueryPlanner.ScoredPlan planOther(@Nonnull RecordQueryPlanner.CandidateScan candidateScan, @Nonnull Index index, @Nonnull QueryComponent filter, @Nullable KeyExpression sort, boolean sortReverse, @Nullable KeyExpression commonPrimaryKey) {
        if (index.getType().equals("lucene")) {
            return this.planLucene(candidateScan, index, filter, sort, sortReverse, commonPrimaryKey);
        }
        return super.planOther(candidateScan, index, filter, sort, sortReverse, commonPrimaryKey);
    }

    @Nullable
    private RecordQueryPlanner.ScoredPlan planLucene(@Nonnull RecordQueryPlanner.CandidateScan candidateScan, @Nonnull Index index, @Nonnull QueryComponent filter, @Nullable KeyExpression sort, boolean sortReverse, @Nullable KeyExpression commonPrimaryKey) {
        ScanComparisons groupingComparisons;
        KeyExpression groupingKey;
        RecordMetaData metaData = this.getRecordMetaData();
        Collection recordTypes = metaData.recordTypesForIndex(index);
        if (recordTypes.size() != 1) {
            return null;
        }
        FilterSatisfiedMask filterMask = FilterSatisfiedMask.of((QueryComponent)filter);
        KeyExpression rootExp = index.getRootExpression();
        if (rootExp instanceof GroupingKeyExpression) {
            groupingKey = ((GroupingKeyExpression)rootExp).getGroupingSubKey();
            QueryToKeyMatcher.Match groupingMatch = new QueryToKeyMatcher(filter).matchesCoveringKey(groupingKey, filterMask);
            if (!groupingMatch.getType().equals((Object)QueryToKeyMatcher.MatchType.EQUALITY)) {
                return null;
            }
            if (filterMask.allSatisfied()) {
                return null;
            }
            groupingComparisons = new ScanComparisons(groupingMatch.getEqualityComparisons(), Collections.emptySet());
        } else {
            groupingKey = null;
            groupingComparisons = ScanComparisons.EMPTY;
        }
        LucenePlanState state = new LucenePlanState(index, groupingComparisons, filter);
        state.documentFields = LuceneIndexExpressions.getDocumentFieldDerivations(index, metaData);
        QueryComponent queryComponent = state.groupingComparisons.isEmpty() ? state.filter : filterMask.getUnsatisfiedFilter();
        LuceneScanParameters scanParameters = this.getSpecialScan(state, filterMask, queryComponent);
        if (scanParameters == null) {
            LuceneQueryClause query = this.getQueryForFilter(LuceneQueryType.QUERY, state, filter, new ArrayList<String>(), filterMask);
            if (query == null) {
                return null;
            }
            if (!this.getSort(state, sort, sortReverse, commonPrimaryKey, groupingKey)) {
                return null;
            }
            this.getStoredFields(state);
            LuceneScanQueryParameters.LuceneQueryHighlightParameters highlightParameters = LucenePlanner.getHighlightParameters(queryComponent);
            scanParameters = new LuceneScanQueryParameters(groupingComparisons, query, state.sort, state.storedFields, state.storedFieldTypes, highlightParameters);
        }
        LuceneIndexQueryPlan plan = LuceneIndexQueryPlan.of(index.getName(), scanParameters, this.resolveFetchIndexRecords(candidateScan.getPlanContext()), false, state.planOrderingKey, state.storedFieldExpressions);
        plan = this.addTypeFilterIfNeeded(candidateScan, (RecordQueryPlan)plan, this.getPossibleTypes(index));
        if (filterMask.allSatisfied()) {
            filterMask.setSatisfied(true);
        }
        return new RecordQueryPlanner.ScoredPlan((RecordQueryPlan)plan, filterMask.getUnsatisfiedFilters(), Collections.emptyList(), this.computeSargedComparisons((RecordQueryPlan)plan), 11 - filterMask.getUnsatisfiedFilters().size(), state.repeated, false, false, null);
    }

    private static LuceneScanQueryParameters.LuceneQueryHighlightParameters getHighlightParameters(@Nonnull QueryComponent queryComponent) {
        if (queryComponent instanceof LuceneQueryComponent) {
            LuceneQueryComponent luceneQueryComponent = (LuceneQueryComponent)queryComponent;
            return luceneQueryComponent.getLuceneQueryHighlightParameters();
        }
        if (queryComponent instanceof NestedField) {
            return LucenePlanner.getHighlightParameters(((NestedField)queryComponent).getChild());
        }
        if (queryComponent instanceof AndOrComponent) {
            for (QueryComponent child : ((AndOrComponent)queryComponent).getChildren()) {
                LuceneScanQueryParameters.LuceneQueryHighlightParameters parameters = LucenePlanner.getHighlightParameters(child);
                if (parameters == null) continue;
                return parameters;
            }
        }
        return null;
    }

    @Nullable
    private LuceneScanParameters getSpecialScan(@Nonnull LucenePlanState state, @Nonnull FilterSatisfiedMask filterMask, @Nonnull QueryComponent queryComponent) {
        String prefix;
        QueryComponent component = queryComponent;
        ImmutableList.Builder prefixComponentsBuilder = ImmutableList.builder();
        while (component instanceof NestedField) {
            NestedField nestedField = (NestedField)component;
            prefixComponentsBuilder.add((Object)nestedField.getFieldName());
            component = nestedField.getChild();
        }
        ImmutableList prefixComponents = prefixComponentsBuilder.build();
        String string = prefix = prefixComponents.isEmpty() ? null : String.join((CharSequence)"_", (Iterable<? extends CharSequence>)prefixComponents);
        if (!(component instanceof LuceneQueryComponent)) {
            return null;
        }
        LuceneQueryComponent luceneQueryComponent = (LuceneQueryComponent)component;
        for (String field : luceneQueryComponent.getFields()) {
            Object fullyPrefixedField = prefix == null ? field : prefix + "_" + field;
            if (this.validateIndexField(state, (String)fullyPrefixedField)) continue;
            return null;
        }
        if (luceneQueryComponent.getType() != LuceneQueryType.SPELL_CHECK) {
            return null;
        }
        LuceneScanSpellCheckParameters scanParameters = new LuceneScanSpellCheckParameters(state.groupingComparisons, luceneQueryComponent.getQuery(), luceneQueryComponent.isQueryIsParameter());
        if (queryComponent != state.filter) {
            filterMask = filterMask.getChild(queryComponent);
        }
        filterMask.setSatisfied(true);
        return scanParameters;
    }

    @Nonnull
    private LuceneQueryComponent prefixFieldNames(@Nonnull LuceneQueryComponent luceneQueryComponent, @Nonnull List<String> prefix) {
        if (prefix.isEmpty()) {
            return luceneQueryComponent;
        }
        String name = String.join((CharSequence)"_", prefix);
        List<String> newFieldNames = luceneQueryComponent.getFields().stream().map(field -> name + "_" + field).collect(Collectors.toList());
        Set newExplicitFieldNames = luceneQueryComponent.getExplicitFieldNames() == null ? null : luceneQueryComponent.getExplicitFieldNames().stream().map(field -> name + "_" + field).collect(Collectors.toSet());
        return luceneQueryComponent.withNewFields(newFieldNames, newExplicitFieldNames);
    }

    @Nullable
    private LuceneQueryClause getQueryForFilter(@Nonnull LuceneQueryType queryType, @Nonnull LucenePlanState state, @Nonnull QueryComponent filter, @Nonnull List<String> parentFieldPath, @Nullable FilterSatisfiedMask filterMask) {
        if (filter instanceof LuceneQueryComponent) {
            return this.getQueryForLuceneComponent(state, (LuceneQueryComponent)filter, parentFieldPath, filterMask);
        }
        if (filter instanceof AndOrComponent) {
            return this.getQueryForAndOr(queryType, state, (AndOrComponent)filter, parentFieldPath, filterMask);
        }
        if (filter instanceof NotComponent) {
            return this.getQueryForNot(queryType, state, (NotComponent)filter, parentFieldPath, filterMask);
        }
        if (filter instanceof FieldWithComparison) {
            return this.getQueryForFieldWithComparison(queryType, state, (FieldWithComparison)filter, parentFieldPath, filterMask);
        }
        if (filter instanceof OneOfThemWithComponent) {
            return this.getQueryForNestedField(queryType, state, (BaseField)((OneOfThemWithComponent)filter), true, parentFieldPath, filterMask);
        }
        if (filter instanceof NestedField) {
            return this.getQueryForNestedField(queryType, state, (BaseField)((NestedField)filter), false, parentFieldPath, filterMask);
        }
        return null;
    }

    @Nullable
    private LuceneQueryClause getQueryForLuceneComponent(@Nonnull LucenePlanState state, @Nonnull LuceneQueryComponent filter, @Nonnull List<String> parentFieldPath, @Nullable FilterSatisfiedMask filterMask) {
        filter = this.prefixFieldNames(filter, parentFieldPath);
        for (String field : filter.getFields()) {
            if (this.validateIndexField(state, field)) continue;
            return null;
        }
        if (filterMask != null) {
            filterMask.setSatisfied(true);
        }
        switch (filter.getType()) {
            case AUTO_COMPLETE: {
                Collection<String> resolvedFields = filter.getExplicitFieldNames() == null ? filter.getFields() : filter.getExplicitFieldNames();
                return new LuceneAutoCompleteQueryClause(filter.getQuery(), filter.isQueryIsParameter(), resolvedFields);
            }
            case QUERY: 
            case QUERY_HIGHLIGHT: 
            case SPELL_CHECK: {
                if (filter.isMultiFieldSearch()) {
                    return new LuceneQueryMultiFieldSearchClause(filter.getType(), filter.getQuery(), filter.isQueryIsParameter());
                }
                return new LuceneQuerySearchClause(filter.getType(), filter.getQuery(), filter.isQueryIsParameter());
            }
        }
        throw new RecordCoreException("unknown type of lucene query component", new Object[0]);
    }

    @Nullable
    private LuceneQueryClause getQueryForAndOr(@Nonnull LuceneQueryType queryType, @Nonnull LucenePlanState state, @Nonnull AndOrComponent filter, @Nonnull List<String> parentFieldPath, @Nullable FilterSatisfiedMask filterMask) {
        Iterator subFilterMasks = filterMask != null ? filterMask.getChildren().iterator() : null;
        List filters = filter.getChildren();
        ArrayList<LuceneQueryClause> childClauses = new ArrayList<LuceneQueryClause>(filters.size());
        ArrayList<LuceneQueryClause> negatedChildren = new ArrayList<LuceneQueryClause>(0);
        BooleanClause.Occur occur = filter instanceof OrComponent ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST;
        for (QueryComponent subFilter : filters) {
            FilterSatisfiedMask childMask;
            LuceneQueryClause childClause = this.getQueryForFilter(queryType, state, subFilter, parentFieldPath, childMask = subFilterMasks != null ? (FilterSatisfiedMask)subFilterMasks.next() : null);
            if (childClause == null) {
                if (filter == state.filter && filter instanceof AndComponent) continue;
                return null;
            }
            if (childMask != null) {
                childMask.setSatisfied(true);
            }
            if (childClause instanceof LuceneBooleanQuery && ((LuceneBooleanQuery)childClause).getOccur() == occur) {
                childClauses.addAll(((LuceneBooleanQuery)childClause).getChildren());
                if (!(childClause instanceof LuceneNotQuery)) continue;
                negatedChildren.addAll(((LuceneNotQuery)childClause).getNegatedChildren());
                continue;
            }
            childClauses.add(childClause);
        }
        if (filterMask != null && filterMask.getUnsatisfiedFilters().isEmpty()) {
            filterMask.setSatisfied(true);
        }
        if (!negatedChildren.isEmpty()) {
            return new LuceneNotQuery(queryType, childClauses, negatedChildren);
        }
        if (childClauses.isEmpty()) {
            return null;
        }
        return new LuceneBooleanQuery(queryType, childClauses, occur);
    }

    @Nullable
    private LuceneQueryClause getQueryForNot(@Nonnull LuceneQueryType queryType, @Nonnull LucenePlanState state, @Nonnull NotComponent filter, @Nonnull List<String> parentFieldPath, @Nullable FilterSatisfiedMask filterMask) {
        LuceneQueryClause childClause = this.getQueryForFilter(queryType, state, filter.getChild(), parentFieldPath, filterMask == null ? null : (FilterSatisfiedMask)filterMask.getChildren().get(0));
        if (childClause == null) {
            return null;
        }
        if (filterMask != null) {
            filterMask.setSatisfied(true);
        }
        return LucenePlanner.negate(childClause);
    }

    @Nonnull
    private static LuceneQueryClause negate(@Nonnull LuceneQueryClause clause) {
        if (clause instanceof LuceneBooleanQuery) {
            LuceneBooleanQuery booleanQuery = (LuceneBooleanQuery)clause;
            switch (booleanQuery.getOccur()) {
                case MUST: {
                    ArrayList<LuceneQueryClause> clauses = new ArrayList<LuceneQueryClause>();
                    for (LuceneQueryClause child : booleanQuery.getChildren()) {
                        clauses.add(LucenePlanner.negate(child));
                    }
                    if (clause instanceof LuceneNotQuery) {
                        LuceneNotQuery notQuery = (LuceneNotQuery)clause;
                        if (clauses.isEmpty() && notQuery.getNegatedChildren().size() == 1) {
                            return notQuery.getNegatedChildren().get(0);
                        }
                        clauses.addAll(notQuery.getNegatedChildren());
                    }
                    return new LuceneBooleanQuery(clause.getQueryType(), clauses, BooleanClause.Occur.SHOULD);
                }
                case SHOULD: {
                    ArrayList<LuceneQueryClause> positive = new ArrayList<LuceneQueryClause>();
                    ArrayList<LuceneQueryClause> negative = new ArrayList<LuceneQueryClause>();
                    for (LuceneQueryClause child : booleanQuery.getChildren()) {
                        if (child instanceof LuceneBooleanQuery) {
                            positive.add(LucenePlanner.negate(child));
                            continue;
                        }
                        negative.add(child);
                    }
                    if (negative.isEmpty()) {
                        return new LuceneBooleanQuery(clause.getQueryType(), positive, BooleanClause.Occur.MUST);
                    }
                    return new LuceneNotQuery(clause.getQueryType(), positive, negative);
                }
            }
            throw new RecordCoreException("Unsupported boolean query occur: " + String.valueOf(booleanQuery), new Object[0]);
        }
        return new LuceneNotQuery(clause.getQueryType(), clause);
    }

    @Nullable
    private LuceneQueryClause getQueryForFieldWithComparison(@Nonnull LuceneQueryType queryType, @Nonnull LucenePlanState state, @Nonnull FieldWithComparison filter, @Nonnull List<String> fieldPath, @Nullable FilterSatisfiedMask filterSatisfiedMask) {
        if (filterSatisfiedMask != null && filterSatisfiedMask.isSatisfied()) {
            return null;
        }
        fieldPath.add(filter.getFieldName());
        LuceneIndexExpressions.DocumentFieldDerivation fieldDerivation = this.findIndexField(state, fieldPath);
        fieldPath.remove(fieldPath.size() - 1);
        if (fieldDerivation == null) {
            return null;
        }
        if (filterSatisfiedMask != null) {
            filterSatisfiedMask.setSatisfied(true);
        }
        try {
            return LuceneQueryFieldComparisonClause.create(queryType, fieldDerivation.getDocumentField(), fieldDerivation.getType(), fieldDerivation.isFieldNameOverride(), fieldDerivation.getNamedFieldSuffix(), filter.getComparison());
        }
        catch (RecordCoreException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("no query for comparison " + String.valueOf(filter), (Throwable)ex);
            }
            return null;
        }
    }

    @Nullable
    private LuceneQueryClause getQueryForNestedField(@Nonnull LuceneQueryType queryType, @Nonnull LucenePlanState state, @Nonnull BaseField filter, boolean repeated, @Nonnull List<String> fieldPath, @Nullable FilterSatisfiedMask mask) {
        QueryComponent child = ((ComponentWithSingleChild)filter).getChild();
        fieldPath.add(filter.getFieldName());
        LuceneQueryClause comparison = this.getQueryForFilter(queryType, state, child, fieldPath, mask != null ? mask.getChild(child) : null);
        fieldPath.remove(fieldPath.size() - 1);
        if (comparison != null) {
            if (mask != null) {
                mask.setSatisfied(true);
            }
            if (repeated) {
                state.repeated = true;
            }
        }
        return comparison;
    }

    @Nullable
    private LuceneIndexExpressions.DocumentFieldDerivation findIndexField(@Nonnull LucenePlanState state, @Nonnull List<String> fieldPath) {
        LuceneIndexExpressions.DocumentFieldDerivation fieldDerivation;
        if (fieldPath.size() == 1 && (fieldDerivation = state.documentFields.get(fieldPath.get(0))) != null && fieldDerivation.getRecordFieldPath().equals(fieldPath)) {
            return fieldDerivation;
        }
        for (LuceneIndexExpressions.DocumentFieldDerivation fieldDerivation2 : state.documentFields.values()) {
            if (!fieldDerivation2.getRecordFieldPath().equals(fieldPath)) continue;
            return fieldDerivation2;
        }
        return null;
    }

    private boolean validateIndexField(@Nonnull LucenePlanState state, @Nonnull String field) {
        for (LuceneIndexExpressions.DocumentFieldDerivation fieldDerivation : state.documentFields.values()) {
            if (!LucenePlanner.fieldMatchesPath(fieldDerivation, field)) continue;
            return true;
        }
        return false;
    }

    private boolean getSort(@Nonnull LucenePlanState state, @Nullable KeyExpression sort, boolean sortReverse, @Nullable KeyExpression commonPrimaryKey, @Nullable KeyExpression groupingKey) {
        int n;
        ArrayList<FunctionKeyExpression> sorts = new ArrayList<FunctionKeyExpression>();
        if (sort == null) {
            sorts.add(FunctionKeyExpression.create((String)"lucene_sort_by_relevance", (KeyExpression)EmptyKeyExpression.EMPTY));
            if (commonPrimaryKey != null) {
                sorts.addAll(commonPrimaryKey.normalizeKeyForPositions());
            }
        } else {
            sorts.addAll(sort.normalizeKeyForPositions());
        }
        if (groupingKey != null) {
            sorts.removeAll(groupingKey.normalizeKeyForPositions());
        }
        ArrayList<SortField> sortFields = new ArrayList<SortField>(sorts.size());
        List primaryKeys = null;
        int primaryKeyPosition = 0;
        boolean hasBuiltInSort = false;
        for (KeyExpression keyExpression : sorts) {
            if (primaryKeys != null && primaryKeyPosition < primaryKeys.size()) {
                if (!keyExpression.equals(primaryKeys.get(primaryKeyPosition))) {
                    return false;
                }
                ++primaryKeyPosition;
                continue;
            }
            SortField sortField = null;
            if (keyExpression instanceof LuceneFunctionKeyExpression.LuceneSortBy) {
                sortField = ((LuceneFunctionKeyExpression.LuceneSortBy)keyExpression).isRelevance() ? SortField.FIELD_SCORE : SortField.FIELD_DOC;
                hasBuiltInSort = true;
            } else {
                for (LuceneIndexExpressions.DocumentFieldDerivation documentField : state.documentFields.values()) {
                    SortField.Type type;
                    if (!documentField.isSorted() || !this.recordFieldPathMatches(keyExpression, documentField.getRecordFieldPath())) continue;
                    switch (documentField.getType()) {
                        case STRING: 
                        case BOOLEAN: {
                            type = SortField.Type.STRING;
                            break;
                        }
                        case INT: {
                            type = SortField.Type.INT;
                            break;
                        }
                        case LONG: {
                            type = SortField.Type.LONG;
                            break;
                        }
                        case DOUBLE: {
                            type = SortField.Type.DOUBLE;
                            break;
                        }
                        default: {
                            throw new RecordCoreException("Unsupported document field type for sorting: " + String.valueOf((Object)documentField.getType()) + ":" + documentField.getDocumentField(), new Object[0]);
                        }
                    }
                    sortField = new SortField(documentField.getDocumentField(), type, sortReverse);
                    break;
                }
            }
            if (sortField != null) {
                sortFields.add(sortField);
                continue;
            }
            if (primaryKeys == null && commonPrimaryKey != null) {
                primaryKeys = commonPrimaryKey.normalizeKeyForPositions();
                if (groupingKey != null) {
                    primaryKeys.removeAll(groupingKey.normalizeKeyForPositions());
                }
                if (keyExpression.equals(primaryKeys.get(primaryKeyPosition))) {
                    sortFields.add(new SortField("_s", SortField.Type.STRING, sortReverse));
                    ++primaryKeyPosition;
                    continue;
                }
            }
            return false;
        }
        state.sort = new Sort(sortFields.toArray(new SortField[0]));
        ArrayList<Object> orderingKeys = new ArrayList<Object>(sorts.size());
        boolean bl = false;
        if (groupingKey != null) {
            orderingKeys.addAll(groupingKey.normalizeKeyForPositions());
            n = orderingKeys.size();
        }
        orderingKeys.addAll(sorts);
        int primaryKeyStart = orderingKeys.size();
        if (primaryKeys != null && primaryKeyPosition < primaryKeys.size()) {
            orderingKeys.addAll(primaryKeys.subList(primaryKeyPosition, primaryKeys.size()));
        }
        if (!hasBuiltInSort) {
            state.planOrderingKey = new PlanOrderingKey(orderingKeys, n, primaryKeyStart, orderingKeys.size());
        }
        return true;
    }

    private void getStoredFields(@Nonnull LucenePlanState state) {
        List fields = state.index.getRootExpression().normalizeKeyForPositions();
        block0: for (LuceneIndexExpressions.DocumentFieldDerivation documentField : state.documentFields.values()) {
            if (!documentField.isStored()) continue;
            if (state.storedFields == null) {
                state.storedFields = new ArrayList<Object>(Collections.nCopies(fields.size(), null));
                state.storedFieldTypes = new ArrayList<Object>(Collections.nCopies(fields.size(), null));
                state.storedFieldExpressions = new ArrayList<KeyExpression>();
            }
            for (int i = 0; i < fields.size(); ++i) {
                KeyExpression fieldExpression = (KeyExpression)fields.get(i);
                if (!this.recordFieldPathMatches(fieldExpression, documentField.getRecordFieldPath())) continue;
                state.storedFields.set(i, documentField.getDocumentField());
                state.storedFieldTypes.set(i, documentField.getType());
                state.storedFieldExpressions.add(fieldExpression);
                continue block0;
            }
        }
    }

    private boolean recordFieldPathMatches(@Nonnull KeyExpression keyExpression, @Nonnull List<String> recordFieldPath) {
        int i = 0;
        while (true) {
            if (keyExpression instanceof FieldKeyExpression) {
                return i == recordFieldPath.size() - 1 && ((FieldKeyExpression)keyExpression).getFieldName().equals(recordFieldPath.get(i));
            }
            if (keyExpression instanceof NestingKeyExpression) {
                if (i < recordFieldPath.size() && ((NestingKeyExpression)keyExpression).getParent().getFieldName().equals(recordFieldPath.get(i))) {
                    keyExpression = ((NestingKeyExpression)keyExpression).getChild();
                    ++i;
                    continue;
                }
                return false;
            }
            if (keyExpression instanceof LuceneFunctionKeyExpression.LuceneSorted) {
                keyExpression = ((LuceneFunctionKeyExpression.LuceneSorted)keyExpression).getSortedExpression();
                continue;
            }
            if (!(keyExpression instanceof LuceneFunctionKeyExpression.LuceneStored)) break;
            keyExpression = ((LuceneFunctionKeyExpression.LuceneStored)keyExpression).getStoredExpression();
        }
        return false;
    }

    static boolean fieldMatchesPath(@Nonnull LuceneIndexExpressions.DocumentFieldDerivation fieldDerivation, @Nonnull String field) {
        StringBuilder path = null;
        for (String pathElement : fieldDerivation.getRecordFieldPath()) {
            if (path == null) {
                path = new StringBuilder(pathElement);
            } else {
                path.append("_").append(pathElement);
            }
            if (path.length() > field.length()) break;
            if (!path.toString().equals(field)) continue;
            return true;
        }
        return false;
    }

    static class LucenePlanState {
        @Nonnull
        final Index index;
        @Nonnull
        final ScanComparisons groupingComparisons;
        @Nonnull
        final QueryComponent filter;
        @Nullable
        Sort sort;
        @Nullable
        List<String> storedFields;
        @Nullable
        List<LuceneIndexExpressions.DocumentFieldType> storedFieldTypes;
        @Nullable
        List<KeyExpression> storedFieldExpressions;
        @Nullable
        PlanOrderingKey planOrderingKey;
        Map<String, LuceneIndexExpressions.DocumentFieldDerivation> documentFields;
        boolean repeated;

        LucenePlanState(@Nonnull Index index, @Nonnull ScanComparisons groupingComparisons, @Nonnull QueryComponent filter) {
            this.index = index;
            this.groupingComparisons = groupingComparisons;
            this.filter = filter;
        }
    }
}

