/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.lucene.LuceneLogMessageKeys;
import javax.annotation.Nonnull;
import org.apache.lucene.util.InfoStream;
import org.slf4j.Logger;

public class LuceneLoggerInfoStream
extends InfoStream {
    private final Logger loggerForStreamOutput;

    public LuceneLoggerInfoStream(@Nonnull Logger loggerForStreamOutput) {
        this.loggerForStreamOutput = loggerForStreamOutput;
    }

    public void message(String component, String message) {
        if (this.loggerForStreamOutput.isTraceEnabled()) {
            this.loggerForStreamOutput.trace(KeyValueLogMessage.of((String)message, (Object[])new Object[]{LuceneLogMessageKeys.COMPONENT, component}));
        }
    }

    public boolean isEnabled(String component) {
        return this.loggerForStreamOutput.isTraceEnabled();
    }

    public void close() {
    }
}

