/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.lucene.LuceneIndexKeyValueToPartialRecordUtils;
import com.apple.foundationdb.record.lucene.LuceneIndexQueryPlan;
import com.apple.foundationdb.record.lucene.LuceneScanParameters;
import com.apple.foundationdb.record.lucene.LuceneScanTypes;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBQueriedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanParameters;
import com.apple.foundationdb.record.query.plan.IndexKeyValueToPartialRecord;
import com.apple.foundationdb.record.query.plan.PlanOrderingKey;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.query.plan.plans.QueryPlanUtils;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIndexPlan;
import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LuceneIndexSpellCheckQueryPlan
extends LuceneIndexQueryPlan {
    protected LuceneIndexSpellCheckQueryPlan(@Nonnull String indexName, @Nonnull LuceneScanParameters scanParameters, @Nonnull RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords fetchIndexRecords, boolean reverse, @Nullable PlanOrderingKey planOrderingKey, @Nullable List<KeyExpression> storedFields) {
        super(indexName, scanParameters, fetchIndexRecords, reverse, planOrderingKey, storedFields);
    }

    @Nonnull
    public <M extends Message> RecordCursor<FDBQueriedRecord<M>> fetchIndexRecords(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext evaluationContext, @Nonnull Function<byte[], RecordCursor<IndexEntry>> entryCursorFunction, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        RecordMetaData metaData = store.getRecordMetaData();
        Index index = metaData.getIndex(this.indexName);
        Collection recordTypes = metaData.recordTypesForIndex(index);
        IndexScanType scanType = this.getScanType();
        RecordType recordType = (RecordType)Iterables.getOnlyElement((Iterable)recordTypes);
        return entryCursorFunction.apply(continuation).map(QueryPlanUtils.getCoveringIndexEntryToPartialRecordFunction(store, (String)recordType.getName(), (String)this.indexName, (IndexKeyValueToPartialRecord)LuceneIndexKeyValueToPartialRecordUtils.getToPartialRecord(index, recordType, scanType), (boolean)false));
    }

    @Override
    public boolean allowedForCoveringIndexPlan() {
        return false;
    }

    @Override
    @Nonnull
    protected RecordQueryIndexPlan withIndexScanParameters(@Nonnull IndexScanParameters newIndexScanParameters) {
        Verify.verify((boolean)(newIndexScanParameters instanceof LuceneScanParameters));
        Verify.verify((boolean)newIndexScanParameters.getScanType().equals((Object)LuceneScanTypes.BY_LUCENE_SPELL_CHECK));
        return new LuceneIndexSpellCheckQueryPlan(this.getIndexName(), (LuceneScanParameters)newIndexScanParameters, this.getFetchIndexRecords(), this.reverse, this.getPlanOrderingKey(), this.getStoredFields());
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain() {
        return ExplainTokensWithPrecedence.of((ExplainTokens)new ExplainTokens().addKeyword("LSISCAN").addOptionalWhitespace().addOpeningParen().addNested(ExplainPlanVisitor.indexDetails((RecordQueryIndexPlan)this)).addOptionalWhitespace().addClosingParen());
    }
}

