/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.lucene.LuceneDocumentFromRecord;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.LucenePartitioner;
import com.apple.foundationdb.record.lucene.LucenePrimaryKeySegmentIndex;
import com.apple.foundationdb.record.lucene.directory.FDBDirectoryManager;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexableRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.IndexScrubbingTools;
import com.apple.foundationdb.record.provider.foundationdb.indexes.ValueIndexScrubbingToolsMissing;
import com.apple.foundationdb.record.query.plan.RecordQueryPlanner;
import com.apple.foundationdb.record.query.plan.synthetic.SyntheticRecordFromStoredRecordPlan;
import com.apple.foundationdb.record.query.plan.synthetic.SyntheticRecordPlanner;
import com.apple.foundationdb.record.util.pair.Pair;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.index.DirectoryReader;

public class LuceneIndexScrubbingToolsMissing
extends ValueIndexScrubbingToolsMissing {
    private Collection<RecordType> recordTypes = null;
    private Index index;
    private boolean isSynthetic;
    @Nonnull
    private final LucenePartitioner partitioner;
    @Nonnull
    private final FDBDirectoryManager directoryManager;

    public LuceneIndexScrubbingToolsMissing(@Nonnull LucenePartitioner partitioner, @Nonnull FDBDirectoryManager directoryManager) {
        this.partitioner = partitioner;
        this.directoryManager = directoryManager;
    }

    public void presetCommonParams(Index index, boolean allowRepair, boolean isSynthetic, Collection<RecordType> types) {
        this.recordTypes = types;
        this.index = index;
        this.isSynthetic = isSynthetic;
        super.presetCommonParams(index, false, isSynthetic, types);
    }

    @Nullable
    public CompletableFuture<IndexScrubbingTools.Issue> handleOneItem(FDBRecordStore store, RecordCursorResult<FDBStoredRecord<Message>> result) {
        if (this.recordTypes == null || this.index == null) {
            throw new IllegalStateException("presetParams was not called appropriately for this scrubbing tool");
        }
        FDBStoredRecord rec = (FDBStoredRecord)result.get();
        if (rec == null || !this.recordTypes.contains(rec.getRecordType())) {
            return CompletableFuture.completedFuture(null);
        }
        return this.detectMissingIndexKeys(store, (FDBStoredRecord<Message>)rec).thenApply(missingIndexesKeys -> {
            if (missingIndexesKeys == null) {
                return null;
            }
            return new IndexScrubbingTools.Issue(KeyValueLogMessage.build((String)"Scrubber: missing index entry", (Object[])new Object[]{LogMessageKeys.KEY, rec.getPrimaryKey(), LogMessageKeys.GROUPING_KEY, missingIndexesKeys.getValue(), LogMessageKeys.REASON, missingIndexesKeys.getKey()}), FDBStoreTimer.Counts.INDEX_SCRUBBER_MISSING_ENTRIES, null);
        });
    }

    private CompletableFuture<Pair<MissingIndexReason, Tuple>> detectMissingIndexKeys(FDBRecordStore store, FDBStoredRecord<Message> rec) {
        AtomicReference<Pair<MissingIndexReason, Tuple>> issue = new AtomicReference<Pair<MissingIndexReason, Tuple>>();
        if (!this.isSynthetic) {
            return this.checkMissingIndexKey((FDBIndexableRecord<Message>)rec, issue).thenApply(ignore -> (Pair)issue.get());
        }
        RecordQueryPlanner queryPlanner = new RecordQueryPlanner(store.getRecordMetaData(), store.getRecordStoreState().withWriteOnlyIndexes(Collections.singletonList(this.index.getName())));
        SyntheticRecordPlanner syntheticPlanner = new SyntheticRecordPlanner(store, queryPlanner);
        SyntheticRecordFromStoredRecordPlan syntheticPlan = syntheticPlanner.forIndex(this.index);
        RecordCursor recordCursor = syntheticPlan.execute(store, rec);
        return ((CompletableFuture)AsyncUtil.whenAll((Collection)recordCursor.asStream().map(syntheticRecord -> this.checkMissingIndexKey((FDBIndexableRecord<Message>)syntheticRecord, issue)).collect(Collectors.toList())).whenComplete((ret, e) -> recordCursor.close())).thenApply(ignore -> (Pair)issue.get());
    }

    private CompletableFuture<Void> checkMissingIndexKey(FDBIndexableRecord<Message> rec, AtomicReference<Pair<MissingIndexReason, Tuple>> issue) {
        KeyExpression root = this.index.getRootExpression();
        Map<Tuple, List<LuceneDocumentFromRecord.DocumentField>> recordFields = LuceneDocumentFromRecord.getRecordFields(root, rec);
        if (recordFields.isEmpty()) {
            issue.compareAndSet(null, (Pair<MissingIndexReason, Tuple>)Pair.of((Object)((Object)MissingIndexReason.EMPTY_RECORDS_FIELDS), null));
            return AsyncUtil.DONE;
        }
        if (recordFields.size() == 1) {
            return this.checkMissingIndexKey(rec, recordFields.keySet().iterator().next(), issue);
        }
        return AsyncUtil.whenAll((Collection)recordFields.keySet().stream().map(groupingKey -> this.checkMissingIndexKey(rec, (Tuple)groupingKey, issue)).collect(Collectors.toList())).thenApply(ignore -> null);
    }

    private CompletableFuture<Void> checkMissingIndexKey(FDBIndexableRecord<Message> rec, Tuple groupingKey, AtomicReference<Pair<MissingIndexReason, Tuple>> issue) {
        if (!this.partitioner.isPartitioningEnabled()) {
            if (this.isMissingIndexKey(rec, null, groupingKey)) {
                issue.compareAndSet(null, (Pair<MissingIndexReason, Tuple>)Pair.of((Object)((Object)MissingIndexReason.NOT_IN_PK_SEGMENT_INDEX), null));
            }
            return AsyncUtil.DONE;
        }
        return this.partitioner.tryGetPartitionInfo(rec, groupingKey).thenApply(partitionInfo -> {
            if (partitionInfo == null) {
                issue.compareAndSet(null, Pair.of((Object)((Object)MissingIndexReason.NOT_IN_PARTITION), (Object)groupingKey));
            } else if (this.isMissingIndexKey(rec, partitionInfo.getId(), groupingKey)) {
                issue.compareAndSet(null, Pair.of((Object)((Object)MissingIndexReason.NOT_IN_PK_SEGMENT_INDEX), (Object)groupingKey));
            }
            return null;
        });
    }

    private boolean isMissingIndexKey(FDBIndexableRecord<Message> rec, Integer partitionId, Tuple groupingKey) {
        LucenePrimaryKeySegmentIndex segmentIndex = this.directoryManager.getDirectory(groupingKey, partitionId).getPrimaryKeySegmentIndex();
        if (segmentIndex == null) {
            throw new IllegalStateException("LucneIndexScrubbingToolsMissing without a LucenePrimaryKeySegmentIndex");
        }
        try {
            this.directoryManager.getIndexWriter(groupingKey, partitionId);
        }
        catch (IOException e) {
            throw LuceneExceptions.toRecordCoreException("failed getIndexWriter", e, new Object[0]);
        }
        try {
            DirectoryReader directoryReader = this.directoryManager.getWriterReader(groupingKey, partitionId);
            LucenePrimaryKeySegmentIndex.DocumentIndexEntry documentIndexEntry = segmentIndex.findDocument(directoryReader, rec.getPrimaryKey());
            if (documentIndexEntry == null) {
                return true;
            }
        }
        catch (IOException ex) {
            throw LuceneExceptions.toRecordCoreException("Error while finding document", ex, new Object[0]);
        }
        return false;
    }

    public static enum MissingIndexReason {
        NOT_IN_PARTITION,
        NOT_IN_PK_SEGMENT_INDEX,
        EMPTY_RECORDS_FIELDS;

    }
}

