/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorStartContinuation;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerCombinationProvider;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerRegistryImpl;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerType;
import com.apple.foundationdb.record.lucene.LuceneDocumentFromRecord;
import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.LuceneFunctionNames;
import com.apple.foundationdb.record.lucene.LuceneGetMetadataInfo;
import com.apple.foundationdb.record.lucene.LuceneIndexExpressions;
import com.apple.foundationdb.record.lucene.LuceneIndexScrubbingToolsMissing;
import com.apple.foundationdb.record.lucene.LuceneLogMessageKeys;
import com.apple.foundationdb.record.lucene.LuceneMetadataInfo;
import com.apple.foundationdb.record.lucene.LucenePartitionInfoProto;
import com.apple.foundationdb.record.lucene.LucenePartitioner;
import com.apple.foundationdb.record.lucene.LucenePrimaryKeySegmentIndex;
import com.apple.foundationdb.record.lucene.LuceneRecordContextProperties;
import com.apple.foundationdb.record.lucene.LuceneRecordCursor;
import com.apple.foundationdb.record.lucene.LuceneScanQuery;
import com.apple.foundationdb.record.lucene.LuceneScanSpellCheck;
import com.apple.foundationdb.record.lucene.LuceneScanTypes;
import com.apple.foundationdb.record.lucene.LuceneSpellCheckRecordCursor;
import com.apple.foundationdb.record.lucene.directory.AgilityContext;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.lucene.directory.FDBDirectoryManager;
import com.apple.foundationdb.record.lucene.idformat.LuceneIndexKeySerializer;
import com.apple.foundationdb.record.lucene.idformat.RecordCoreFormatException;
import com.apple.foundationdb.record.lucene.search.BooleanPointsConfig;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.IndexAggregateFunction;
import com.apple.foundationdb.record.metadata.IndexRecordFunction;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseRunner;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexableRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexDeferredMaintenanceControl;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.IndexOperation;
import com.apple.foundationdb.record.provider.foundationdb.IndexOperationResult;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanBounds;
import com.apple.foundationdb.record.provider.foundationdb.IndexScrubbingTools;
import com.apple.foundationdb.record.provider.foundationdb.indexes.InvalidIndexEntry;
import com.apple.foundationdb.record.provider.foundationdb.indexes.StandardIndexMaintainer;
import com.apple.foundationdb.record.query.QueryToKeyMatcher;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.document.BinaryPoint;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.EXPERIMENTAL)
public class LuceneIndexMaintainer
extends StandardIndexMaintainer {
    private static final Logger LOG = LoggerFactory.getLogger(LuceneIndexMaintainer.class);
    @Nonnull
    private final FDBDirectoryManager directoryManager;
    private final LuceneAnalyzerCombinationProvider autoCompleteAnalyzerSelector;
    public static final String PRIMARY_KEY_FIELD_NAME = "_p";
    protected static final String PRIMARY_KEY_SEARCH_NAME = "_s";
    protected static final String PRIMARY_KEY_BINARY_POINT_NAME = "_b";
    private final Executor executor;
    LuceneIndexKeySerializer keySerializer;
    private boolean serializerErrorLogged = false;
    @Nonnull
    private final LucenePartitioner partitioner;

    public LuceneIndexMaintainer(@Nonnull IndexMaintainerState state, @Nonnull Executor executor) {
        super(state);
        this.executor = executor;
        this.directoryManager = this.createDirectoryManager(state);
        Map<String, LuceneIndexExpressions.DocumentFieldDerivation> fieldInfos = LuceneIndexExpressions.getDocumentFieldDerivations(state.index, state.store.getRecordMetaData());
        this.autoCompleteAnalyzerSelector = LuceneAnalyzerRegistryImpl.instance().getLuceneAnalyzerCombinationProvider(state.index, LuceneAnalyzerType.AUTO_COMPLETE, fieldInfos);
        String formatString = state.index.getOption("primaryKeySerializationFormat");
        this.keySerializer = LuceneIndexKeySerializer.fromStringFormat(formatString);
        this.partitioner = new LucenePartitioner(state);
    }

    public LuceneAnalyzerCombinationProvider getAutoCompleteAnalyzerSelector() {
        return this.autoCompleteAnalyzerSelector;
    }

    @Nonnull
    public RecordCursor<IndexEntry> scan(@Nonnull IndexScanType scanType, @Nonnull TupleRange range, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        throw new RecordCoreException("unsupported scan type for Lucene index: " + String.valueOf(scanType), new Object[0]);
    }

    @Nonnull
    public RecordCursor<IndexEntry> scan(@Nonnull IndexScanBounds scanBounds, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        IndexScanType scanType = scanBounds.getScanType();
        LOG.trace("scan scanType={}", (Object)scanType);
        if (scanType.equals((Object)LuceneScanTypes.BY_LUCENE)) {
            LucenePartitioner.PartitionedQueryHint partitionedQueryHint;
            LuceneScanQuery scanQuery = (LuceneScanQuery)scanBounds;
            LucenePartitioner.PartitionedQueryHint partitionedQueryHint2 = partitionedQueryHint = continuation == null ? this.partitioner.selectQueryPartition(scanQuery.getGroupKey(), scanQuery) : null;
            if (partitionedQueryHint != null && !partitionedQueryHint.canHaveMatches) {
                return RecordCursor.empty((Executor)this.state.context.getExecutor());
            }
            LucenePartitionInfoProto.LucenePartitionInfo partitionInfo = partitionedQueryHint == null ? null : partitionedQueryHint.startPartition;
            return new LuceneRecordCursor(this.executor, (ExecutorService)this.state.context.getPropertyStorage().getPropertyValue(LuceneRecordContextProperties.LUCENE_EXECUTOR_SERVICE), this.partitioner, (Integer)this.state.context.getPropertyStorage().getPropertyValue(LuceneRecordContextProperties.LUCENE_INDEX_CURSOR_PAGE_SIZE), scanProperties, this.state, scanQuery.getQuery(), scanQuery.getSort(), continuation, scanQuery.getGroupKey(), partitionInfo, scanQuery.getLuceneQueryHighlightParameters(), scanQuery.getTermMap(), scanQuery.getStoredFields(), scanQuery.getStoredFieldTypes(), this.directoryManager.getAnalyzerSelector(), this.autoCompleteAnalyzerSelector);
        }
        if (scanType.equals((Object)LuceneScanTypes.BY_LUCENE_SPELL_CHECK)) {
            if (continuation != null) {
                throw new RecordCoreArgumentException("Spellcheck does not currently support continuation scanning", new Object[0]);
            }
            LuceneScanSpellCheck scanSpellcheck = (LuceneScanSpellCheck)scanBounds;
            return new LuceneSpellCheckRecordCursor(scanSpellcheck.getFields(), scanSpellcheck.getWord(), this.executor, scanProperties, this.state, scanSpellcheck.getGroupKey(), this.partitioner.selectQueryPartitionId(scanSpellcheck.getGroupKey()));
        }
        throw new RecordCoreException("unsupported scan type for Lucene index: " + String.valueOf(scanType), new Object[0]);
    }

    private void insertField(LuceneDocumentFromRecord.DocumentField field, Document document) {
        StoredField storedField;
        SortedDocValuesField sortedField;
        Field luceneField;
        String fieldName = field.getFieldName();
        Object value = field.getValue();
        switch (field.getType()) {
            case TEXT: {
                luceneField = new Field(fieldName, (CharSequence)((String)value), (IndexableFieldType)this.getTextFieldType(field));
                sortedField = null;
                storedField = null;
                break;
            }
            case STRING: {
                luceneField = new StringField(fieldName, (String)value, field.isStored() ? Field.Store.YES : Field.Store.NO);
                sortedField = field.isSorted() ? new SortedDocValuesField(fieldName, new BytesRef((CharSequence)((String)value))) : null;
                storedField = null;
                break;
            }
            case INT: {
                luceneField = new IntPoint(fieldName, new int[]{(Integer)value});
                sortedField = field.isSorted() ? new NumericDocValuesField(fieldName, (long)((Integer)value).intValue()) : null;
                storedField = field.isStored() ? new StoredField(fieldName, ((Integer)value).intValue()) : null;
                break;
            }
            case LONG: {
                luceneField = new LongPoint(fieldName, new long[]{(Long)value});
                sortedField = field.isSorted() ? new NumericDocValuesField(fieldName, (Long)value) : null;
                storedField = field.isStored() ? new StoredField(fieldName, ((Long)value).longValue()) : null;
                break;
            }
            case DOUBLE: {
                luceneField = new DoublePoint(fieldName, new double[]{(Double)value});
                sortedField = field.isSorted() ? new NumericDocValuesField(fieldName, NumericUtils.doubleToSortableLong((double)((Double)value))) : null;
                storedField = field.isStored() ? new StoredField(fieldName, ((Double)value).doubleValue()) : null;
                break;
            }
            case BOOLEAN: {
                byte[] bytes = Boolean.TRUE.equals(value) ? BooleanPointsConfig.TRUE_BYTES : BooleanPointsConfig.FALSE_BYTES;
                luceneField = new BinaryPoint(fieldName, (byte[][])new byte[][]{bytes});
                storedField = field.isStored() ? new StoredField(fieldName, bytes) : null;
                sortedField = field.isSorted() ? new SortedDocValuesField(fieldName, new BytesRef(bytes)) : null;
                break;
            }
            default: {
                throw new RecordCoreArgumentException("Invalid type for lucene index field", new Object[]{"type", field.getType()});
            }
        }
        document.add((IndexableField)luceneField);
        if (sortedField != null) {
            document.add((IndexableField)sortedField);
        }
        if (storedField != null) {
            document.add((IndexableField)storedField);
        }
    }

    private void writeDocument(@Nonnull List<LuceneDocumentFromRecord.DocumentField> fields, Tuple groupingKey, Integer partitionId, Tuple primaryKey) throws IOException {
        long startTime = System.nanoTime();
        Document document = new Document();
        IndexWriter newWriter = this.directoryManager.getIndexWriter(groupingKey, partitionId);
        BytesRef ref = new BytesRef(this.keySerializer.asPackedByteArray(primaryKey));
        document.add((IndexableField)new StoredField(PRIMARY_KEY_FIELD_NAME, ref));
        document.add((IndexableField)new SortedDocValuesField(PRIMARY_KEY_SEARCH_NAME, ref));
        if (this.keySerializer.hasFormat()) {
            try {
                document.add((IndexableField)new BinaryPoint(PRIMARY_KEY_BINARY_POINT_NAME, this.keySerializer.asFormattedBinaryPoint(primaryKey)));
            }
            catch (RecordCoreFormatException ex) {
                this.logSerializationError("Failed to write using BinaryPoint encoded ID: {}", ex.getMessage());
            }
        }
        Map<IndexOptions, List<LuceneDocumentFromRecord.DocumentField>> indexOptionsToFieldsMap = this.getIndexOptionsToFieldsMap(fields);
        for (Map.Entry<IndexOptions, List<LuceneDocumentFromRecord.DocumentField>> entry : indexOptionsToFieldsMap.entrySet()) {
            for (LuceneDocumentFromRecord.DocumentField field : entry.getValue()) {
                this.insertField(field, document);
            }
        }
        newWriter.addDocument((Iterable)document);
        this.state.context.record((StoreTimer.Event)LuceneEvents.Events.LUCENE_ADD_DOCUMENT, System.nanoTime() - startTime);
    }

    @Nonnull
    private Map<IndexOptions, List<LuceneDocumentFromRecord.DocumentField>> getIndexOptionsToFieldsMap(@Nonnull List<LuceneDocumentFromRecord.DocumentField> fields) {
        EnumMap<IndexOptions, List<LuceneDocumentFromRecord.DocumentField>> map = new EnumMap<IndexOptions, List<LuceneDocumentFromRecord.DocumentField>>(IndexOptions.class);
        fields.stream().forEach(f -> {
            IndexOptions indexOptions = LuceneIndexMaintainer.getIndexOptions(Objects.requireNonNullElse(f.getConfig("lucene_auto_complete_field_index_options"), LuceneFunctionNames.LuceneFieldIndexOptions.DOCS_AND_FREQS_AND_POSITIONS.name()));
            map.putIfAbsent(indexOptions, new ArrayList());
            ((List)map.get(indexOptions)).add(f);
        });
        return map;
    }

    int deleteDocument(Tuple groupingKey, Integer partitionId, Tuple primaryKey) throws IOException {
        Query query;
        long startTime = System.nanoTime();
        IndexWriter indexWriter = this.directoryManager.getIndexWriter(groupingKey, partitionId);
        LucenePrimaryKeySegmentIndex segmentIndex = this.directoryManager.getDirectory(groupingKey, partitionId).getPrimaryKeySegmentIndex();
        if (segmentIndex != null) {
            DirectoryReader directoryReader = this.directoryManager.getWriterReader(groupingKey, partitionId);
            LucenePrimaryKeySegmentIndex.DocumentIndexEntry documentIndexEntry = segmentIndex.findDocument(directoryReader, primaryKey);
            if (documentIndexEntry != null) {
                this.state.context.ensureActive().clear(documentIndexEntry.entryKey);
                long valid = indexWriter.tryDeleteDocument(documentIndexEntry.indexReader, documentIndexEntry.docId);
                if (valid > 0L) {
                    this.state.context.record((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_PRIMARY_KEY, System.nanoTime() - startTime);
                    return 1;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(KeyValueLogMessage.of((String)"try delete document failed", (Object[])new Object[]{LuceneLogMessageKeys.GROUP, groupingKey, LuceneLogMessageKeys.INDEX_PARTITION, partitionId, LuceneLogMessageKeys.SEGMENT, documentIndexEntry.segmentName, LuceneLogMessageKeys.DOC_ID, documentIndexEntry.docId, LuceneLogMessageKeys.PRIMARY_KEY, primaryKey}));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(KeyValueLogMessage.of((String)"primary key segment index entry not found", (Object[])new Object[]{LuceneLogMessageKeys.GROUP, groupingKey, LuceneLogMessageKeys.INDEX_PARTITION, partitionId, LuceneLogMessageKeys.PRIMARY_KEY, primaryKey, LuceneLogMessageKeys.SEGMENTS, segmentIndex.findSegments(primaryKey)}));
            }
        }
        if (this.keySerializer.hasFormat()) {
            try {
                byte[][] binaryPoint = this.keySerializer.asFormattedBinaryPoint(primaryKey);
                query = BinaryPoint.newRangeQuery((String)PRIMARY_KEY_BINARY_POINT_NAME, (byte[][])binaryPoint, (byte[][])binaryPoint);
            }
            catch (RecordCoreFormatException ex) {
                query = SortedDocValuesField.newSlowExactQuery((String)PRIMARY_KEY_SEARCH_NAME, (BytesRef)new BytesRef(this.keySerializer.asPackedByteArray(primaryKey)));
                this.logSerializationError("Failed to delete using BinaryPoint encoded ID: {}", ex.getMessage());
            }
        } else {
            query = SortedDocValuesField.newSlowExactQuery((String)PRIMARY_KEY_SEARCH_NAME, (BytesRef)new BytesRef(this.keySerializer.asPackedByteArray(primaryKey)));
        }
        indexWriter.deleteDocuments(new Query[]{query});
        LuceneEvents.Events event = this.state.store.isIndexWriteOnly(this.state.index) ? LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY_IN_WRITE_ONLY_MODE : LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY;
        this.state.context.record((StoreTimer.Event)event, System.nanoTime() - startTime);
        return 0;
    }

    public CompletableFuture<Void> mergeIndex() {
        return this.rebalancePartitions().thenCompose(ignored -> {
            this.state.store.getIndexDeferredMaintenanceControl().setLastStep(IndexDeferredMaintenanceControl.LastStep.MERGE);
            return this.directoryManager.mergeIndex(this.partitioner);
        });
    }

    @VisibleForTesting
    public void mergeIndexForTesting(@Nonnull Tuple groupingKey, @Nullable Integer partitionId, @Nonnull AgilityContext agilityContext) throws IOException {
        this.directoryManager.mergeIndexWithContext(groupingKey, partitionId, agilityContext);
    }

    @Nonnull
    @VisibleForTesting
    public LucenePartitioner getPartitioner() {
        return this.partitioner;
    }

    @Nonnull
    private static LucenePartitioner getPartitioner(Index index, FDBRecordStore store) {
        IndexMaintainer indexMaintainer = store.getIndexMaintainer(index);
        if (indexMaintainer instanceof LuceneIndexMaintainer) {
            return ((LuceneIndexMaintainer)indexMaintainer).partitioner;
        }
        throw new RecordCoreException("Index being repartitioned is no longer a lucene index", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.INDEX_NAME, index.getName(), LogMessageKeys.INDEX_TYPE, index.getType()});
    }

    public CompletableFuture<Void> rebalancePartitions() {
        if (!this.partitioner.isPartitioningEnabled()) {
            return CompletableFuture.completedFuture(null);
        }
        IndexDeferredMaintenanceControl mergeControl = this.state.store.getIndexDeferredMaintenanceControl();
        mergeControl.setLastStep(IndexDeferredMaintenanceControl.LastStep.REPARTITION);
        int documentCount = mergeControl.getRepartitionDocumentCount();
        if (documentCount < 0) {
            return CompletableFuture.completedFuture(null);
        }
        if (documentCount == 0) {
            documentCount = Objects.requireNonNull((Integer)this.state.context.getPropertyStorage().getPropertyValue(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT));
            mergeControl.setRepartitionDocumentCount(documentCount);
        }
        FDBRecordStore.Builder storeBuilder = this.state.store.asBuilder();
        FDBDatabaseRunner runner = this.state.context.newRunner();
        runner.setMaxAttempts(1);
        return LuceneIndexMaintainer.rebalancePartitions(runner, storeBuilder, this.state, mergeControl).whenComplete((result, error) -> runner.close());
    }

    private static CompletableFuture<Void> rebalancePartitions(FDBDatabaseRunner runner, FDBRecordStore.Builder storeBuilder, IndexMaintainerState state, IndexDeferredMaintenanceControl mergeControl) {
        FDBStoreTimer timer = state.context.getTimer();
        if (timer != null) {
            timer.increment((StoreTimer.Count)LuceneEvents.Counts.LUCENE_REPARTITION_CALLS);
        }
        AtomicReference<RecordCursorContinuation> continuation = new AtomicReference<RecordCursorContinuation>(RecordCursorStartContinuation.START);
        int repartitionDocumentCount = mergeControl.getRepartitionDocumentCount();
        int maxDocumentsToMove = Objects.requireNonNull((Integer)state.context.getPropertyStorage().getPropertyValue(LuceneRecordContextProperties.LUCENE_MAX_DOCUMENTS_TO_MOVE_DURING_REPARTITIONING));
        AtomicInteger maxIterations = new AtomicInteger(Math.max(1, maxDocumentsToMove / repartitionDocumentCount));
        LucenePartitioner.RepartitioningLogMessages repartitioningLogMessages = new LucenePartitioner.RepartitioningLogMessages(-1, Tuple.from((Object[])new Object[0]), 0);
        return AsyncUtil.whileTrue(() -> runner.runAsync(context -> context.instrument((StoreTimer.Event)LuceneEvents.Events.LUCENE_REBALANCE_PARTITION_TRANSACTION, (CompletableFuture)storeBuilder.setContext(context).openAsync().thenCompose(store -> LuceneIndexMaintainer.getPartitioner(state.index, store).rebalancePartitions((RecordCursorContinuation)continuation.get(), repartitionDocumentCount, repartitioningLogMessages).thenApply(newContinuation -> {
            if (newContinuation.isEnd() || maxIterations.decrementAndGet() == 0) {
                mergeControl.setRepartitionCapped(!newContinuation.isEnd());
                return false;
            }
            continuation.set((RecordCursorContinuation)newContinuation);
            return true;
        }))), repartitioningLogMessages.logMessages), (Executor)state.context.getExecutor());
    }

    @Nonnull
    public <M extends Message> CompletableFuture<Void> update(@Nullable FDBIndexableRecord<M> oldRecord, @Nullable FDBIndexableRecord<M> newRecord) {
        return this.update(oldRecord, newRecord, null);
    }

    @Nonnull
    <M extends Message> CompletableFuture<Void> update(@Nullable FDBIndexableRecord<M> oldRecord, @Nullable FDBIndexableRecord<M> newRecord, @Nullable Integer destinationPartitionIdHint) {
        LOG.trace("update oldRecord={}, newRecord={}", oldRecord, newRecord);
        KeyExpression root = this.state.index.getRootExpression();
        Map<Tuple, List<LuceneDocumentFromRecord.DocumentField>> oldRecordFields = LuceneDocumentFromRecord.getRecordFields(root, oldRecord);
        Map<Tuple, List<LuceneDocumentFromRecord.DocumentField>> newRecordFields = LuceneDocumentFromRecord.getRecordFields(root, newRecord);
        HashSet<Tuple> unchanged = new HashSet<Tuple>();
        for (Map.Entry<Tuple, List<LuceneDocumentFromRecord.DocumentField>> entry : oldRecordFields.entrySet()) {
            if (!entry.getValue().equals(newRecordFields.get(entry.getKey()))) continue;
            unchanged.add(entry.getKey());
        }
        for (Tuple t2 : unchanged) {
            newRecordFields.remove(t2);
            oldRecordFields.remove(t2);
        }
        LOG.trace("update oldFields={}, newFields{}", oldRecordFields, newRecordFields);
        return AsyncUtil.whenAll((Collection)oldRecordFields.keySet().stream().map(t -> {
            try {
                return this.tryDelete((FDBIndexableRecord)Objects.requireNonNull(oldRecord), (Tuple)t);
            }
            catch (IOException e) {
                throw LuceneExceptions.toRecordCoreException("Issue deleting", e, "record", Objects.requireNonNull(oldRecord).getPrimaryKey());
            }
        }).collect(Collectors.toList())).thenCompose(ignored -> AsyncUtil.whenAll((Collection)newRecordFields.entrySet().stream().map(entry -> {
            try {
                return this.tryDeleteInWriteOnlyMode(Objects.requireNonNull(newRecord), (Tuple)entry.getKey()).thenCompose(countDeleted -> this.partitioner.addToAndSavePartitionMetadata(newRecord, (Tuple)entry.getKey(), destinationPartitionIdHint).thenApply(partitionId -> {
                    try {
                        this.writeDocument((List)entry.getValue(), (Tuple)entry.getKey(), (Integer)partitionId, newRecord.getPrimaryKey());
                    }
                    catch (IOException e) {
                        throw LuceneExceptions.toRecordCoreException("Issue updating new index keys", e, "newRecord", newRecord.getPrimaryKey());
                    }
                    return null;
                }));
            }
            catch (IOException e) {
                throw LuceneExceptions.toRecordCoreException("Issue updating", e, "record", Objects.requireNonNull(newRecord).getPrimaryKey());
            }
        }).collect(Collectors.toList())));
    }

    private <M extends Message> CompletableFuture<Integer> tryDeleteInWriteOnlyMode(@Nonnull FDBIndexableRecord<M> record, @Nonnull Tuple groupingKey) throws IOException {
        if (!this.state.store.isIndexWriteOnly(this.state.index)) {
            return CompletableFuture.completedFuture(0);
        }
        return this.tryDelete(record, groupingKey);
    }

    private <M extends Message> CompletableFuture<Integer> tryDelete(@Nonnull FDBIndexableRecord<M> record, @Nonnull Tuple groupingKey) throws IOException {
        if (!this.partitioner.isPartitioningEnabled()) {
            return CompletableFuture.completedFuture(this.deleteDocument(groupingKey, null, record.getPrimaryKey()));
        }
        return this.partitioner.tryGetPartitionInfo(record, groupingKey).thenApply(partitionInfo -> {
            if (partitionInfo != null) {
                try {
                    int countDeleted = this.deleteDocument(groupingKey, partitionInfo.getId(), record.getPrimaryKey());
                    if (countDeleted > 0) {
                        this.partitioner.decrementCountAndSave(groupingKey, (LucenePartitionInfoProto.LucenePartitionInfo)partitionInfo, countDeleted);
                    }
                    return countDeleted;
                }
                catch (IOException e) {
                    throw LuceneExceptions.toRecordCoreException("Issue deleting", e, "record", record.getPrimaryKey());
                }
            }
            return 0;
        });
    }

    private FieldType getTextFieldType(LuceneDocumentFromRecord.DocumentField field) {
        FieldType ft = new FieldType();
        try {
            ft.setIndexOptions(LuceneIndexMaintainer.getIndexOptions(Objects.requireNonNullElse(field.getConfig("lucene_full_text_field_index_options"), LuceneFunctionNames.LuceneFieldIndexOptions.DOCS_AND_FREQS_AND_POSITIONS.name())));
            ft.setTokenized(true);
            ft.setStored(field.isStored());
            ft.setStoreTermVectors(Objects.requireNonNullElse(field.getConfig("lucene_full_text_field_with_term_vectors"), false).booleanValue());
            ft.setStoreTermVectorPositions(Objects.requireNonNullElse(field.getConfig("lucene_full_text_field_with_term_vector_positions"), false).booleanValue());
            ft.setOmitNorms(true);
            ft.freeze();
        }
        catch (ClassCastException ex) {
            throw new RecordCoreArgumentException("Invalid value type for Lucene field config", (Throwable)ex);
        }
        return ft;
    }

    private static IndexOptions getIndexOptions(@Nonnull String value) {
        try {
            return IndexOptions.valueOf((String)value);
        }
        catch (IllegalArgumentException ex) {
            throw new RecordCoreArgumentException("Invalid enum value to parse for Lucene IndexOptions: " + value, (Throwable)ex);
        }
    }

    @Nonnull
    public RecordCursor<InvalidIndexEntry> validateEntries(@Nullable byte[] continuation, @Nullable ScanProperties scanProperties) {
        LOG.trace("validateEntries");
        return RecordCursor.empty((Executor)this.executor);
    }

    public boolean canEvaluateRecordFunction(@Nonnull IndexRecordFunction<?> function) {
        LOG.trace("canEvaluateRecordFunction() function={}", function);
        return false;
    }

    @Nonnull
    public <T, M extends Message> CompletableFuture<T> evaluateRecordFunction(@Nonnull EvaluationContext context, @Nonnull IndexRecordFunction<T> function, @Nonnull FDBRecord<M> record) {
        LOG.warn("evaluateRecordFunction() function={}", function);
        return this.unsupportedRecordFunction(function);
    }

    public boolean canEvaluateAggregateFunction(@Nonnull IndexAggregateFunction function) {
        LOG.trace("canEvaluateAggregateFunction() function={}", (Object)function);
        return false;
    }

    @Nonnull
    public CompletableFuture<Tuple> evaluateAggregateFunction(@Nonnull IndexAggregateFunction function, @Nonnull TupleRange range, @Nonnull IsolationLevel isolationLevel) {
        LOG.warn("evaluateAggregateFunction() function={}", (Object)function);
        return this.unsupportedAggregateFunction(function);
    }

    public boolean isIdempotent() {
        LOG.trace("isIdempotent()");
        return true;
    }

    @Nonnull
    public CompletableFuture<Boolean> addedRangeWithKey(@Nonnull Tuple primaryKey) {
        LOG.trace("addedRangeWithKey primaryKey={}", (Object)primaryKey);
        return AsyncUtil.READY_FALSE;
    }

    public boolean canDeleteWhere(@Nonnull QueryToKeyMatcher matcher, @Nonnull Key.Evaluated evaluated) {
        LOG.trace("canDeleteWhere matcher={}", (Object)matcher);
        return this.canDeleteGroup(matcher, evaluated);
    }

    @Nonnull
    public CompletableFuture<Void> deleteWhere(Transaction tr, @Nonnull Tuple prefix) {
        LOG.trace("deleteWhere transaction={}, prefix={}", (Object)tr, (Object)prefix);
        this.directoryManager.invalidatePrefix(prefix);
        return super.deleteWhere(tr, prefix);
    }

    @Nonnull
    public CompletableFuture<IndexOperationResult> performOperation(@Nonnull IndexOperation operation) {
        LOG.trace("performOperation operation={}", (Object)operation);
        if (operation instanceof LuceneGetMetadataInfo) {
            LuceneGetMetadataInfo request = (LuceneGetMetadataInfo)operation;
            if (request.isJustPartitionInfo()) {
                if (this.partitioner.isPartitioningEnabled()) {
                    return this.partitioner.getAllPartitionMetaInfo(request.getGroupingKey()).thenApply(partitionInfos -> new LuceneMetadataInfo((List<LucenePartitionInfoProto.LucenePartitionInfo>)partitionInfos, Map.of()));
                }
                return CompletableFuture.completedFuture(new LuceneMetadataInfo(List.of(), Map.of()));
            }
            if (this.partitioner.isPartitioningEnabled()) {
                return this.getLuceneInfoForAllPartitions(request);
            }
            return this.getLuceneInfo(request.getGroupingKey(), null).thenApply(luceneInfos -> new LuceneMetadataInfo(List.of(), Map.of(0, luceneInfos)));
        }
        return super.performOperation(operation);
    }

    private CompletableFuture<IndexOperationResult> getLuceneInfoForAllPartitions(LuceneGetMetadataInfo request) {
        return this.partitioner.getAllPartitionMetaInfo(request.getGroupingKey()).thenCompose(partitionInfos -> {
            Stream<Object> infoStream = partitionInfos.stream();
            if (request.getPartitionId() != null) {
                infoStream = infoStream.filter(info -> info.getId() == request.getPartitionId().intValue());
            }
            List luceneInfos = infoStream.map(partitionInfo -> this.getLuceneInfo(request.getGroupingKey(), partitionInfo.getId()).thenApply(luceneInfo -> Map.entry(partitionInfo.getId(), luceneInfo))).collect(Collectors.toList());
            return AsyncUtil.getAll(luceneInfos).thenApply(entries -> new LuceneMetadataInfo((List<LucenePartitionInfoProto.LucenePartitionInfo>)partitionInfos, entries.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
        });
    }

    private CompletableFuture<LuceneMetadataInfo.LuceneInfo> getLuceneInfo(Tuple groupingKey, Integer partitionId) {
        CompletionStage completionStage;
        block8: {
            IndexReader indexReader = this.directoryManager.getIndexReader(groupingKey, partitionId);
            try {
                FDBDirectory directory = this.getDirectory(groupingKey, partitionId);
                CompletableFuture<Integer> fieldInfosFuture = directory.getFieldInfosCount();
                completionStage = directory.listAllAsync().thenCombine(fieldInfosFuture, (fileList, fieldInfosCount) -> new LuceneMetadataInfo.LuceneInfo(indexReader.numDocs(), (Collection<String>)fileList, (int)fieldInfosCount));
                if (indexReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (indexReader != null) {
                        try {
                            indexReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(e);
                }
            }
            indexReader.close();
        }
        return completionStage;
    }

    @VisibleForTesting
    protected FDBDirectory getDirectory(@Nonnull Tuple groupingKey, @Nullable Integer partitionId) {
        return this.directoryManager.getDirectory(groupingKey, partitionId);
    }

    @VisibleForTesting
    public FDBDirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    @Nonnull
    @VisibleForTesting
    protected FDBDirectoryManager createDirectoryManager(@Nonnull IndexMaintainerState state) {
        return FDBDirectoryManager.getManager(state);
    }

    private void logSerializationError(String format, Object ... arguments) {
        if (LOG.isWarnEnabled() && !this.serializerErrorLogged) {
            LOG.warn(format, arguments);
            this.serializerErrorLogged = true;
        }
    }

    @Nullable
    public IndexScrubbingTools<?> getIndexScrubbingTools(IndexScrubbingTools.ScrubbingType type) {
        switch (type) {
            case MISSING: {
                Map options = this.state.index.getOptions();
                if (Boolean.parseBoolean((String)options.get("primaryKeySegmentIndexEnabled")) || Boolean.parseBoolean((String)options.get("primaryKeySegmentIndexV2Enabled"))) {
                    return new LuceneIndexScrubbingToolsMissing(this.partitioner, this.directoryManager);
                }
                return null;
            }
        }
        return null;
    }
}

