/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.MoreAsyncUtil;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.lucene.LuceneRecordContextProperties;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBExceptions;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LuceneConcurrency {
    @Nullable
    @API(value=API.Status.INTERNAL)
    public static <T> T asyncToSync(@Nonnull StoreTimer.Wait event, @Nonnull CompletableFuture<T> async, @Nonnull FDBRecordContext recordContext) {
        if (((Boolean)recordContext.getPropertyStorage().getPropertyValue(LuceneRecordContextProperties.LUCENE_USE_LEGACY_ASYNC_TO_SYNC)).booleanValue()) {
            return (T)recordContext.asyncToSync(event, async);
        }
        if (recordContext.hasHookForAsyncToSync() && !MoreAsyncUtil.isCompletedNormally(async)) {
            recordContext.getHookForAsyncToSync().accept(event);
        }
        recordContext.getDatabase().checkIfBlockingInFuture(async);
        if (async.isDone()) {
            try {
                return async.get();
            }
            catch (ExecutionException ex) {
                throw FDBExceptions.wrapException((Throwable)ex);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw FDBExceptions.wrapException((Throwable)ex);
            }
        }
        Duration asyncToSyncTimeout = recordContext.getDatabase().getAsyncToSyncTimeout(event);
        FDBStoreTimer timer = recordContext.getTimer();
        long startTime = System.nanoTime();
        try {
            if (asyncToSyncTimeout != null) {
                T t = async.get(asyncToSyncTimeout.toNanos(), TimeUnit.NANOSECONDS);
                return t;
            }
            T t = async.get();
            return t;
        }
        catch (TimeoutException ex) {
            if (timer != null) {
                timer.recordTimeout(event, startTime);
                throw new AsyncToSyncTimeoutException(ex.getMessage(), ex, new Object[]{LogMessageKeys.TIME_LIMIT.toString(), asyncToSyncTimeout.toNanos(), LogMessageKeys.TIME_UNIT.toString(), TimeUnit.NANOSECONDS});
            }
            throw new AsyncToSyncTimeoutException(ex.getMessage(), ex);
        }
        catch (ExecutionException ex) {
            throw FDBExceptions.wrapException((Throwable)ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw FDBExceptions.wrapException((Throwable)ex);
        }
        finally {
            if (timer != null) {
                timer.recordSinceNanoTime((StoreTimer.Event)event, startTime);
            }
        }
    }

    private LuceneConcurrency() {
    }

    public static class AsyncToSyncTimeoutException
    extends RecordCoreException {
        private static final long serialVersionUID = -1L;

        public AsyncToSyncTimeoutException(String message, Throwable cause) {
            super(message, cause);
        }

        public AsyncToSyncTimeoutException(String message, Throwable cause, Object ... keyValues) {
            super(message, cause);
            this.addLogInfo(keyValues);
        }
    }
}

