/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerCombinationProvider;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.LuceneRecordCursor;
import com.apple.foundationdb.record.provider.foundationdb.FDBQueriedRecord;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Sets;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;

public class LuceneAutoCompleteHelpers {
    @Nonnull
    public static AutoCompleteTokens getQueryTokens(Analyzer queryAnalyzer, String searchKey) {
        ImmutableList.Builder tokensBuilder = ImmutableList.builder();
        String prefixToken = null;
        try (TokenStream ts = queryAnalyzer.tokenStream("", (Reader)new StringReader(searchKey));){
            ts.reset();
            CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            OffsetAttribute offsetAtt = (OffsetAttribute)ts.addAttribute(OffsetAttribute.class);
            String lastToken = null;
            int maxEndOffset = -1;
            while (ts.incrementToken()) {
                if (lastToken != null) {
                    tokensBuilder.add(lastToken);
                }
                if ((lastToken = termAtt.toString()) == null) continue;
                maxEndOffset = Math.max(maxEndOffset, offsetAtt.endOffset());
            }
            ts.end();
            if (lastToken != null) {
                if (maxEndOffset == offsetAtt.endOffset()) {
                    prefixToken = lastToken;
                } else {
                    tokensBuilder.add((Object)lastToken);
                }
            }
        }
        catch (IOException ioException) {
            throw LuceneExceptions.toRecordCoreException("string reader throw IOException", ioException, new Object[0]);
        }
        return new AutoCompleteTokens((Collection<String>)tokensBuilder.build(), (Set<String>)(prefixToken == null ? ImmutableSet.of() : ImmutableSet.of((Object)prefixToken)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static List<String> computeAllMatches(@Nonnull String fieldName, @Nonnull Analyzer queryAnalyzer, @Nonnull String text, @Nonnull AutoCompleteTokens tokens, int numAdditionalTokens) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        ArrayList acceptors = Lists.newArrayList();
        Set<String> queryTokens = tokens.getQueryTokensAsSet();
        HashSet seenQueryTokens = Sets.newHashSetWithExpectedSize((int)queryTokens.size());
        Set<String> prefixTokens = tokens.getPrefixTokens();
        HashSet seenPrefixTokens = Sets.newHashSetWithExpectedSize((int)prefixTokens.size());
        try (TokenStream ts = queryAnalyzer.tokenStream(fieldName, (Reader)new StringReader(text));){
            Object object;
            CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            OffsetAttribute offsetAtt = (OffsetAttribute)ts.addAttribute(OffsetAttribute.class);
            ts.reset();
            int upto = 0;
            block8: while (ts.incrementToken()) {
                String token = termAtt.toString();
                int startOffset = offsetAtt.startOffset();
                int endOffset = offsetAtt.endOffset();
                if (upto < startOffset) {
                    upto = startOffset;
                } else if (upto > startOffset) continue;
                acceptors.removeIf(acceptor -> !acceptor.acceptAdditionalToken(endOffset));
                if (queryTokens.contains(token)) {
                    seenQueryTokens.add(token);
                    TermAcceptor termAcceptor = new TermAcceptor(startOffset, endOffset, numAdditionalTokens);
                    resultBuilder.add((Object)termAcceptor);
                    if (numAdditionalTokens > 0) {
                        acceptors.add(termAcceptor);
                    }
                    upto = endOffset;
                    continue;
                }
                for (String prefixToken : prefixTokens) {
                    if (!token.startsWith(prefixToken)) continue;
                    upto = endOffset;
                    seenPrefixTokens.add(prefixToken);
                    TermAcceptor termAcceptor = new TermAcceptor(startOffset, endOffset, numAdditionalTokens);
                    resultBuilder.add((Object)termAcceptor);
                    if (numAdditionalTokens <= 0) continue block8;
                    acceptors.add(termAcceptor);
                    continue block8;
                }
            }
            ts.end();
            if (!seenQueryTokens.isEmpty() || !seenPrefixTokens.isEmpty()) {
                object = (List)resultBuilder.build().stream().map(acceptor -> acceptor.getAcceptedString(text)).collect(ImmutableList.toImmutableList());
                return object;
            }
            object = ImmutableList.of();
            return object;
        }
        catch (IOException ioException) {
            throw LuceneExceptions.toRecordCoreException("token stream threw an io exception", ioException, new Object[0]);
        }
    }

    @Nonnull
    public static List<String> computeAllMatchesForPhrase(@Nonnull String fieldName, @Nonnull Analyzer queryAnalyzer, @Nonnull String text, @Nonnull AutoCompleteTokens tokens, int numAdditionalTokens) {
        List list;
        block10: {
            List<String> queryTokens = tokens.getQueryTokens();
            Set<String> prefixTokens = tokens.getPrefixTokens();
            Preconditions.checkArgument((prefixTokens.size() <= 1 ? 1 : 0) != 0);
            String prefixToken = prefixTokens.isEmpty() ? null : (String)Iterables.getOnlyElement(prefixTokens);
            ArrayList activeAcceptors = Lists.newArrayList();
            TokenStream ts = queryAnalyzer.tokenStream(fieldName, (Reader)new StringReader(text));
            try {
                CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
                OffsetAttribute offsetAtt = (OffsetAttribute)ts.addAttribute(OffsetAttribute.class);
                ts.reset();
                int upto = 0;
                while (ts.incrementToken()) {
                    String token = termAtt.toString();
                    int startOffset = offsetAtt.startOffset();
                    int endOffset = offsetAtt.endOffset();
                    if (upto > startOffset) continue;
                    String matchedSubstring = text.substring(startOffset, endOffset);
                    activeAcceptors.removeIf(currentAcceptor -> !currentAcceptor.accept(token, matchedSubstring, endOffset));
                    PhraseAcceptor phraseAcceptor2 = PhraseAcceptor.acceptFirstToken(token, matchedSubstring, queryTokens, prefixToken, numAdditionalTokens, startOffset, endOffset);
                    if (phraseAcceptor2 != null) {
                        activeAcceptors.add(phraseAcceptor2);
                    }
                    upto = offsetAtt.endOffset();
                }
                ts.end();
                list = (List)activeAcceptors.stream().filter(PhraseAcceptor::isEndState).map(phraseAcceptor -> phraseAcceptor.getAcceptedPhrase(text)).collect(ImmutableList.toImmutableList());
                if (ts == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ts != null) {
                        try {
                            ts.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioException) {
                    throw LuceneExceptions.toRecordCoreException("token stream threw an io exception", ioException, new Object[0]);
                }
            }
            ts.close();
        }
        return list;
    }

    public static boolean isPhraseSearch(@Nonnull String search) {
        return search.startsWith("\"") && search.endsWith("\"");
    }

    @Nonnull
    public static String searchKeyFromSearchArgument(@Nonnull String search) {
        return LuceneAutoCompleteHelpers.searchKeyFromSearchArgument(search, LuceneAutoCompleteHelpers.isPhraseSearch(search));
    }

    @Nonnull
    public static String searchKeyFromSearchArgument(@Nonnull String search, boolean isPhraseSearch) {
        return isPhraseSearch ? search.substring(1, search.length() - 1) : search;
    }

    @Nullable
    public static <M extends Message> LuceneAnalyzerCombinationProvider getAutoCompletedMatchesAnalyzerSelector(@Nullable FDBQueriedRecord<M> queriedRecord) {
        if (queriedRecord == null) {
            return null;
        }
        IndexEntry indexEntry = queriedRecord.getIndexEntry();
        if (!(indexEntry instanceof LuceneRecordCursor.ScoreDocIndexEntry)) {
            return null;
        }
        LuceneRecordCursor.ScoreDocIndexEntry docIndexEntry = (LuceneRecordCursor.ScoreDocIndexEntry)indexEntry;
        return docIndexEntry.getAnalyzerSelector();
    }

    @Nullable
    public static <M extends Message> LuceneAnalyzerCombinationProvider getAutoCompleteAnalyzerSelector(@Nullable FDBQueriedRecord<M> queriedRecord) {
        if (queriedRecord == null) {
            return null;
        }
        IndexEntry indexEntry = queriedRecord.getIndexEntry();
        if (!(indexEntry instanceof LuceneRecordCursor.ScoreDocIndexEntry)) {
            return null;
        }
        LuceneRecordCursor.ScoreDocIndexEntry docIndexEntry = (LuceneRecordCursor.ScoreDocIndexEntry)indexEntry;
        return docIndexEntry.getAutoCompleteAnalyzerSelector();
    }

    public static class AutoCompleteTokens {
        @Nonnull
        private final List<String> queryTokens;
        @Nonnull
        private final Set<String> prefixTokens;
        @Nonnull
        private final Supplier<Set<String>> queryTokensAsSetSupplier;

        public AutoCompleteTokens(@Nonnull Collection<String> queryTokens, @Nonnull Set<String> prefixTokens) {
            this.queryTokens = ImmutableList.copyOf(queryTokens);
            this.prefixTokens = ImmutableSet.copyOf(prefixTokens);
            this.queryTokensAsSetSupplier = Suppliers.memoize(() -> ImmutableSet.copyOf((Collection)queryTokens));
        }

        @Nonnull
        public List<String> getQueryTokens() {
            return this.queryTokens;
        }

        @Nonnull
        public Set<String> getQueryTokensAsSet() {
            return this.queryTokensAsSetSupplier.get();
        }

        @Nonnull
        public Set<String> getPrefixTokens() {
            return this.prefixTokens;
        }

        @Nullable
        public String getPrefixTokenOrNull() {
            return this.prefixTokens.isEmpty() ? null : (String)Iterables.getOnlyElement(this.prefixTokens);
        }
    }

    private static class TermAcceptor {
        private final int startOffset;
        private int endOffset;
        private int additionalTokenCount;

        public TermAcceptor(int startOffset, int endOffset, int additionalTokenCount) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.additionalTokenCount = additionalTokenCount;
        }

        public boolean acceptAdditionalToken(int currentEndOffset) {
            if (this.additionalTokenCount > 0) {
                --this.additionalTokenCount;
                this.endOffset = currentEndOffset;
            }
            return this.additionalTokenCount > 0;
        }

        @Nonnull
        public String getAcceptedString(@Nonnull String originalString) {
            return originalString.substring(this.startOffset, this.endOffset);
        }
    }

    private static class PhraseAcceptor {
        @Nonnull
        private final List<String> acceptedTokens;
        @Nonnull
        private final PeekingIterator<String> queryTokensRemainingIterator;
        @Nullable
        private final String prefixToken;
        private final int startOffset;
        private int endOffset;
        private int additionalTokenCount;
        private boolean isEndState;

        private PhraseAcceptor(@Nonnull Iterator<String> queryTokensRemainingIterator, @Nullable String prefixToken, @Nonnull List<String> acceptedTokens, boolean isEndState, int startOffset, int endOffset, int additionalTokenCount) {
            this.queryTokensRemainingIterator = Iterators.peekingIterator(queryTokensRemainingIterator);
            this.prefixToken = prefixToken;
            this.acceptedTokens = acceptedTokens;
            this.isEndState = isEndState;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.additionalTokenCount = additionalTokenCount;
        }

        @Nonnull
        public Iterator<String> getQueryTokensRemainingIterator() {
            return this.queryTokensRemainingIterator;
        }

        @Nullable
        public String getPrefixToken() {
            return this.prefixToken;
        }

        @Nonnull
        public List<String> getAcceptedTokens() {
            return this.acceptedTokens;
        }

        @Nonnull
        public String getAcceptedPhrase(@Nonnull String originalString) {
            return originalString.substring(this.startOffset, this.endOffset);
        }

        public boolean isEndState() {
            return this.isEndState;
        }

        public boolean accept(@Nonnull String currentToken, @Nonnull String currentMatchedString, int currentEndOffset) {
            if (this.isEndState) {
                if (this.additionalTokenCount > 0) {
                    --this.additionalTokenCount;
                    this.acceptedTokens.add(currentMatchedString);
                    this.endOffset = currentEndOffset;
                }
                return true;
            }
            String currentQueryToken = this.queryTokensRemainingIterator.hasNext() ? (String)this.queryTokensRemainingIterator.peek() : null;
            AcceptState acceptState = PhraseAcceptor.acceptToken(currentToken, currentQueryToken, this.prefixToken);
            switch (acceptState) {
                case NOT_ACCEPTED: {
                    return false;
                }
                case ACCEPTED_QUERY_TOKEN: {
                    this.acceptedTokens.add(currentMatchedString);
                    this.queryTokensRemainingIterator.next();
                    if (!this.queryTokensRemainingIterator.hasNext() && this.prefixToken == null) {
                        this.isEndState = true;
                        this.endOffset = currentEndOffset;
                    }
                    return true;
                }
                case ACCEPTED_PREFIX_TOKEN: {
                    this.acceptedTokens.add(currentMatchedString);
                    this.isEndState = true;
                    this.endOffset = currentEndOffset;
                    return true;
                }
            }
            throw new RecordCoreException("unexpected accept state", new Object[0]);
        }

        @Nullable
        public static PhraseAcceptor acceptFirstToken(@Nonnull String currentToken, @Nonnull String currentMatchedString, @Nonnull List<String> queryTokens, @Nullable String prefixToken, int additionalTokenCount, int startOffset, int currentEndOffset) {
            String firstQueryToken = queryTokens.isEmpty() ? null : queryTokens.get(0);
            AcceptState acceptState = PhraseAcceptor.acceptToken(currentToken, firstQueryToken, prefixToken);
            switch (acceptState) {
                case NOT_ACCEPTED: {
                    return null;
                }
                case ACCEPTED_QUERY_TOKEN: {
                    Iterator<String> queryTokensIterator = queryTokens.iterator();
                    queryTokensIterator.next();
                    boolean isEndState = !queryTokensIterator.hasNext() && prefixToken == null;
                    return new PhraseAcceptor(queryTokensIterator, prefixToken, Lists.newArrayList((Object[])new String[]{currentMatchedString}), isEndState, startOffset, isEndState ? currentEndOffset : -1, additionalTokenCount);
                }
                case ACCEPTED_PREFIX_TOKEN: {
                    return new PhraseAcceptor(queryTokens.iterator(), prefixToken, Lists.newArrayList((Object[])new String[]{currentMatchedString}), true, startOffset, currentEndOffset, additionalTokenCount);
                }
            }
            throw new RecordCoreException("unexpected accept state", new Object[0]);
        }

        private static AcceptState acceptToken(@Nonnull String currentToken, @Nullable String currentQueryToken, @Nullable String prefixToken) {
            Preconditions.checkArgument((currentQueryToken != null || prefixToken != null ? 1 : 0) != 0);
            if (currentQueryToken != null) {
                return currentToken.equals(currentQueryToken) ? AcceptState.ACCEPTED_QUERY_TOKEN : AcceptState.NOT_ACCEPTED;
            }
            return currentToken.startsWith(prefixToken) ? AcceptState.ACCEPTED_PREFIX_TOKEN : AcceptState.NOT_ACCEPTED;
        }

        private static enum AcceptState {
            NOT_ACCEPTED,
            ACCEPTED_QUERY_TOKEN,
            ACCEPTED_PREFIX_TOKEN;

        }
    }
}

