/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.lucene.AnalyzerChooser;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerWrapper;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;

public class LuceneAnalyzerCombinationProvider {
    @Nonnull
    private final LuceneAnalyzerWrapper indexAnalyzerWrapper;
    @Nonnull
    private final LuceneAnalyzerWrapper queryAnalyzerWrapper;

    public LuceneAnalyzerCombinationProvider(@Nonnull AnalyzerChooser defaultIndexAnalyzerChooser, @Nonnull AnalyzerChooser defaultQueryAnalyzerChooser, @Nullable Map<String, AnalyzerChooser> indexAnalyzerChooserPerFieldOverride, @Nullable Map<String, AnalyzerChooser> queryAnalyzerChooserPerFieldOverride) {
        this.indexAnalyzerWrapper = LuceneAnalyzerCombinationProvider.buildAnalyzerWrapper(defaultIndexAnalyzerChooser, indexAnalyzerChooserPerFieldOverride);
        this.queryAnalyzerWrapper = LuceneAnalyzerCombinationProvider.buildAnalyzerWrapper(defaultQueryAnalyzerChooser, queryAnalyzerChooserPerFieldOverride);
    }

    @Nonnull
    public LuceneAnalyzerWrapper provideIndexAnalyzer() {
        return this.indexAnalyzerWrapper;
    }

    @Nonnull
    public LuceneAnalyzerWrapper provideQueryAnalyzer() {
        return this.queryAnalyzerWrapper;
    }

    @Nonnull
    private static LuceneAnalyzerWrapper buildAnalyzerWrapper(@Nonnull AnalyzerChooser defaultAnalyzerChooser, @Nullable Map<String, AnalyzerChooser> customizedAnalyzerChooserPerField) {
        LuceneAnalyzerWrapper defaultAnalyzerWrapper = defaultAnalyzerChooser.chooseAnalyzer();
        if (customizedAnalyzerChooserPerField != null) {
            TreeMap<String, LuceneAnalyzerWrapper> analyzerWrapperMap = new TreeMap<String, LuceneAnalyzerWrapper>(customizedAnalyzerChooserPerField.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((AnalyzerChooser)e.getValue()).chooseAnalyzer())));
            PerFieldAnalyzerWrapper analyzerWrapper = new PerFieldAnalyzerWrapper(defaultAnalyzerWrapper.getAnalyzer(), analyzerWrapperMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((LuceneAnalyzerWrapper)e.getValue()).getAnalyzer())));
            String analyzerId = LuceneAnalyzerCombinationProvider.buildAnalyzerIdentifier(defaultAnalyzerWrapper, analyzerWrapperMap);
            return new LuceneAnalyzerWrapper(analyzerId, (Analyzer)analyzerWrapper);
        }
        return defaultAnalyzerWrapper;
    }

    private static String buildAnalyzerIdentifier(@Nonnull LuceneAnalyzerWrapper defaultAnalyzerWrapper, @Nonnull Map<String, LuceneAnalyzerWrapper> analyzerWrapperMap) {
        StringBuilder builder = new StringBuilder();
        builder.append(defaultAnalyzerWrapper.getUniqueIdentifier());
        for (String id : analyzerWrapperMap.keySet()) {
            builder.append(",");
            builder.append(id);
        }
        return builder.toString();
    }
}

