/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.AnalyzerChooser;
import com.apple.foundationdb.record.lucene.EmailCjkSynonymAnalyzer;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerFactory;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerType;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerWrapper;
import com.apple.foundationdb.record.lucene.synonym.SynonymMapRegistryImpl;
import com.apple.foundationdb.record.metadata.Index;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;

public class EmailCjkSynonymAnalyzerFactory
implements LuceneAnalyzerFactory {
    public static final String ANALYZER_FACTORY_NAME = "SYNONYM_EMAIL";
    public static final String UNIQUE_IDENTIFIER = "synonym_email";
    private static final String DEFAULT_MINIMUM_TOKEN_LENGTH = "3";
    private static final String DEFAULT_MAXIMUM_TOKEN_LENGTH = "30";
    public static final CharArraySet MINIMAL_STOP_WORDS = new CharArraySet(List.of("into", "onto", "the"), true);

    @Override
    @Nonnull
    public String getName() {
        return ANALYZER_FACTORY_NAME;
    }

    @Override
    @Nonnull
    public LuceneAnalyzerType getType() {
        return LuceneAnalyzerType.FULL_TEXT;
    }

    @Override
    @Nonnull
    public AnalyzerChooser getIndexAnalyzerChooser(@Nonnull Index index) {
        try {
            String minLengthString = Optional.ofNullable(index.getOption("textTokenMinSize")).orElse(DEFAULT_MINIMUM_TOKEN_LENGTH);
            String maxLengthString = Optional.ofNullable(index.getOption("textTokenMaxSize")).orElse(Integer.toString(255));
            return () -> new LuceneAnalyzerWrapper(UNIQUE_IDENTIFIER, (Analyzer)new EmailCjkSynonymAnalyzer(MINIMAL_STOP_WORDS, 1, Integer.parseInt(minLengthString), Integer.parseInt(maxLengthString), true, false, null));
        }
        catch (NumberFormatException ex) {
            throw new RecordCoreException("Invalid parameter for Lucene analyzer's token length", (Throwable)ex);
        }
    }

    @Override
    @Nonnull
    public AnalyzerChooser getQueryAnalyzerChooser(@Nonnull Index index, @Nonnull AnalyzerChooser indexAnalyzerChooser) {
        try {
            String minLengthString = Optional.ofNullable(index.getOption("textTokenMinSize")).orElse(DEFAULT_MINIMUM_TOKEN_LENGTH);
            String maxLengthString = Optional.ofNullable(index.getOption("textTokenMaxSize")).orElse(DEFAULT_MAXIMUM_TOKEN_LENGTH);
            String synonymConfigName = index.getOption("textSynonymSetName");
            return () -> new LuceneAnalyzerWrapper(UNIQUE_IDENTIFIER, (Analyzer)new EmailCjkSynonymAnalyzer(MINIMAL_STOP_WORDS, 1, Integer.parseInt(minLengthString), Integer.parseInt(maxLengthString), true, synonymConfigName != null, synonymConfigName != null ? SynonymMapRegistryImpl.instance().getSynonymMap(synonymConfigName) : null));
        }
        catch (NumberFormatException ex) {
            throw new RecordCoreException("Invalid parameter for Lucene analyzer's token length", (Throwable)ex);
        }
    }
}

