/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.lucene.filter.AlphanumericLengthFilter;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class AlphanumericLengthFilterFactory
extends TokenFilterFactory {
    final int min;
    final int max;
    public static final String MIN_KEY = "min";
    public static final String MAX_KEY = "max";

    public AlphanumericLengthFilterFactory(Map<String, String> args) {
        super(args);
        this.min = this.requireInt(args, MIN_KEY);
        this.max = this.requireInt(args, MAX_KEY);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + String.valueOf(args));
        }
    }

    public TokenStream create(TokenStream input) {
        return new AlphanumericLengthFilter(input, this.min, this.max);
    }
}

