/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.highlight;

import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.lucene.LuceneIndexTestUtils;
import com.apple.foundationdb.record.lucene.highlight.HighlightedTerm;
import com.apple.foundationdb.record.lucene.highlight.LuceneHighlighting;
import com.apple.foundationdb.record.lucene.synonym.SynonymMapRegistryImpl;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBQueriedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreTestBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexOrphanBehavior;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanBounds;
import com.apple.foundationdb.record.query.plan.QueryPlanner;
import com.apple.foundationdb.record.util.pair.Pair;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class LuceneLocaleTest
extends FDBRecordStoreTestBase {
    @BeforeAll
    public static void setup() {
        SynonymMapRegistryImpl.instance().getSynonymMap("EXPANDED_US_EN");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(strings={"default", "en_US", "de", "de_DE", "fr"})
    void highlightedNumberRangeQuery(Locale locale) {
        Locale defaultLocale = Locale.getDefault();
        try {
            Locale.setDefault(locale);
            try (FDBRecordContext context = this.openContext();){
                this.rebuildIndexMetaData(context, "ComplexDocument", LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1623L, "Hello record layer", "Hello record layer 2", 5L, 1234097, false, 8.123));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1623L, "Hello record layer", "Hello record layer 2", -110000000L, 999999, false, 4.134059823));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1623L, "Hello record layer", "Hello record layer 2", 51000L, 2000000, false, 9.2));
                Assertions.assertAll((Executable[])new Executable[]{() -> this.assertHighlightMatches("text: record AND group: [-12,340,984 TO 42,938]"), () -> this.assertHighlightMatches("text: record AND score: [1,000,000 TO 1,500,000]"), () -> this.assertHighlightMatches("text: record AND time: [4.913442 TO 8.14234]"), () -> this.assertSearchMatches("text: record AND group: [-12,340,984 TO 42,938]"), () -> this.assertSearchMatches("text: record AND score: [1,000,000 TO 1,500,000]"), () -> this.assertSearchMatches("text: record AND time: [4.913442 TO 8.14234]")});
            }
        }
        finally {
            Locale.setDefault(defaultLocale);
        }
    }

    private void assertSearchMatches(String search) {
        Assertions.assertEquals(List.of(Long.valueOf(1623L)), this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, (IndexScanBounds)LuceneIndexTestUtils.fullTextSearch(this.recordStore, LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, search, false), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR).map(r -> r.getPrimaryKey().get(1)).asList().join());
    }

    private void assertHighlightMatches(String search) {
        this.assertRecordHighlights(List.of("Hello {record} layer"), (RecordCursor<FDBIndexedRecord<Message>>)this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, (IndexScanBounds)LuceneIndexTestUtils.fullTextSearch(this.recordStore, LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, search, true), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR));
    }

    private void rebuildIndexMetaData(FDBRecordContext context, String document, Index index) {
        Pair<FDBRecordStore, QueryPlanner> pair = LuceneIndexTestUtils.rebuildIndexMetaData(context, this.path, document, index, this.isUseCascadesPlanner());
        this.recordStore = (FDBRecordStore)pair.getLeft();
        this.planner = (QueryPlanner)pair.getRight();
    }

    private void assertRecordHighlights(List<String> texts, RecordCursor<FDBIndexedRecord<Message>> cursor) {
        ArrayList highlighted = new ArrayList();
        cursor.forEach(rec -> {
            for (HighlightedTerm highlightedTerm : LuceneHighlighting.highlightedTermsForMessage((FDBQueriedRecord)FDBQueriedRecord.indexed((FDBIndexedRecord)rec), null)) {
                StringBuilder str = new StringBuilder(highlightedTerm.getSummarizedText());
                int offset = 0;
                for (int p = 0; p < highlightedTerm.getNumHighlights(); ++p) {
                    int start = highlightedTerm.getHighlightStart(p);
                    int end = highlightedTerm.getHighlightEnd(p);
                    str.insert(offset + start, "{");
                    str.insert(++offset + end, "}");
                    ++offset;
                }
                highlighted.add(str.toString());
            }
        }).join();
        Assertions.assertEquals(texts, highlighted);
    }
}

