/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.IndexValidator;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerFactory;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerRegistry;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.util.ServiceLoaderProvider;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestingIndexMaintainerRegistry
implements IndexMaintainerRegistry {
    @Nonnull
    private static final Logger LOGGER = LoggerFactory.getLogger(TestingIndexMaintainerRegistry.class);
    @Nonnull
    private final Map<String, IndexMaintainerFactory> registry = new HashMap<String, IndexMaintainerFactory>();

    public TestingIndexMaintainerRegistry() {
        this.initRegistry();
    }

    @Nonnull
    public IndexValidator getIndexValidator(@Nonnull Index index) {
        IndexMaintainerFactory factory = this.registry.get(index.getType());
        if (factory == null) {
            throw new MetaDataException("Unknown index type for " + String.valueOf(index), new Object[0]);
        }
        return factory.getIndexValidator(index);
    }

    @Nonnull
    public IndexMaintainer getIndexMaintainer(@Nonnull IndexMaintainerState state) {
        IndexMaintainerFactory factory = this.registry.get(state.index.getType());
        if (factory == null) {
            throw new MetaDataException("Unknown index type for " + String.valueOf(state.index), new Object[0]);
        }
        return factory.getIndexMaintainer(state);
    }

    public void overrideFactory(IndexMaintainerFactory factory) {
        this.registerFactory(factory, true);
    }

    private void initRegistry() {
        for (IndexMaintainerFactory factory : ServiceLoaderProvider.load(IndexMaintainerFactory.class)) {
            this.registerFactory(factory, false);
        }
    }

    private void registerFactory(IndexMaintainerFactory factory, boolean allowOverride) {
        for (String type : factory.getIndexTypes()) {
            if (this.registry.containsKey(type) && !allowOverride) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(KeyValueLogMessage.of((String)"duplicate index maintainer", (Object[])new Object[]{LogMessageKeys.INDEX_TYPE, type}));
                continue;
            }
            this.registry.put(type, factory);
        }
    }
}

