/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.lucene.LuceneIndexMaintainer;
import com.apple.foundationdb.record.lucene.directory.FDBDirectoryManager;
import com.apple.foundationdb.record.lucene.directory.InjectedFailureRepository;
import com.apple.foundationdb.record.lucene.directory.MockedFDBDirectoryManager;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexableRecord;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.google.protobuf.Message;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MockedLuceneIndexMaintainer
extends LuceneIndexMaintainer {
    final InjectedFailureRepository injectedFailures;

    public MockedLuceneIndexMaintainer(@Nonnull IndexMaintainerState state, @Nonnull Executor executor, InjectedFailureRepository injectedFailures) {
        super(state, executor);
        this.injectedFailures = injectedFailures;
        ((MockedFDBDirectoryManager)this.getDirectoryManager()).setInjectedFailures(injectedFailures);
    }

    @Nonnull
    public <M extends Message> CompletableFuture<Void> update(@Nullable FDBIndexableRecord<M> oldRecord, @Nullable FDBIndexableRecord<M> newRecord) {
        if (this.injectedFailures.hasFlag(InjectedFailureRepository.Flags.LUCENE_MAINTAINER_SKIP_INDEX_UPDATE)) {
            return AsyncUtil.DONE;
        }
        return super.update(oldRecord, newRecord);
    }

    @Nonnull
    protected FDBDirectoryManager createDirectoryManager(@Nonnull IndexMaintainerState state) {
        return MockedFDBDirectoryManager.getManager(state);
    }
}

