/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedCodec;
import com.apple.foundationdb.record.lucene.search.LuceneOptimizedIndexSearcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;

public class FDBLuceneTestIndex {
    private final Directory directory;
    private final Analyzer analyzer;

    public FDBLuceneTestIndex(Directory directory, Analyzer analyzer) {
        this.directory = directory;
        this.analyzer = analyzer;
    }

    public void indexDocument(String title, String body) throws IOException {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(this.analyzer);
        indexWriterConfig.setCodec((Codec)LuceneOptimizedCodec.CODEC);
        try (IndexWriter writer = new IndexWriter(this.directory, indexWriterConfig);){
            Document document = new Document();
            document.add((IndexableField)new TextField("title", title, Field.Store.YES));
            document.add((IndexableField)new TextField("body", body, Field.Store.YES));
            document.add((IndexableField)new SortedDocValuesField("title", new BytesRef((CharSequence)title)));
            writer.addDocument((Iterable)document);
        }
    }

    public List<Document> searchIndex(String inField, String queryString) throws ParseException, IOException {
        Query query = new QueryParser(inField, this.analyzer).parse(queryString);
        try (DirectoryReader indexReader = DirectoryReader.open((Directory)this.directory);){
            LuceneOptimizedIndexSearcher searcher = new LuceneOptimizedIndexSearcher((IndexReader)indexReader);
            TopDocs topDocs = searcher.search(query, 10);
            ArrayList<Document> documents = new ArrayList<Document>();
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                documents.add(searcher.doc(scoreDoc.doc));
            }
            ArrayList<Document> arrayList = documents;
            return arrayList;
        }
    }

    public List<Document> searchIndex(Query query) throws IOException {
        try (DirectoryReader indexReader = DirectoryReader.open((Directory)this.directory);){
            LuceneOptimizedIndexSearcher searcher = new LuceneOptimizedIndexSearcher((IndexReader)indexReader);
            TopDocs topDocs = searcher.search(query, 10);
            ArrayList<Document> documents = new ArrayList<Document>();
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                documents.add(searcher.doc(scoreDoc.doc));
            }
            ArrayList<Document> arrayList = documents;
            return arrayList;
        }
    }

    public List<Document> searchIndex(Query query, Sort sort) throws IOException {
        try (DirectoryReader indexReader = DirectoryReader.open((Directory)this.directory);){
            LuceneOptimizedIndexSearcher searcher = new LuceneOptimizedIndexSearcher((IndexReader)indexReader);
            TopFieldDocs topDocs = searcher.search(query, 10, sort);
            ArrayList<Document> documents = new ArrayList<Document>();
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                documents.add(searcher.doc(scoreDoc.doc));
            }
            ArrayList<Document> arrayList = documents;
            return arrayList;
        }
    }

    public void deleteDocument(Term term) throws IOException {
        try (IndexWriter writer = new IndexWriter(this.directory, new IndexWriterConfig(this.analyzer));){
            writer.deleteDocuments(new Term[]{term});
        }
    }
}

