/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.lucene.LuceneConcurrency;
import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.directory.EmptyIndexInput;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.lucene.directory.FDBDirectoryBaseTest;
import com.apple.foundationdb.record.lucene.directory.FDBLuceneFileReference;
import com.apple.foundationdb.record.lucene.directory.LuceneSerializer;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.lucene.store.IndexInput;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@Tag(value="RequiresFDB")
public class FDBDirectoryTest
extends FDBDirectoryBaseTest {
    @Test
    public void testDirectoryCreate() {
        Assertions.assertNotNull((Object)this.directory, (String)"directory should not be null");
        Assertions.assertEquals((Object)this.subspace, (Object)this.directory.getSubspace());
    }

    @Test
    public void testGetIncrement() throws IOException {
        Assertions.assertEquals((long)1L, (long)this.directory.getIncrement());
        Assertions.assertEquals((long)2L, (long)this.directory.getIncrement());
        this.assertCorrectMetricCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_GET_INCREMENT_CALLS, 2);
        this.directory.getCallerContext().commit();
        try (FDBRecordContext context = this.fdb.openContext();){
            this.directory = new FDBDirectory(this.subspace, context, null);
            Assertions.assertEquals((long)3L, (long)this.directory.getIncrement());
        }
    }

    @Test
    public void testConcurrentGetIncrement() throws IOException {
        int threads = 50;
        ArrayList<CompletableFuture<Long>> futures = new ArrayList<CompletableFuture<Long>>(50);
        for (int i = 0; i < 50; ++i) {
            futures.add(CompletableFuture.supplyAsync(() -> {
                try {
                    return this.directory.getIncrement();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, this.directory.getCallerContext().getExecutor()));
        }
        List values = (List)AsyncUtil.getAll(futures).join();
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.containsInAnyOrder((Collection)LongStream.range(1L, 51L).mapToObj(Matchers::equalTo).collect(Collectors.toList())));
        this.assertCorrectMetricCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_GET_INCREMENT_CALLS, 50);
        this.assertMetricCountAtMost((StoreTimer.Event)LuceneEvents.Waits.WAIT_LUCENE_GET_INCREMENT, 50);
        this.directory.getCallerContext().commit();
        try (FDBRecordContext context = this.fdb.openContext();){
            this.directory = new FDBDirectory(this.subspace, context, null);
            Assertions.assertEquals((long)51L, (long)this.directory.getIncrement());
        }
    }

    @Test
    public void testWriteGetLuceneFileReference() {
        FDBLuceneFileReference luceneFileReference = this.directory.getFDBLuceneFileReference("NonExist");
        Assertions.assertNull((Object)luceneFileReference);
        String luceneReference1 = "luceneReference1";
        FDBLuceneFileReference fileReference = new FDBLuceneFileReference(1L, 10L, 10L, 10L);
        this.directory.writeFDBLuceneFileReference(luceneReference1, fileReference);
        FDBLuceneFileReference actual = this.directory.getFDBLuceneFileReference(luceneReference1);
        Assertions.assertNotNull((Object)actual, (String)"file reference should exist");
        Assertions.assertEquals((Object)actual, (Object)fileReference);
    }

    @Test
    public void testWriteLuceneFileReference() {
        FDBLuceneFileReference reference1 = new FDBLuceneFileReference(2L, 1L, 1L, 1L);
        this.directory.writeFDBLuceneFileReference("test1", reference1);
        FDBLuceneFileReference reference2 = new FDBLuceneFileReference(3L, 1L, 1L, 1L);
        this.directory.writeFDBLuceneFileReference("test1", reference2);
        FDBLuceneFileReference luceneFileReference = this.directory.getFDBLuceneFileReference("test1");
        Assertions.assertNotNull((Object)luceneFileReference, (String)"fileReference should exist");
        this.assertCorrectMetricSize((StoreTimer.SizeEvent)LuceneEvents.SizeEvents.LUCENE_WRITE_FILE_REFERENCE, 2, LuceneSerializer.encode((byte[])reference1.getBytes(), (boolean)true, (boolean)false).length + LuceneSerializer.encode((byte[])reference2.getBytes(), (boolean)true, (boolean)false).length);
    }

    @Test
    public void testMissingSeek() {
        CompletableFuture seekFuture = this.directory.readBlock((IndexInput)new EmptyIndexInput("Test Empty"), "testDescription", this.directory.getFDBLuceneFileReferenceAsync("testReference"), 1);
        FDBRecordContext context = this.directory.getCallerContext();
        Assertions.assertThrows(RecordCoreArgumentException.class, () -> LuceneConcurrency.asyncToSync((StoreTimer.Wait)LuceneEvents.Waits.WAIT_LUCENE_GET_DATA_BLOCK, (CompletableFuture)seekFuture, (FDBRecordContext)context));
    }

    @Test
    public void testWriteSeekData() throws Exception {
        this.directory.writeFDBLuceneFileReference("testReference1", new FDBLuceneFileReference(1L, 1L, 1L, 1L));
        EmptyIndexInput emptyInput = new EmptyIndexInput("Empty Input");
        Assertions.assertNull(this.directory.readBlock((IndexInput)emptyInput, "testReference1", this.directory.getFDBLuceneFileReferenceAsync("testReference1"), 1).get());
        this.directory.writeFDBLuceneFileReference("testReference2", new FDBLuceneFileReference(2L, 1L, 1L, 200L));
        byte[] data = "test string for write".getBytes();
        this.directory.writeData(2L, 1, data);
        Assertions.assertNotNull(this.directory.readBlock((IndexInput)emptyInput, "testReference2", this.directory.getFDBLuceneFileReferenceAsync("testReference2"), 1).get(), (String)"seek data should exist");
        this.directory.getCallerContext().commit();
        this.assertCorrectMetricSize((StoreTimer.SizeEvent)LuceneEvents.SizeEvents.LUCENE_WRITE, 1, LuceneSerializer.encode((byte[])data, (boolean)true, (boolean)false).length);
    }

    @Test
    public void testListAll() throws IOException {
        Assertions.assertEquals((int)this.directory.listAll().length, (int)0);
        this.directory.writeFDBLuceneFileReference("test1", new FDBLuceneFileReference(1L, 1L, 1L, 1L));
        this.directory.writeFDBLuceneFileReference("test2", new FDBLuceneFileReference(2L, 1L, 1L, 1L));
        this.directory.writeFDBLuceneFileReference("test3", new FDBLuceneFileReference(3L, 1L, 1L, 1L));
        Assertions.assertArrayEquals((Object[])new String[]{"test1", "test2", "test3"}, (Object[])this.directory.listAll());
        this.assertCorrectMetricCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_LIST_ALL, 2);
        this.assertCorrectMetricCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_LOAD_FILE_CACHE, 1);
        this.directory.getCallerContext().ensureActive().cancel();
        FDBStoreTimer timer = new FDBStoreTimer();
        try (FDBRecordContext context = this.fdb.openContext(null, timer);){
            this.directory = new FDBDirectory(this.subspace, context, null);
            Assertions.assertArrayEquals((Object[])new String[0], (Object[])this.directory.listAll());
            Assertions.assertEquals((int)1, (int)timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_LIST_ALL));
            Assertions.assertEquals((int)1, (int)timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_LOAD_FILE_CACHE));
        }
    }

    @Test
    public void testDeleteData() throws Exception {
        Assertions.assertThrows(NoSuchFileException.class, () -> this.directory.deleteFile("NonExist"));
        FDBLuceneFileReference reference1 = new FDBLuceneFileReference(1L, 1L, 1L, 1L);
        this.directory.writeFDBLuceneFileReference("test1", reference1);
        this.directory.deleteFile("test1");
        Assertions.assertEquals((int)this.directory.listAll().length, (int)0);
        this.assertMetricCountAtMost((StoreTimer.Event)LuceneEvents.Waits.WAIT_LUCENE_DELETE_FILE, 2);
    }

    @Test
    public void testFileLength() throws Exception {
        long expectedSize = 20L;
        FDBLuceneFileReference reference1 = new FDBLuceneFileReference(1L, expectedSize, expectedSize, 1024L);
        this.directory.writeFDBLuceneFileReference("test1", reference1);
        long fileSize = this.directory.fileLength("test1");
        Assertions.assertEquals((long)expectedSize, (long)fileSize);
        this.assertCorrectMetricCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_GET_FILE_LENGTH, 1);
        this.directory.getCallerContext().commit();
        FDBStoreTimer timer = new FDBStoreTimer();
        try (FDBRecordContext context = this.fdb.openContext(null, timer);){
            this.directory = new FDBDirectory(this.subspace, context, null);
            long fileSize2 = this.directory.fileLength("test1");
            Assertions.assertEquals((long)expectedSize, (long)fileSize2);
            Assertions.assertEquals((int)1, (int)timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_GET_FILE_LENGTH));
            Assertions.assertEquals((int)1, (int)timer.getCount((StoreTimer.Event)LuceneEvents.Waits.WAIT_LUCENE_FILE_LENGTH));
        }
    }

    static Stream<Arguments> testFileLengthNonExistent() {
        return Stream.of("nonExist", "nonExistentEntries.cfe", "nonExistentSegmentInfo.si").map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest(name="testFileLengthNonExistent[fileName={0}]")
    @MethodSource
    public void testFileLengthNonExistent(String fileName) {
        Assertions.assertThrows(NoSuchFileException.class, () -> this.directory.fileLength(fileName));
    }

    @Test
    public void testRename() {
        IOException ioException = (IOException)Assertions.assertThrows(IOException.class, () -> this.directory.rename("NoExist", "newName"));
        Assertions.assertTrue((boolean)(ioException.getCause() instanceof RecordCoreArgumentException));
        this.assertCorrectMetricCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_RENAME_FILE, 1);
    }

    private void assertCorrectMetricCount(StoreTimer.Event metric, int expectedValue) {
        Assertions.assertEquals((int)expectedValue, (int)this.timer.getCount(metric), () -> "Incorrect call count for metric " + String.valueOf(metric));
    }

    private void assertCorrectMetricSize(StoreTimer.SizeEvent metric, int expectedNumber, long expectedCumulativeBytes) {
        Assertions.assertEquals((int)expectedNumber, (int)this.timer.getCount((StoreTimer.Event)metric), () -> "Incorrect call count for metric " + String.valueOf(metric));
        Assertions.assertEquals((long)expectedCumulativeBytes, (long)this.timer.getSize(metric), () -> "Incorrect size for metric " + String.valueOf(metric));
    }

    private void assertMetricCountAtMost(StoreTimer.Event metric, int maximumValue) {
        MatcherAssert.assertThat((String)("Metric " + String.valueOf(metric) + " should be called at most " + maximumValue + " times"), (Object)this.timer.getCount(metric), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(maximumValue)));
    }
}

