/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.record.lucene.codec.FDBThreadFilter;
import com.apple.foundationdb.record.lucene.codec.TestFDBDirectory;
import com.apple.foundationdb.record.lucene.codec.TestingCodec;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakFilters;
import java.io.IOException;
import java.util.Random;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.compressing.CompressingCodec;
import org.apache.lucene.index.BaseIndexFileFormatTestCase;
import org.apache.lucene.index.BaseIndexFileFormatTestCaseUtils;
import org.apache.lucene.index.BaseStoredFieldsFormatTestCase;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestRuleLimitSysouts;
import org.junit.Before;
import org.junit.Ignore;

@ThreadLeakFilters(defaultFilters=true, filters={FDBThreadFilter.class})
@TestRuleLimitSysouts.Limit(bytes=50000L)
public class LuceneOptimizedStoredFieldsFormatTest
extends BaseStoredFieldsFormatTestCase {
    protected Codec getCodec() {
        if (LuceneOptimizedStoredFieldsFormatTest.isUsingFDBDirectory()) {
            return new TestingCodec();
        }
        return CompressingCodec.randomInstance((Random)new Random());
    }

    private static boolean isUsingFDBDirectory() {
        return System.getProperty("tests.directory", "random").equals(TestFDBDirectory.class.getName());
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        TestingCodec.reset();
        TestFDBDirectory.reset();
        BaseIndexFileFormatTestCaseUtils.resetStaticConfigs();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        TestingCodec.reset();
        TestFDBDirectory.reset();
        BaseIndexFileFormatTestCaseUtils.resetStaticConfigs();
    }

    public void testNumericField() throws Exception {
        TestingCodec.disableLaziness();
        super.testNumericField();
    }

    public void testRandomExceptions() throws Exception {
        TestingCodec.disableLazinessForLiveDocs();
        super.testRandomExceptions();
    }

    @Ignore
    @LuceneTestCase.Nightly
    public void testRamBytesUsed() throws IOException {
        TestingCodec.disableLaziness();
        TestFDBDirectory.useFullBufferToSurviveDeletes();
        super.testRamBytesUsed();
    }

    @Ignore
    @LuceneTestCase.Nightly
    public void testBigDocuments() throws IOException {
        super.testBigDocuments();
    }

    public void testMismatchedFields() throws Exception {
        TestFDBDirectory.allowAddIndexes();
        super.testMismatchedFields();
    }

    public void testMultiClose() throws IOException {
        BaseIndexFileFormatTestCaseUtils.testMultiClose((BaseIndexFileFormatTestCase)this);
    }
}

