/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.record.TestHelpers;
import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.LuceneFieldInfosProto;
import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedCodec;
import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedFieldInfosFormat;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.lucene.directory.FieldInfosStorage;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreTestBase;
import com.apple.foundationdb.record.util.pair.Pair;
import com.apple.test.BooleanSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.MergeInfo;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="RequiresFDB")
class LuceneOptimizedFieldInfosFormatTest
extends FDBRecordStoreTestBase {
    final LuceneOptimizedFieldInfosFormat format = new LuceneOptimizedFieldInfosFormat();

    LuceneOptimizedFieldInfosFormatTest() {
    }

    @ParameterizedTest
    @BooleanSource
    void simpleTest(boolean oneTransaction) throws Exception {
        FieldInfos fieldInfos = LuceneOptimizedFieldInfosFormatTest.singleFieldInfos("foo", 0);
        LightSegmentInfo segment = new LightSegmentInfo();
        this.sameOrMultiTransaction(oneTransaction, (TestHelpers.DangerousConsumer<FDBDirectory>)((TestHelpers.DangerousConsumer)directory -> this.write((Directory)directory, segment, fieldInfos)), (TestHelpers.DangerousConsumer<FDBDirectory>)((TestHelpers.DangerousConsumer)directory -> this.assertFieldInfosEqual(fieldInfos, this.read((Directory)directory, segment))));
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2})
    void deleteOne(int transactionBoundary) throws Exception {
        FieldInfos fieldInfos = LuceneOptimizedFieldInfosFormatTest.singleFieldInfos("foo", 0);
        LightSegmentInfo segment = new LightSegmentInfo();
        this.sameOrMultiTransaction(transactionBoundary, List.of(directory -> this.write((Directory)directory, segment, fieldInfos), directory -> directory.deleteFile(IndexFileNames.segmentFileName((String)segment.name, (String)"", (String)"fip")), directory -> Assertions.assertEquals(Map.of(), (Object)directory.getFieldInfosStorage().getAllFieldInfos())));
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2})
    void deleteMany(int transactionBoundary) throws Exception {
        int segmentCount = 4;
        List segments = IntStream.range(0, 4).mapToObj(i -> new LightSegmentInfo()).collect(Collectors.toList());
        FieldInfos fieldInfos = LuceneOptimizedFieldInfosFormatTest.singleFieldInfos("foo", 0);
        this.sameOrMultiTransaction(transactionBoundary, List.of(directory -> {
            for (LightSegmentInfo segment : segments) {
                this.write((Directory)directory, segment, fieldInfos);
            }
        }, directory -> {
            MatcherAssert.assertThat(directory.getFieldInfosStorage().getAllFieldInfos().keySet(), (Matcher)Matchers.hasSize((int)1));
            for (LightSegmentInfo segment : segments) {
                directory.deleteFile(IndexFileNames.segmentFileName((String)segment.name, (String)"", (String)"fip"));
            }
        }, directory -> Assertions.assertEquals(Map.of(), (Object)directory.getFieldInfosStorage().getAllFieldInfos())));
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2})
    void deleteManyIncompatible(int transactionBoundary) throws Exception {
        int segmentCount = 4;
        List segments = IntStream.range(0, 4).mapToObj(i -> new LightSegmentInfo()).collect(Collectors.toList());
        this.sameOrMultiTransaction(transactionBoundary, List.of(directory -> {
            int fieldInfoNumber = 0;
            for (LightSegmentInfo segment : segments) {
                this.write((Directory)directory, segment, LuceneOptimizedFieldInfosFormatTest.singleFieldInfos("foo" + fieldInfoNumber, 0));
                ++fieldInfoNumber;
            }
        }, directory -> {
            MatcherAssert.assertThat(directory.getFieldInfosStorage().getAllFieldInfos().keySet(), (Matcher)Matchers.hasSize((int)4));
            for (LightSegmentInfo segment : segments) {
                directory.deleteFile(IndexFileNames.segmentFileName((String)segment.name, (String)"", (String)"fip"));
            }
        }, directory -> Assertions.assertEquals(Map.of(), (Object)directory.getFieldInfosStorage().getAllFieldInfos())));
    }

    public static Stream<Arguments> deleteSome() {
        return IntStream.range(0, 4).boxed().flatMap(transactionBoundary -> IntStream.range(transactionBoundary - 1, 5).mapToObj(toDelete -> Arguments.of((Object[])new Object[]{transactionBoundary, toDelete})));
    }

    @ParameterizedTest
    @MethodSource
    void deleteSome(int transactionBoundary, int toDelete) throws Exception {
        int segmentCount = 6;
        MatcherAssert.assertThat((Object)6, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(toDelete)));
        List segments = IntStream.range(0, 6).mapToObj(i -> new LightSegmentInfo()).collect(Collectors.toList());
        FieldInfos fieldInfos = LuceneOptimizedFieldInfosFormatTest.singleFieldInfos("foo", 0);
        this.sameOrMultiTransaction(transactionBoundary, Stream.concat(Stream.of(directory -> {
            for (LightSegmentInfo segment : segments) {
                this.write((Directory)directory, segment, fieldInfos);
            }
        }), IntStream.range(0, toDelete).mapToObj(i -> directory -> {
            directory.deleteFile(IndexFileNames.segmentFileName((String)((LightSegmentInfo)segments.get((int)i)).name, (String)"", (String)"fip"));
            Assertions.assertEquals(Set.of(Long.valueOf(-2L)), directory.getFieldInfosStorage().getAllFieldInfos().keySet());
        })).collect(Collectors.toList()));
    }

    @ParameterizedTest
    @BooleanSource
    void emptyDoc(boolean oneTransaction) throws Exception {
        FieldInfos fieldInfos = new FieldInfos(new FieldInfo[0]);
        LightSegmentInfo segment = new LightSegmentInfo();
        this.sameOrMultiTransaction(oneTransaction, (TestHelpers.DangerousConsumer<FDBDirectory>)((TestHelpers.DangerousConsumer)directory -> this.write((Directory)directory, segment, fieldInfos)), (TestHelpers.DangerousConsumer<FDBDirectory>)((TestHelpers.DangerousConsumer)directory -> this.assertFieldInfosEqual(fieldInfos, this.read((Directory)directory, segment))));
    }

    @ParameterizedTest
    @BooleanSource
    void emptyDocInNextSegment(boolean oneTransaction) throws Exception {
        FieldInfo fieldInfo1 = LuceneOptimizedFieldInfosFormatTest.simpleFieldInfo("foo", 0);
        FieldInfos fieldInfos1 = new FieldInfos(new FieldInfo[]{fieldInfo1});
        FieldInfos fieldInfos2 = new FieldInfos(new FieldInfo[0]);
        this.testWithTwoSegments(oneTransaction, fieldInfos1, fieldInfos2, 1);
    }

    @ParameterizedTest
    @BooleanSource
    void addFieldInNextSegment(boolean oneTransaction) throws Exception {
        FieldInfo fieldInfo1 = LuceneOptimizedFieldInfosFormatTest.simpleFieldInfo("foo", 0);
        FieldInfo fieldInfo2 = LuceneOptimizedFieldInfosFormatTest.simpleFieldInfo("bar", 1);
        FieldInfos fieldInfos1 = new FieldInfos(new FieldInfo[]{fieldInfo1});
        FieldInfos fieldInfos2 = new FieldInfos(new FieldInfo[]{fieldInfo1, fieldInfo2});
        this.testWithTwoSegments(oneTransaction, fieldInfos1, fieldInfos2, 1);
    }

    @ParameterizedTest
    @BooleanSource
    void fewerFieldsInNextSegment(boolean oneTransaction) throws Exception {
        FieldInfo fieldInfo1 = LuceneOptimizedFieldInfosFormatTest.simpleFieldInfo("foo", 0);
        FieldInfo fieldInfo2 = LuceneOptimizedFieldInfosFormatTest.simpleFieldInfo("bar", 1);
        FieldInfos fieldInfos1 = new FieldInfos(new FieldInfo[]{fieldInfo1, fieldInfo2});
        FieldInfos fieldInfos2 = new FieldInfos(new FieldInfo[]{fieldInfo1});
        this.testWithTwoSegments(oneTransaction, fieldInfos1, fieldInfos2, 1);
    }

    @ParameterizedTest
    @BooleanSource
    void fewerFieldsInNextSegment2(boolean oneTransaction) throws Exception {
        FieldInfo fieldInfo1 = LuceneOptimizedFieldInfosFormatTest.simpleFieldInfo("foo", 0);
        FieldInfo fieldInfo2 = LuceneOptimizedFieldInfosFormatTest.simpleFieldInfo("bar", 1);
        FieldInfos fieldInfos1 = new FieldInfos(new FieldInfo[]{fieldInfo1, fieldInfo2});
        FieldInfos fieldInfos2 = new FieldInfos(new FieldInfo[]{fieldInfo2});
        this.testWithTwoSegments(oneTransaction, fieldInfos1, fieldInfos2, 1);
    }

    @ParameterizedTest
    @BooleanSource
    void mixedFieldNumbers(boolean oneTransaction) throws Exception {
        this.testWithTwoSegments(oneTransaction, LuceneOptimizedFieldInfosFormatTest.singleFieldInfos("foo", 0), LuceneOptimizedFieldInfosFormatTest.singleFieldInfos("foo", 1), 1);
    }

    @ParameterizedTest
    @BooleanSource
    void mixedFieldNames(boolean oneTransaction) throws Exception {
        this.testWithTwoSegments(oneTransaction, LuceneOptimizedFieldInfosFormatTest.singleFieldInfos("foo", 0), LuceneOptimizedFieldInfosFormatTest.singleFieldInfos("bar", 0), 2);
    }

    @ParameterizedTest
    @BooleanSource
    void mixedFieldNamesAndNumbers(boolean oneTransaction) throws Exception {
        FieldInfos fieldInfos1 = new FieldInfos(new FieldInfo[]{LuceneOptimizedFieldInfosFormatTest.simpleFieldInfo("foo", 0), LuceneOptimizedFieldInfosFormatTest.simpleFieldInfo("bar", 1)});
        FieldInfos fieldInfos2 = new FieldInfos(new FieldInfo[]{LuceneOptimizedFieldInfosFormatTest.simpleFieldInfo("bar", 0), LuceneOptimizedFieldInfosFormatTest.simpleFieldInfo("foo", 1)});
        this.testWithTwoSegments(oneTransaction, fieldInfos1, fieldInfos2, 2);
    }

    @ParameterizedTest
    @BooleanSource
    void mixedOrderAttributes(boolean oneTransaction) throws Exception {
        LinkedHashMap<String, String> attributes1 = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> attributes2 = new LinkedHashMap<String, String>();
        attributes1.put("first", "a");
        attributes1.put("second", "b");
        attributes2.put("second", "b");
        attributes2.put("first", "a");
        Assertions.assertEquals(attributes1, attributes2);
        Assertions.assertNotEquals(List.copyOf(attributes1.entrySet()), List.copyOf(attributes2.entrySet()));
        FieldInfos fieldInfos1 = new FieldInfos(new FieldInfo[]{LuceneOptimizedFieldInfosFormatTest.fieldInfo("foo", 0, attributes1)});
        FieldInfos fieldInfos2 = new FieldInfos(new FieldInfo[]{LuceneOptimizedFieldInfosFormatTest.fieldInfo("foo", 0, attributes2)});
        this.testWithTwoSegments(oneTransaction, fieldInfos1, fieldInfos2, 1);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3})
    void fixGlobalOrdering(int transactionBreak) throws Exception {
        Map<String, String> attributes = Map.of("first", "a", "second", "b");
        FieldInfos fieldInfos1 = new FieldInfos(new FieldInfo[]{LuceneOptimizedFieldInfosFormatTest.fieldInfo("foo", 0, attributes)});
        FieldInfos fieldInfos2 = new FieldInfos(new FieldInfo[]{LuceneOptimizedFieldInfosFormatTest.fieldInfo("foo", 0, attributes)});
        LightSegmentInfo segment1 = new LightSegmentInfo();
        LightSegmentInfo segment2 = new LightSegmentInfo();
        this.sameOrMultiTransaction(transactionBreak, List.of(directory -> this.write((Directory)directory, segment1, fieldInfos1), directory -> {
            FieldInfosStorage fieldInfoStorage = directory.getFieldInfosStorage();
            LuceneFieldInfosProto.FieldInfos global = fieldInfoStorage.readFieldInfos(-2L);
            LuceneFieldInfosProto.FieldInfos.Builder builder = global.toBuilder();
            LuceneFieldInfosProto.FieldInfo.Builder fieldInfoBuilder = builder.getFieldInfoBuilder(0);
            ArrayList<LuceneFieldInfosProto.Attribute> reversedAttributes = new ArrayList<LuceneFieldInfosProto.Attribute>();
            List serializedAttributes = fieldInfoBuilder.getAttributesList();
            for (int i = serializedAttributes.size() - 1; i >= 0; --i) {
                reversedAttributes.add((LuceneFieldInfosProto.Attribute)serializedAttributes.get(i));
            }
            fieldInfoBuilder.clearAttributes();
            fieldInfoBuilder.addAllAttributes(reversedAttributes);
            LuceneFieldInfosProto.FieldInfos newGlobal = builder.build();
            Assertions.assertNotEquals((Object)global.getFieldInfo(0), (Object)newGlobal.getFieldInfo(0));
            fieldInfoStorage.updateGlobalFieldInfos(newGlobal);
        }, directory -> {
            FieldInfosStorage fieldInfoStorage = directory.getFieldInfosStorage();
            LuceneFieldInfosProto.FieldInfos global = fieldInfoStorage.readFieldInfos(-2L);
            Assertions.assertEquals(global.getFieldInfo(0).getAttributesList().stream().map(LuceneFieldInfosProto.Attribute::getKey).collect(Collectors.toList()), List.of("second", "first"));
            this.write((Directory)directory, segment2, fieldInfos2);
        }, directory -> {
            this.assertFieldInfosEqual(fieldInfos1, this.read((Directory)directory, segment1));
            this.assertFieldInfosEqual(fieldInfos2, this.read((Directory)directory, segment2));
            Assertions.assertEquals((int)1, (Integer)((Integer)directory.asyncToSync((StoreTimer.Wait)LuceneEvents.Waits.WAIT_LUCENE_READ_FIELD_INFOS, directory.getFieldInfosCount())));
            FieldInfosStorage fieldInfoStorage = directory.getFieldInfosStorage();
            LuceneFieldInfosProto.FieldInfos global = fieldInfoStorage.readFieldInfos(-2L);
            Assertions.assertEquals(global.getFieldInfo(0).getAttributesList().stream().map(LuceneFieldInfosProto.Attribute::getKey).collect(Collectors.toList()), List.of("first", "second"));
        }));
    }

    @ParameterizedTest
    @BooleanSource
    void serializeAll(boolean oneTransaction) throws Exception {
        List fieldInfos = Stream.of(this.trueOrFalse().map(storeTermVector -> LuceneOptimizedFieldInfosFormatTest.fieldInfoA(storeTermVector, false, false)), this.trueOrFalse().map(omitNorms -> LuceneOptimizedFieldInfosFormatTest.fieldInfoA(false, omitNorms, false)), this.trueOrFalse().map(storePayloads -> LuceneOptimizedFieldInfosFormatTest.fieldInfoA(false, false, storePayloads)), Arrays.stream(IndexOptions.values()).map(indexOptions -> LuceneOptimizedFieldInfosFormatTest.fieldInfoB(indexOptions, DocValuesType.NUMERIC, 1, Map.of())), Arrays.stream(DocValuesType.values()).map(docValuesType -> LuceneOptimizedFieldInfosFormatTest.fieldInfoB(IndexOptions.DOCS, docValuesType, -1, Map.of())), Stream.of(0, 1, 2).map(dvGen -> LuceneOptimizedFieldInfosFormatTest.fieldInfoB(IndexOptions.DOCS, DocValuesType.NUMERIC, dvGen, Map.of())), this.someAttributes().map(attributes -> LuceneOptimizedFieldInfosFormatTest.fieldInfoB(IndexOptions.DOCS, DocValuesType.NUMERIC, 1, attributes)), Stream.of(2, 3).map(pointDimensionCount -> LuceneOptimizedFieldInfosFormatTest.fieldInfoC(pointDimensionCount, 1, 1, false)), Stream.of(2, 3).map(pointIndexDimensionCount -> LuceneOptimizedFieldInfosFormatTest.fieldInfoC(1, pointIndexDimensionCount, 1, false)), Stream.of(2, 3).map(pointNumBytes -> LuceneOptimizedFieldInfosFormatTest.fieldInfoC(1, 1, pointNumBytes, false)), this.trueOrFalse().map(softDeletesField -> LuceneOptimizedFieldInfosFormatTest.fieldInfoC(1, 1, 1, softDeletesField))).flatMap(stream -> stream).map(fieldInfo -> Pair.of((Object)new LightSegmentInfo(), (Object)fieldInfo)).collect(Collectors.toList());
        this.sameOrMultiTransaction(oneTransaction, (TestHelpers.DangerousConsumer<FDBDirectory>)((TestHelpers.DangerousConsumer)directory -> {
            for (Pair pair : fieldInfos) {
                this.write((Directory)directory, (LightSegmentInfo)pair.getLeft(), new FieldInfos(new FieldInfo[]{(FieldInfo)pair.getRight()}));
            }
        }), (TestHelpers.DangerousConsumer<FDBDirectory>)((TestHelpers.DangerousConsumer)directory -> {
            for (Pair pair : fieldInfos) {
                this.assertFieldInfosEqual(new FieldInfos(new FieldInfo[]{(FieldInfo)pair.getRight()}), this.read((Directory)directory, (LightSegmentInfo)pair.getLeft()));
            }
        }));
    }

    @ParameterizedTest
    @BooleanSource
    void nrtCachingDirectory(boolean oneTransaction) throws Exception {
        Directory directory;
        FieldInfos fieldInfos = LuceneOptimizedFieldInfosFormatTest.singleFieldInfos("foo", 0);
        LightSegmentInfo segment = new LightSegmentInfo();
        Function<FDBRecordContext, NRTCachingDirectory> createDirectory = context -> new NRTCachingDirectory((Directory)this.createDirectory((FDBRecordContext)context), 20000.0, 20000.0);
        IOContext ioContext = new IOContext(new MergeInfo(2, 200L, true, 3));
        try (FDBRecordContext context2 = this.openContext();){
            directory = (Directory)createDirectory.apply(context2);
            this.write(directory, segment, fieldInfos, ioContext);
            if (oneTransaction) {
                this.assertFieldInfosEqual(fieldInfos, this.read(directory, segment, ioContext));
            }
            context2.commit();
        }
        if (!oneTransaction) {
            context2 = this.openContext();
            try {
                directory = (Directory)createDirectory.apply(context2);
                this.assertFieldInfosEqual(fieldInfos, this.read(directory, segment, ioContext));
                context2.commit();
            }
            finally {
                if (context2 != null) {
                    context2.close();
                }
            }
        }
    }

    private Stream<Boolean> trueOrFalse() {
        return Stream.of(true, false);
    }

    private Stream<Map<String, String>> someAttributes() {
        return Stream.of(Map.of(), Map.of("box", "car"), Map.of("run", "far", "walk", "slow"));
    }

    @Nonnull
    private static FieldInfos singleFieldInfos(String name, int number) {
        return new FieldInfos(new FieldInfo[]{LuceneOptimizedFieldInfosFormatTest.simpleFieldInfo(name, number)});
    }

    private void testWithTwoSegments(boolean oneTransaction, FieldInfos fieldInfos1, FieldInfos fieldInfos2, int expectedCount) throws Exception {
        LightSegmentInfo segment1 = new LightSegmentInfo();
        LightSegmentInfo segment2 = new LightSegmentInfo();
        this.sameOrMultiTransaction(oneTransaction, (TestHelpers.DangerousConsumer<FDBDirectory>)((TestHelpers.DangerousConsumer)directory -> {
            this.write((Directory)directory, segment1, fieldInfos1);
            this.write((Directory)directory, segment2, fieldInfos2);
        }), (TestHelpers.DangerousConsumer<FDBDirectory>)((TestHelpers.DangerousConsumer)directory -> {
            this.assertFieldInfosEqual(fieldInfos1, this.read((Directory)directory, segment1));
            this.assertFieldInfosEqual(fieldInfos2, this.read((Directory)directory, segment2));
            Assertions.assertEquals((int)expectedCount, (Integer)((Integer)directory.asyncToSync((StoreTimer.Wait)LuceneEvents.Waits.WAIT_LUCENE_READ_FIELD_INFOS, directory.getFieldInfosCount())));
        }));
    }

    private void sameOrMultiTransaction(boolean oneTransaction, TestHelpers.DangerousConsumer<FDBDirectory> setup, TestHelpers.DangerousConsumer<FDBDirectory> assertions) throws Exception {
        this.sameOrMultiTransaction(oneTransaction ? 1 : 0, List.of(setup, assertions));
    }

    private void sameOrMultiTransaction(int oneTransaction, List<TestHelpers.DangerousConsumer<FDBDirectory>> operations) throws Exception {
        int i;
        FDBDirectory directory;
        try (FDBRecordContext context = this.openContext();){
            directory = this.createDirectory(context);
            for (i = 0; i < oneTransaction; ++i) {
                operations.get(i).accept((Object)directory);
            }
            context.commit();
        }
        context = this.openContext();
        try {
            directory = this.createDirectory(context);
            for (i = oneTransaction; i < operations.size(); ++i) {
                operations.get(i).accept((Object)directory);
            }
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    private FieldInfos read(Directory directory, LightSegmentInfo segment) throws IOException {
        return this.read(directory, segment, IOContext.DEFAULT);
    }

    private FieldInfos read(Directory directory, LightSegmentInfo segment, IOContext ioContext) throws IOException {
        return this.format.read(directory, segment.create(directory), "", ioContext);
    }

    private void write(Directory directory, LightSegmentInfo segment, FieldInfos fieldInfos) throws IOException {
        this.write(directory, segment, fieldInfos, IOContext.DEFAULT);
    }

    private void write(Directory directory, LightSegmentInfo segment, FieldInfos fieldInfos, IOContext ioContext) throws IOException {
        this.format.write(directory, segment.create(directory), "", fieldInfos, ioContext);
    }

    @Nonnull
    private static FieldInfo fieldInfoA(boolean storeTermVector, boolean omitNorms, boolean storePayloads) {
        return new FieldInfo("aField", 1, storeTermVector, omitNorms, storePayloads, IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, DocValuesType.NUMERIC, 1L, Map.of(), 0, 0, 0, false);
    }

    @Nonnull
    private static FieldInfo fieldInfoB(IndexOptions indexOptions, DocValuesType docValuesType, int dvGen, Map<String, String> attributes) {
        return new FieldInfo("aField", 1, false, false, false, indexOptions, docValuesType, (long)dvGen, attributes, 0, 0, 0, false);
    }

    @Nonnull
    private static FieldInfo fieldInfoC(int pointDimensionCount, int pointIndexDimensionCount, int pointNumBytes, boolean softDeletesField) {
        return new FieldInfo("aField", 1, false, false, false, IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, DocValuesType.NUMERIC, 1L, Map.of(), pointDimensionCount, pointIndexDimensionCount, pointNumBytes, softDeletesField);
    }

    @Nonnull
    private static FieldInfo simpleFieldInfo(String name, int number) {
        return LuceneOptimizedFieldInfosFormatTest.fieldInfo(name, number, Map.of());
    }

    @Nonnull
    private static FieldInfo fieldInfo(String name, int number, Map<String, String> attributes) {
        return new FieldInfo(name, number, false, false, false, IndexOptions.DOCS, DocValuesType.NUMERIC, 1L, attributes, 0, 0, 0, false);
    }

    private void assertFieldInfosEqual(FieldInfos expectedFieldInfos, FieldInfos actualFieldInfos) {
        MatcherAssert.assertThat((Object)actualFieldInfos.size(), (Matcher)Matchers.equalTo((Object)expectedFieldInfos.size()));
        Iterator expectedIterator = expectedFieldInfos.iterator();
        Iterator actualIterator = actualFieldInfos.iterator();
        while (expectedIterator.hasNext() && actualIterator.hasNext()) {
            FieldInfo expected = (FieldInfo)expectedIterator.next();
            FieldInfo actual = (FieldInfo)actualIterator.next();
            Assertions.assertEquals((int)expected.number, (int)actual.number);
            Assertions.assertEquals((Object)expected.name, (Object)actual.name);
            Assertions.assertEquals((Object)expected.omitsNorms(), (Object)actual.omitsNorms());
            Assertions.assertEquals((Object)expected.hasVectors(), (Object)actual.hasVectors());
            Assertions.assertEquals((Object)expected.hasPayloads(), (Object)actual.hasPayloads());
            Assertions.assertEquals((Object)expected.getIndexOptions(), (Object)actual.getIndexOptions());
            Assertions.assertEquals((Object)expected.getDocValuesType(), (Object)actual.getDocValuesType());
            Assertions.assertEquals((long)expected.getDocValuesGen(), (long)actual.getDocValuesGen());
            Assertions.assertEquals((int)expected.getPointDimensionCount(), (int)actual.getPointDimensionCount());
            Assertions.assertEquals((int)expected.getPointIndexDimensionCount(), (int)actual.getPointIndexDimensionCount());
            Assertions.assertEquals((int)expected.getPointNumBytes(), (int)actual.getPointNumBytes());
            Assertions.assertEquals((Object)expected.isSoftDeletesField(), (Object)actual.isSoftDeletesField());
            Assertions.assertEquals((Object)expected.attributes(), (Object)actual.attributes());
        }
        Assertions.assertFalse((boolean)expectedIterator.hasNext());
        Assertions.assertFalse((boolean)actualIterator.hasNext());
    }

    private FDBDirectory createDirectory(FDBRecordContext context) {
        return new FDBDirectory(this.path.toSubspace(context), context, Map.of("primaryKeySegmentIndexV2Enabled", "true"));
    }

    private static class LightSegmentInfo {
        private static int segmentCount = 0;
        final String name = "_" + Long.toString(segmentCount++, 36);
        final int maxDoc;
        final byte[] id = StringHelper.randomId();

        public LightSegmentInfo() {
            this.maxDoc = 1;
        }

        public SegmentInfo create(Directory directory) {
            return new SegmentInfo(directory, Version.LATEST, Version.LATEST, this.name, this.maxDoc, false, (Codec)LuceneOptimizedCodec.CODEC, Map.of(), this.id, Map.of(), null);
        }
    }
}

