/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.record.lucene.codec.FDBThreadFilter;
import com.carrotsearch.randomizedtesting.RandomizedContext;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakFilters;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.BaseDocValuesFormatTestCase;
import org.apache.lucene.index.BaseIndexFileFormatTestCase;
import org.apache.lucene.index.BaseIndexFileFormatTestCaseUtils;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestRuleLimitSysouts;
import org.apache.lucene.util.TestUtil;
import org.junit.Ignore;

@ThreadLeakFilters(defaultFilters=true, filters={FDBThreadFilter.class})
@TestRuleLimitSysouts.Limit(bytes=85000L)
public class LuceneOptimizedDocValuesFormatTest
extends BaseDocValuesFormatTestCase {
    protected Codec getCodec() {
        return BaseIndexFileFormatTestCaseUtils.getCodec();
    }

    public void setUp() throws Exception {
        super.setUp();
        BaseIndexFileFormatTestCaseUtils.resetStaticConfigs();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        BaseIndexFileFormatTestCaseUtils.resetStaticConfigs();
    }

    public void testMultiClose() throws IOException {
        BaseIndexFileFormatTestCaseUtils.testMultiClose((BaseIndexFileFormatTestCase)this);
    }

    public void testMissingSortedBytes() throws IOException {
        if (RandomizedContext.current().getRunnerSeedAsString().equals("C185081D42F0F43C")) {
            LuceneOptimizedDocValuesFormatTest.random().nextInt();
        }
        super.testMissingSortedBytes();
    }

    protected void doTestSortedSetVsStoredFields(int numDocs, int minLength, int maxLength, int maxValuesPerDoc, int maxUniqueValues) throws Exception {
        BytesRef scratch;
        long ord;
        int j;
        String[] stringValues;
        SortedSetDocValues docValues;
        LeafReader r;
        BaseDirectoryWrapper dir = BaseIndexFileFormatTestCaseUtils.isUsingFDBDirectory() ? LuceneOptimizedDocValuesFormatTest.newDirectory() : LuceneOptimizedDocValuesFormatTest.newFSDirectory((Path)LuceneOptimizedDocValuesFormatTest.createTempDir((String)"dvduel"));
        IndexWriterConfig conf = LuceneOptimizedDocValuesFormatTest.newIndexWriterConfig((Analyzer)new MockAnalyzer(LuceneOptimizedDocValuesFormatTest.random()));
        RandomIndexWriter writer = new RandomIndexWriter(LuceneOptimizedDocValuesFormatTest.random(), (Directory)dir, conf);
        HashSet<String> valueSet = new HashSet<String>();
        for (int i = 0; i < 10000 && valueSet.size() < maxUniqueValues; ++i) {
            int length = TestUtil.nextInt((Random)LuceneOptimizedDocValuesFormatTest.random(), (int)minLength, (int)maxLength);
            valueSet.add(TestUtil.randomSimpleString((Random)LuceneOptimizedDocValuesFormatTest.random(), (int)length));
        }
        Object[] uniqueValues = valueSet.toArray(new String[0]);
        if (VERBOSE) {
            System.out.println("\nTEST: now add numDocs=" + numDocs);
        }
        for (int i = 0; i < numDocs; ++i) {
            Document doc = new Document();
            StringField idField = new StringField("id", Integer.toString(i), Field.Store.NO);
            doc.add((IndexableField)idField);
            int numValues = TestUtil.nextInt((Random)LuceneOptimizedDocValuesFormatTest.random(), (int)0, (int)maxValuesPerDoc);
            TreeSet<String> values = new TreeSet<String>();
            for (int v2 = 0; v2 < numValues; ++v2) {
                values.add((String)RandomPicks.randomFrom((Random)LuceneOptimizedDocValuesFormatTest.random(), (Object[])uniqueValues));
            }
            for (String string : values) {
                doc.add((IndexableField)new StoredField("stored", string));
            }
            ArrayList unordered = new ArrayList(values);
            Collections.shuffle(unordered, LuceneOptimizedDocValuesFormatTest.random());
            for (String v4 : unordered) {
                doc.add((IndexableField)new SortedSetDocValuesField("dv", LuceneOptimizedDocValuesFormatTest.newBytesRef((String)v4)));
            }
            writer.addDocument((Iterable)doc);
            if (LuceneOptimizedDocValuesFormatTest.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = LuceneOptimizedDocValuesFormatTest.random().nextInt(numDocs / 10);
        if (VERBOSE) {
            System.out.println("\nTEST: now delete " + numDeletions + " docs");
        }
        for (int i = 0; i < numDeletions; ++i) {
            int id = LuceneOptimizedDocValuesFormatTest.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        if (VERBOSE) {
            System.out.println("\nTEST: now get reader");
        }
        DirectoryReader ir = writer.getReader();
        TestUtil.checkReader((IndexReader)ir);
        for (LeafReaderContext context : ir.leaves()) {
            r = context.reader();
            docValues = r.getSortedSetDocValues("dv");
            for (int i = 0; i < r.maxDoc(); ++i) {
                stringValues = r.document(i).getValues("stored");
                if (docValues != null && docValues.docID() < i) {
                    docValues.nextDoc();
                }
                if (docValues == null || stringValues.length <= 0) continue;
                LuceneOptimizedDocValuesFormatTest.assertEquals((long)i, (long)docValues.docID());
                for (j = 0; j < stringValues.length; ++j) {
                    assert (docValues != null);
                    ord = docValues.nextOrd();
                    assert (ord != -1L);
                    scratch = docValues.lookupOrd(ord);
                    LuceneOptimizedDocValuesFormatTest.assertEquals((Object)stringValues[j], (Object)scratch.utf8ToString());
                }
                LuceneOptimizedDocValuesFormatTest.assertEquals((long)-1L, (long)docValues.nextOrd());
            }
        }
        if (VERBOSE) {
            System.out.println("\nTEST: now close reader");
        }
        ir.close();
        if (VERBOSE) {
            System.out.println("TEST: force merge");
        }
        writer.forceMerge(1);
        ir = writer.getReader();
        TestUtil.checkReader((IndexReader)ir);
        for (LeafReaderContext context : ir.leaves()) {
            r = context.reader();
            docValues = r.getSortedSetDocValues("dv");
            for (int i = 0; i < r.maxDoc(); ++i) {
                stringValues = r.document(i).getValues("stored");
                if (docValues.docID() < i) {
                    docValues.nextDoc();
                }
                if (docValues == null || stringValues.length <= 0) continue;
                LuceneOptimizedDocValuesFormatTest.assertEquals((long)i, (long)docValues.docID());
                for (j = 0; j < stringValues.length; ++j) {
                    assert (docValues != null);
                    ord = docValues.nextOrd();
                    assert (ord != -1L);
                    scratch = docValues.lookupOrd(ord);
                    LuceneOptimizedDocValuesFormatTest.assertEquals((Object)stringValues[j], (Object)scratch.utf8ToString());
                }
                LuceneOptimizedDocValuesFormatTest.assertEquals((long)-1L, (long)docValues.nextOrd());
            }
        }
        if (VERBOSE) {
            System.out.println("TEST: close reader");
        }
        ir.close();
        if (VERBOSE) {
            System.out.println("TEST: close writer");
        }
        writer.close();
        if (VERBOSE) {
            System.out.println("TEST: close dir");
        }
        dir.close();
    }

    protected void doTestSortedVsStoredFields(int numDocs, double density, Supplier<byte[]> bytes) throws Exception {
        BytesRef binaryValue;
        int i;
        BinaryDocValues docValues;
        LeafReader r;
        BaseDirectoryWrapper dir = BaseIndexFileFormatTestCaseUtils.isUsingFDBDirectory() ? LuceneOptimizedDocValuesFormatTest.newDirectory() : LuceneOptimizedDocValuesFormatTest.newFSDirectory((Path)LuceneOptimizedDocValuesFormatTest.createTempDir((String)"dvduel"));
        IndexWriterConfig conf = LuceneOptimizedDocValuesFormatTest.newIndexWriterConfig((Analyzer)new MockAnalyzer(LuceneOptimizedDocValuesFormatTest.random()));
        RandomIndexWriter writer = new RandomIndexWriter(LuceneOptimizedDocValuesFormatTest.random(), (Directory)dir, conf);
        Document doc = new Document();
        StringField idField = new StringField("id", "", Field.Store.NO);
        StoredField storedField = new StoredField("stored", new byte[0]);
        SortedDocValuesField dvField = new SortedDocValuesField("dv", LuceneOptimizedDocValuesFormatTest.newBytesRef());
        doc.add((IndexableField)idField);
        doc.add((IndexableField)storedField);
        doc.add((IndexableField)dvField);
        for (int i2 = 0; i2 < numDocs; ++i2) {
            if (LuceneOptimizedDocValuesFormatTest.random().nextDouble() > density) {
                writer.addDocument((Iterable)new Document());
                continue;
            }
            idField.setStringValue(Integer.toString(i2));
            byte[] buffer = bytes.get();
            storedField.setBytesValue(buffer);
            dvField.setBytesValue(buffer);
            writer.addDocument((Iterable)doc);
            if (LuceneOptimizedDocValuesFormatTest.random().nextInt(31) != 0) continue;
            writer.commit();
        }
        int numDeletions = LuceneOptimizedDocValuesFormatTest.random().nextInt(numDocs / 10);
        for (int i3 = 0; i3 < numDeletions; ++i3) {
            int id = LuceneOptimizedDocValuesFormatTest.random().nextInt(numDocs);
            writer.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        DirectoryReader ir = writer.getReader();
        TestUtil.checkReader((IndexReader)ir);
        for (LeafReaderContext context : ir.leaves()) {
            r = context.reader();
            docValues = DocValues.getBinary((LeafReader)r, (String)"dv");
            docValues.nextDoc();
            for (i = 0; i < r.maxDoc(); ++i) {
                binaryValue = r.document(i).getBinaryValue("stored");
                if (binaryValue == null) {
                    LuceneOptimizedDocValuesFormatTest.assertTrue((docValues.docID() > i ? 1 : 0) != 0);
                    continue;
                }
                LuceneOptimizedDocValuesFormatTest.assertEquals((long)i, (long)docValues.docID());
                LuceneOptimizedDocValuesFormatTest.assertEquals((Object)binaryValue, (Object)docValues.binaryValue());
                docValues.nextDoc();
            }
            LuceneOptimizedDocValuesFormatTest.assertEquals((long)Integer.MAX_VALUE, (long)docValues.docID());
        }
        ir.close();
        writer.forceMerge(1);
        ir = writer.getReader();
        TestUtil.checkReader((IndexReader)ir);
        for (LeafReaderContext context : ir.leaves()) {
            r = context.reader();
            docValues = DocValues.getBinary((LeafReader)r, (String)"dv");
            docValues.nextDoc();
            for (i = 0; i < r.maxDoc(); ++i) {
                binaryValue = r.document(i).getBinaryValue("stored");
                if (binaryValue == null) {
                    LuceneOptimizedDocValuesFormatTest.assertTrue((docValues.docID() > i ? 1 : 0) != 0);
                    continue;
                }
                LuceneOptimizedDocValuesFormatTest.assertEquals((long)i, (long)docValues.docID());
                LuceneOptimizedDocValuesFormatTest.assertEquals((Object)binaryValue, (Object)docValues.binaryValue());
                docValues.nextDoc();
            }
            LuceneOptimizedDocValuesFormatTest.assertEquals((long)Integer.MAX_VALUE, (long)docValues.docID());
        }
        ir.close();
        writer.close();
        dir.close();
    }

    @Ignore
    @LuceneTestCase.Nightly
    public void testRamBytesUsed() throws IOException {
        super.testRamBytesUsed();
    }

    @Ignore
    @LuceneTestCase.Nightly
    public void testThreads3() throws Exception {
        super.testThreads3();
    }
}

