/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.record.lucene.codec.FDBThreadFilter;
import com.apple.foundationdb.record.lucene.codec.TestingCodec;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakFilters;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.CompoundDirectory;
import org.apache.lucene.index.BaseCompoundFormatTestCase;
import org.apache.lucene.index.BaseIndexFileFormatTestCase;
import org.apache.lucene.index.BaseIndexFileFormatTestCaseUtils;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.lucene.util.TestRuleLimitSysouts;
import org.junit.Ignore;

@ThreadLeakFilters(defaultFilters=true, filters={FDBThreadFilter.class})
@TestRuleLimitSysouts.Limit(bytes=50000L)
public class LuceneOptimizedCompoundFormatTest
extends BaseCompoundFormatTestCase {
    protected Codec getCodec() {
        return BaseIndexFileFormatTestCaseUtils.getCodec();
    }

    public void setUp() throws Exception {
        super.setUp();
        BaseIndexFileFormatTestCaseUtils.resetStaticConfigs();
        TestingCodec.allowRandomCompoundFiles();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        BaseIndexFileFormatTestCaseUtils.resetStaticConfigs();
    }

    public void testMultiClose() throws IOException {
        BaseIndexFileFormatTestCaseUtils.testMultiClose((BaseIndexFileFormatTestCase)this);
    }

    public void testManySubFiles() throws IOException {
        int fileIdx;
        MockDirectoryWrapper dir = BaseIndexFileFormatTestCaseUtils.isUsingFDBDirectory() ? LuceneOptimizedCompoundFormatTest.newMockDirectory() : LuceneOptimizedCompoundFormatTest.newMockFSDirectory((Path)LuceneOptimizedCompoundFormatTest.createTempDir((String)"CFSManySubFiles"));
        int fileCount = LuceneOptimizedCompoundFormatTest.atLeast((int)500);
        ArrayList<CallSite> files = new ArrayList<CallSite>();
        SegmentInfo si = LuceneOptimizedCompoundFormatTest.newSegmentInfo((Directory)dir, (String)"_123");
        for (int fileIdx2 = 0; fileIdx2 < fileCount; ++fileIdx2) {
            String file = "_123." + fileIdx2;
            files.add((CallSite)((Object)file));
            try (IndexOutput out = dir.createOutput(file, LuceneOptimizedCompoundFormatTest.newIOContext((Random)LuceneOptimizedCompoundFormatTest.random()));){
                CodecUtil.writeIndexHeader((DataOutput)out, (String)"Foo", (int)0, (byte[])si.getId(), (String)"suffix");
                out.writeByte((byte)fileIdx2);
                CodecUtil.writeFooter((IndexOutput)out);
                continue;
            }
        }
        LuceneOptimizedCompoundFormatTest.assertEquals((long)0L, (long)dir.getFileHandleCount());
        si.setFiles(files);
        si.getCodec().compoundFormat().write((Directory)dir, si, IOContext.DEFAULT);
        CompoundDirectory cfs = si.getCodec().compoundFormat().getCompoundReader((Directory)dir, si, IOContext.DEFAULT);
        IndexInput[] ins = new IndexInput[fileCount];
        for (fileIdx = 0; fileIdx < fileCount; ++fileIdx) {
            ins[fileIdx] = cfs.openInput("_123." + fileIdx, LuceneOptimizedCompoundFormatTest.newIOContext((Random)LuceneOptimizedCompoundFormatTest.random()));
            CodecUtil.checkIndexHeader((DataInput)ins[fileIdx], (String)"Foo", (int)0, (int)0, (byte[])si.getId(), (String)"suffix");
        }
        LuceneOptimizedCompoundFormatTest.assertEquals((long)1L, (long)dir.getFileHandleCount());
        for (fileIdx = 0; fileIdx < fileCount; ++fileIdx) {
            LuceneOptimizedCompoundFormatTest.assertEquals((long)((byte)fileIdx), (long)ins[fileIdx].readByte());
        }
        LuceneOptimizedCompoundFormatTest.assertEquals((long)1L, (long)dir.getFileHandleCount());
        for (fileIdx = 0; fileIdx < fileCount; ++fileIdx) {
            ins[fileIdx].close();
        }
        cfs.close();
        dir.close();
    }

    @Ignore(value="Locally this test takes 2 minutes trying to write 500MB to a single file")
    public void testLargeCFS() throws IOException {
        String testfile = "_123.test";
        IOContext context = new IOContext(new FlushInfo(0, 0x20000000L));
        Object dir = BaseIndexFileFormatTestCaseUtils.isUsingFDBDirectory() ? LuceneOptimizedCompoundFormatTest.newDirectory() : new NRTCachingDirectory((Directory)LuceneOptimizedCompoundFormatTest.newFSDirectory((Path)LuceneOptimizedCompoundFormatTest.createTempDir()), 2.0, 25.0);
        SegmentInfo si = LuceneOptimizedCompoundFormatTest.newSegmentInfo((Directory)dir, (String)"_123");
        try (IndexOutput out = dir.createOutput("_123.test", context);){
            CodecUtil.writeIndexHeader((DataOutput)out, (String)"Foo", (int)0, (byte[])si.getId(), (String)"suffix");
            byte[] bytes = new byte[512];
            for (int i = 0; i < 0x100000; ++i) {
                out.writeBytes(bytes, 0, bytes.length);
            }
            CodecUtil.writeFooter((IndexOutput)out);
        }
        si.setFiles(Collections.singleton("_123.test"));
        si.getCodec().compoundFormat().write((Directory)dir, si, context);
        dir.close();
    }
}

