/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataBuilder;
import com.apple.foundationdb.record.TestRecordsJoinIndexProto;
import com.apple.foundationdb.record.lucene.LucenePlanMatchers;
import com.apple.foundationdb.record.lucene.LucenePlanner;
import com.apple.foundationdb.record.lucene.LuceneQueryClause;
import com.apple.foundationdb.record.lucene.LuceneQueryComponent;
import com.apple.foundationdb.record.lucene.LuceneScanTypes;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.JoinedRecordTypeBuilder;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.RecordTypeIndexesBuilder;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreTestBase;
import com.apple.foundationdb.record.query.RecordQuery;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.PlannableIndexTypes;
import com.apple.foundationdb.record.query.plan.match.PlanMatchers;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class LuceneSyntheticPlannerTest
extends FDBRecordStoreTestBase {
    protected void openRecordStore(FDBRecordContext context, FDBRecordStoreTestBase.RecordMetaDataHook hook, boolean attemptWholeFilter) {
        RecordMetaDataBuilder metaDataBuilder = RecordMetaData.newBuilder().setRecords(TestRecordsJoinIndexProto.getDescriptor());
        hook.apply(metaDataBuilder);
        this.recordStore = (FDBRecordStore)this.getStoreBuilder(context, metaDataBuilder.getRecordMetaData()).createOrOpen();
        PlannableIndexTypes indexTypes = new PlannableIndexTypes((Set)Sets.newHashSet((Object[])new String[]{"value", "version"}), (Set)Sets.newHashSet((Object[])new String[]{"rank", "time_window_leaderboard"}), (Set)Sets.newHashSet((Object[])new String[]{"text"}), (Set)Sets.newHashSet((Object[])new String[]{"lucene"}));
        this.planner = new LucenePlanner(this.recordStore.getRecordMetaData(), this.recordStore.getRecordStoreState(), indexTypes, this.recordStore.getTimer());
        this.planner.setConfiguration(this.planner.getConfiguration().asBuilder().setPlanOtherAttemptWholeFilter(attemptWholeFilter).build());
    }

    private static void metadataHook(@Nonnull RecordMetaDataBuilder metaDataBuilder) {
        metaDataBuilder.getRecordType("CustomerWithHeader").setPrimaryKey((KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"___header").nest("z_key"), (KeyExpression)Key.Expressions.field((String)"___header").nest("rec_id"), (KeyExpression[])new KeyExpression[0]));
        metaDataBuilder.getRecordType("OrderWithHeader").setPrimaryKey((KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"___header").nest("z_key"), (KeyExpression)Key.Expressions.field((String)"___header").nest("rec_id"), (KeyExpression[])new KeyExpression[0]));
        JoinedRecordTypeBuilder joined = metaDataBuilder.addJoinedRecordType("luceneJoinedIdx");
        joined.addConstituent("order", "OrderWithHeader");
        joined.addConstituent("cust", "CustomerWithHeader");
        joined.addJoin("order", (KeyExpression)Key.Expressions.field((String)"___header").nest("z_key"), "cust", (KeyExpression)Key.Expressions.field((String)"___header").nest("z_key"));
        joined.addJoin("order", (KeyExpression)Key.Expressions.field((String)"custRef").nest("string_value"), "cust", (KeyExpression)Key.Expressions.field((String)"___header").nest("rec_id"));
        metaDataBuilder.addIndex((RecordTypeIndexesBuilder)joined, new Index("joinNestedConcat", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"cust").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"name"))), (KeyExpression)Key.Expressions.field((String)"order").nest((KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"order_no")), (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"order_desc")), (KeyExpression[])new KeyExpression[0])), (KeyExpression[])new KeyExpression[0]), "lucene"));
        metaDataBuilder.addIndex("OrderWithHeader", "order$custRef", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"___header").nest("z_key"), (KeyExpression)Key.Expressions.field((String)"custRef").nest("string_value"), (KeyExpression[])new KeyExpression[0]));
    }

    @Test
    void canPlanQueryAgainstSyntheticLuceneType() {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, LuceneSyntheticPlannerTest::metadataHook, false);
            String luceneSearch = "order_order_desc: \"twelve pineapple\" and cust_name: \"steve\"";
            LuceneQueryComponent filter = new LuceneQueryComponent(luceneSearch, List.of("order", "cust"));
            RecordQuery query = RecordQuery.newBuilder().setRecordType("luceneJoinedIdx").setFilter((QueryComponent)filter).setRequiredResults(List.of(Key.Expressions.field((String)"order").nest("order_no"))).build();
            RecordQueryPlan plan = this.planner.plan(query);
            Matcher matcher = PlanMatchers.coveringIndexScan((Matcher)PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), (Matcher)PlanMatchers.indexName((String)"joinNestedConcat"), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)luceneSearch))))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
        }
    }

    @Test
    void canPlanQueryAgainstSyntheticLuceneTypeNonCovering() {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, LuceneSyntheticPlannerTest::metadataHook, false);
            String luceneSearch = "order_order_desc: \"twelve pineapple\" and cust_name: \"steve\"";
            LuceneQueryComponent filter = new LuceneQueryComponent(luceneSearch, List.of("order", "cust"));
            RecordQuery query = RecordQuery.newBuilder().setRecordType("luceneJoinedIdx").setFilter((QueryComponent)filter).build();
            RecordQueryPlan plan = this.planner.plan(query);
            Matcher matcher = PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), (Matcher)PlanMatchers.fetchIndexRecords((RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords)RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.SYNTHETIC_CONSTITUENTS), (Matcher)PlanMatchers.indexName((String)"joinNestedConcat"), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)luceneSearch)))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
        }
    }
}

