/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.LuceneIndexTestUtils;
import com.apple.foundationdb.record.lucene.LuceneIndexTestValidator;
import com.apple.foundationdb.record.lucene.LuceneQueryComponent;
import com.apple.foundationdb.record.lucene.LuceneRecordContextProperties;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBQueriedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreTestBase;
import com.apple.foundationdb.record.provider.foundationdb.properties.RecordLayerPropertyStorage;
import com.apple.foundationdb.record.query.RecordQuery;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.QueryPlanner;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.util.pair.Pair;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.index.IndexFileNames;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

@Tag(value="RequiresFDB")
public class LuceneStoredFieldsTest
extends FDBRecordStoreTestBase {
    protected RecordLayerPropertyStorage.Builder addDefaultProps(RecordLayerPropertyStorage.Builder props) {
        return super.addDefaultProps(props).addProp(LuceneRecordContextProperties.LUCENE_INDEX_COMPRESSION_ENABLED, (Object)true);
    }

    @ParameterizedTest
    @EnumSource(value=StoredFieldsType.class)
    void testInsertDocuments(StoredFieldsType type) throws Exception {
        Index index = type.simpleIndex;
        HashSet<String> segments = new HashSet<String>();
        HashSet<Tuple> primaryKeys = new HashSet<Tuple>();
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            primaryKeys.add(this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Document 1", 2)).getPrimaryKey());
            primaryKeys.add(this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1624L, "Document 2", 2)).getPrimaryKey());
            primaryKeys.add(this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "NonDocument 3", 2)).getPrimaryKey());
            context.commit();
        }
        this.getSegments(index, segments, "SimpleDocument");
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            RecordQuery query = this.buildQuery("Document", Collections.emptyList(), "SimpleDocument");
            this.queryAndAssertFields(query, "text", Map.of(1623L, "Document 1", 1624L, "Document 2"));
            try (FDBDirectory directory = new FDBDirectory(this.recordStore.indexSubspace(index), context, index.getOptions());){
                if (type.usesOptimizedStoredFields) {
                    this.assertDocCountPerSegment(directory, List.of("_0"), List.of(Integer.valueOf(3)));
                    Assertions.assertTrue((this.timer.getCounter((StoreTimer.Event)LuceneEvents.Waits.WAIT_LUCENE_GET_STORED_FIELDS).getCount() > 1 ? 1 : 0) != 0);
                    Assertions.assertTrue((this.timer.getCounter((StoreTimer.Event)LuceneEvents.SizeEvents.LUCENE_WRITE_STORED_FIELDS).getCount() >= 3 ? 1 : 0) != 0);
                } else {
                    LuceneStoredFieldsTest.assertTotalDocCountInSegments(0, segments, directory);
                }
            }
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        this.validatePrimaryKeySegmentIndex(index, primaryKeys, "SimpleDocument");
    }

    @ParameterizedTest
    @EnumSource(value=StoredFieldsType.class)
    void testInsertMultipleTransactions(StoredFieldsType type) throws Exception {
        Index index = type.simpleIndex;
        HashSet<String> segments = new HashSet<String>();
        HashSet<Tuple> primaryKeys = new HashSet<Tuple>();
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            primaryKeys.add(this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Document 1", 2)).getPrimaryKey());
            context.commit();
        }
        this.getSegments(index, segments, "SimpleDocument");
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            primaryKeys.add(this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1624L, "Document 2", 2)).getPrimaryKey());
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        this.getSegments(index, segments, "SimpleDocument");
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            primaryKeys.add(this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "NonDocument 3", 2)).getPrimaryKey());
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        this.getSegments(index, segments, "SimpleDocument");
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            RecordQuery query = this.buildQuery("Document", Collections.emptyList(), "SimpleDocument");
            this.queryAndAssertFields(query, "text", Map.of(1623L, "Document 1", 1624L, "Document 2"));
            try (FDBDirectory directory = new FDBDirectory(this.recordStore.indexSubspace(index), context, index.getOptions());){
                if (type.usesOptimizedStoredFields) {
                    this.assertDocCountPerSegment(directory, List.of("_0", "_1", "_2", "_3"), List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(0)));
                    Assertions.assertTrue((this.timer.getCounter((StoreTimer.Event)LuceneEvents.Waits.WAIT_LUCENE_GET_STORED_FIELDS).getCount() > 1 ? 1 : 0) != 0);
                    Assertions.assertTrue((this.timer.getCounter((StoreTimer.Event)LuceneEvents.SizeEvents.LUCENE_WRITE_STORED_FIELDS).getCount() >= 3 ? 1 : 0) != 0);
                } else {
                    LuceneStoredFieldsTest.assertTotalDocCountInSegments(0, segments, directory);
                }
            }
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        this.validatePrimaryKeySegmentIndex(index, primaryKeys, "SimpleDocument");
    }

    @ParameterizedTest
    @EnumSource(value=StoredFieldsType.class)
    void testInsertDeleteDocuments(StoredFieldsType type) throws Exception {
        Index index = type.simpleIndex;
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_MERGE_SEGMENTS_PER_TIER, (Object)2.0).build();
        HashSet<String> segments = new HashSet<String>();
        HashSet<Tuple> primaryKeys = new HashSet<Tuple>();
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Document 1", 2));
            primaryKeys.add(this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1624L, "Document 2", 2)).getPrimaryKey());
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "NonDocument 3", 2));
            context.commit();
        }
        this.getSegments(index, segments, "SimpleDocument");
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            this.recordStore.deleteRecord(Tuple.from((Object[])new Object[]{1623L}));
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        this.getSegments(index, segments, "SimpleDocument");
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            this.recordStore.deleteRecord(Tuple.from((Object[])new Object[]{1547L}));
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        this.getSegments(index, segments, "SimpleDocument");
        context = this.openContext(contextProps);
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            RecordQuery query = this.buildQuery("Document", Collections.emptyList(), "SimpleDocument");
            this.queryAndAssertFields(query, "text", Map.of(1624L, "Document 2"));
            LuceneIndexTestUtils.mergeSegments(this.recordStore, index);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        this.getSegments(index, segments, "SimpleDocument");
        context = this.openContext(contextProps);
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            try (FDBDirectory directory = new FDBDirectory(this.recordStore.indexSubspace(index), context, index.getOptions());){
                if (type.usesOptimizedStoredFields) {
                    LuceneStoredFieldsTest.assertTotalDocCountInSegments(1, segments, directory);
                    Assertions.assertTrue((this.timer.getCounter((StoreTimer.Event)LuceneEvents.Counts.LUCENE_DELETE_STORED_FIELDS).getCount() > 0 ? 1 : 0) != 0);
                } else {
                    LuceneStoredFieldsTest.assertTotalDocCountInSegments(0, segments, directory);
                }
            }
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        this.validatePrimaryKeySegmentIndex(index, primaryKeys, "SimpleDocument");
    }

    @ParameterizedTest
    @EnumSource(value=StoredFieldsType.class)
    void testInsertDeleteDocumentsSameTransaction(StoredFieldsType type) throws Exception {
        Index index = type.simpleIndex;
        HashSet<String> segments = new HashSet<String>();
        HashSet<Tuple> primaryKeys = new HashSet<Tuple>();
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Document 1", 2));
            primaryKeys.add(this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1624L, "Document 2", 2)).getPrimaryKey());
            primaryKeys.add(this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "NonDocument 3", 2)).getPrimaryKey());
            this.recordStore.deleteRecord(Tuple.from((Object[])new Object[]{1623L}));
            context.commit();
        }
        this.getSegments(index, segments, "SimpleDocument");
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            RecordQuery query = this.buildQuery("Document", Collections.emptyList(), "SimpleDocument");
            this.queryAndAssertFields(query, "text", Map.of(1624L, "Document 2"));
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            try (FDBDirectory directory = new FDBDirectory(this.recordStore.indexSubspace(index), context, index.getOptions());){
                if (type.usesOptimizedStoredFields) {
                    LuceneStoredFieldsTest.assertTotalDocCountInSegments(3, segments, directory);
                } else {
                    LuceneStoredFieldsTest.assertTotalDocCountInSegments(0, segments, directory);
                }
            }
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        this.validatePrimaryKeySegmentIndex(index, primaryKeys, "SimpleDocument");
    }

    @ParameterizedTest
    @EnumSource(value=StoredFieldsType.class)
    void testInsertUpdateDocuments(StoredFieldsType type) throws Exception {
        Index index = type.simpleIndex;
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_MERGE_SEGMENTS_PER_TIER, (Object)2.0).build();
        HashSet<String> segments = new HashSet<String>();
        HashSet<Tuple> primaryKeys = new HashSet<Tuple>();
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            primaryKeys.add(this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Document 1", 2)).getPrimaryKey());
            primaryKeys.add(this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1624L, "Document 2", 2)).getPrimaryKey());
            primaryKeys.add(this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "NonDocument 3", 2)).getPrimaryKey());
            context.commit();
        }
        this.getSegments(index, segments, "SimpleDocument");
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            this.recordStore.updateRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Document 3 modified", 2));
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        this.getSegments(index, segments, "SimpleDocument");
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            this.recordStore.updateRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1624L, "Document 4 modified", 2));
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        this.getSegments(index, segments, "SimpleDocument");
        context = this.openContext(contextProps);
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            RecordQuery query = this.buildQuery("Document", Collections.emptyList(), "SimpleDocument");
            this.queryAndAssertFields(query, "text", Map.of(1623L, "Document 3 modified", 1624L, "Document 4 modified"));
            LuceneIndexTestUtils.mergeSegments(this.recordStore, index);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        this.getSegments(index, segments, "SimpleDocument");
        context = this.openContext(contextProps);
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            try (FDBDirectory directory = new FDBDirectory(this.recordStore.indexSubspace(index), context, index.getOptions());){
                if (type.usesOptimizedStoredFields) {
                    LuceneStoredFieldsTest.assertTotalDocCountInSegments(3, segments, directory);
                    Assertions.assertTrue((this.timer.getCounter((StoreTimer.Event)LuceneEvents.Counts.LUCENE_DELETE_STORED_FIELDS).getCount() > 0 ? 1 : 0) != 0);
                } else {
                    LuceneStoredFieldsTest.assertTotalDocCountInSegments(0, segments, directory);
                }
            }
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        this.validatePrimaryKeySegmentIndex(index, primaryKeys, "SimpleDocument");
    }

    @ParameterizedTest
    @EnumSource(value=StoredFieldsType.class)
    void testDeleteAllDocuments(StoredFieldsType type) throws Exception {
        Index index = type.simpleIndex;
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_MERGE_SEGMENTS_PER_TIER, (Object)2.0).build();
        HashSet<String> segments = new HashSet<String>();
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Document 1", 2));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1624L, "Document 2", 2));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "NonDocument 3", 2));
            context.commit();
        }
        this.getSegments(index, segments, "SimpleDocument");
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            this.recordStore.deleteRecord(Tuple.from((Object[])new Object[]{1623L}));
            this.recordStore.deleteRecord(Tuple.from((Object[])new Object[]{1624L}));
            this.recordStore.deleteRecord(Tuple.from((Object[])new Object[]{1547L}));
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        this.getSegments(index, segments, "SimpleDocument");
        context = this.openContext(contextProps);
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            RecordQuery query = this.buildQuery("Document", Collections.emptyList(), "SimpleDocument");
            this.queryAndAssertFields(query, "text", Map.of());
            LuceneIndexTestUtils.mergeSegments(this.recordStore, index);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        this.getSegments(index, segments, "SimpleDocument");
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            try (FDBDirectory directory = new FDBDirectory(this.recordStore.indexSubspace(index), context, index.getOptions());){
                if (type.usesOptimizedStoredFields) {
                    this.assertDocCountPerSegment(directory, List.of("_0", "_1"), List.of(Integer.valueOf(0), Integer.valueOf(0)));
                    Assertions.assertTrue((this.timer.getCounter((StoreTimer.Event)LuceneEvents.Counts.LUCENE_DELETE_STORED_FIELDS).getCount() > 0 ? 1 : 0) != 0);
                } else {
                    LuceneStoredFieldsTest.assertTotalDocCountInSegments(0, segments, directory);
                }
            }
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        this.validatePrimaryKeySegmentIndex(index, Set.of(), "SimpleDocument");
    }

    @ParameterizedTest
    @EnumSource(value=StoredFieldsType.class)
    void testComplexDocManyFields(StoredFieldsType type) throws Exception {
        Index index = type.complexIndex;
        HashSet<String> segments = new HashSet<String>();
        HashSet<Tuple> primaryKeys = new HashSet<Tuple>();
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "ComplexDocument", index);
            primaryKeys.add(this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1623L, "Hello", "Hello 2", 5L, 12, false, 7.123)).getPrimaryKey());
            primaryKeys.add(this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1624L, "Hello record", "Hello record 2", 6L, 13, false, 8.123)).getPrimaryKey());
            primaryKeys.add(this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1625L, "Hello record layer", "Hello record layer 2", 7L, 14, true, 9.123)).getPrimaryKey());
            context.commit();
        }
        this.getSegments(index, segments, "ComplexDocument");
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "ComplexDocument", index);
            RecordQuery query = this.buildQuery("record", Collections.emptyList(), "ComplexDocument");
            this.queryAndAssertFieldsTuple(query, "text", Map.of(Tuple.from((Object[])new Object[]{6, 1624L}), "Hello record", Tuple.from((Object[])new Object[]{7, 1625L}), "Hello record layer"));
            this.queryAndAssertFieldsTuple(query, "text2", Map.of(Tuple.from((Object[])new Object[]{6, 1624L}), "Hello record 2", Tuple.from((Object[])new Object[]{7, 1625L}), "Hello record layer 2"));
            this.queryAndAssertFieldsTuple(query, "score", Map.of(Tuple.from((Object[])new Object[]{6, 1624L}), 13, Tuple.from((Object[])new Object[]{7, 1625L}), 14));
            this.queryAndAssertFieldsTuple(query, "is_seen", Map.of(Tuple.from((Object[])new Object[]{6, 1624L}), false, Tuple.from((Object[])new Object[]{7, 1625L}), true));
            this.queryAndAssertFieldsTuple(query, "time", Map.of(Tuple.from((Object[])new Object[]{6, 1624L}), 8.123, Tuple.from((Object[])new Object[]{7, 1625L}), 9.123));
            try (FDBDirectory directory = new FDBDirectory(this.recordStore.indexSubspace(index), context, index.getOptions());){
                if (type.usesOptimizedStoredFields) {
                    this.assertDocCountPerSegment(directory, List.of("_0"), List.of(Integer.valueOf(3)));
                    Assertions.assertTrue((this.timer.getCounter((StoreTimer.Event)LuceneEvents.Waits.WAIT_LUCENE_GET_STORED_FIELDS).getCount() > 5 ? 1 : 0) != 0);
                    Assertions.assertTrue((this.timer.getCounter((StoreTimer.Event)LuceneEvents.SizeEvents.LUCENE_WRITE_STORED_FIELDS).getCount() >= 3 ? 1 : 0) != 0);
                } else {
                    LuceneStoredFieldsTest.assertTotalDocCountInSegments(0, segments, directory);
                }
            }
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        this.validatePrimaryKeySegmentIndex(index, primaryKeys, "ComplexDocument");
    }

    private RecordQuery buildQuery(String term, List<String> fields, String docType) {
        LuceneQueryComponent filter = new LuceneQueryComponent(term, fields);
        return RecordQuery.newBuilder().setRecordType(docType).setFilter((QueryComponent)filter).build();
    }

    private void queryAndAssertFields(RecordQuery query, String fieldName, Map<Long, ?> expectedValues) throws Exception {
        Map<Tuple, Object> expectedValuesWithTuples = expectedValues.entrySet().stream().collect(Collectors.toMap(entry -> Tuple.from((Object[])new Object[]{entry.getKey()}), entry -> entry.getValue()));
        this.queryAndAssertFieldsTuple(query, fieldName, expectedValuesWithTuples);
    }

    private void queryAndAssertFieldsTuple(RecordQuery query, String fieldName, Map<Tuple, ?> expectedValues) throws Exception {
        RecordQueryPlan plan = this.planner.plan(query);
        try (RecordCursor fdbQueriedRecordRecordCursor = this.recordStore.executeQuery(plan);){
            List result = (List)fdbQueriedRecordRecordCursor.asList().get();
            Map<Tuple, Object> actualValues = result.stream().collect(Collectors.toMap(record -> this.toPrimaryKey((FDBQueriedRecord<Message>)record), record -> this.toFieldValue((FDBQueriedRecord<Message>)record, fieldName)));
            Assertions.assertEquals(expectedValues, actualValues);
        }
    }

    private Object toFieldValue(FDBQueriedRecord<Message> record, String fieldName) {
        Message storedRecord = record.getStoredRecord().getRecord();
        return storedRecord.getField(storedRecord.getDescriptorForType().findFieldByName(fieldName));
    }

    private Tuple toPrimaryKey(FDBQueriedRecord<Message> record) {
        return record.getIndexEntry().getPrimaryKey();
    }

    private void validatePrimaryKeySegmentIndex(Index index, Set<Tuple> primaryKeys, String documentType) throws IOException {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, documentType, index);
            LuceneIndexTestValidator.validatePrimaryKeySegmentIndex(this.recordStore, index, Tuple.from((Object[])new Object[0]), null, primaryKeys, false);
        }
    }

    private void getSegments(Index index, Set<String> segments, String documentType) {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, documentType, index);
            try (FDBDirectory directory = new FDBDirectory(this.recordStore.indexSubspace(index), context, index.getOptions());){
                for (String file : directory.listAll()) {
                    String segmentName = IndexFileNames.parseSegmentName((String)file);
                    if (segmentName.equals(file)) continue;
                    segments.add(segmentName);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void assertTotalDocCountInSegments(int expectedDocumentCount, Set<String> segments, FDBDirectory directory) {
        Map segmentCounts = segments.stream().collect(Collectors.toMap(Function.identity(), segmentName -> ((List)directory.scanStoredFields(segmentName).join()).size()));
        Assertions.assertEquals((int)expectedDocumentCount, (int)segmentCounts.values().stream().mapToInt(entry -> entry).sum(), segmentCounts::toString);
    }

    private void assertDocCountPerSegment(FDBDirectory directory, List<String> expectedSegmentNames, List<Integer> expectedDocsPerSegment) throws Exception {
        for (int i = 0; i < expectedSegmentNames.size(); ++i) {
            List keyValues = (List)directory.scanStoredFields(expectedSegmentNames.get(i)).get();
            Assertions.assertEquals((Integer)expectedDocsPerSegment.get(i), (int)keyValues.size(), (String)expectedSegmentNames.get(i));
        }
    }

    private void rebuildIndexMetaData(FDBRecordContext context, String document, Index index) {
        Pair<FDBRecordStore, QueryPlanner> pair = LuceneIndexTestUtils.rebuildIndexMetaData(context, this.path, document, index, this.isUseCascadesPlanner());
        this.recordStore = (FDBRecordStore)pair.getLeft();
        this.planner = (QueryPlanner)pair.getRight();
        this.recordStore.getIndexDeferredMaintenanceControl().setAutoMergeDuringCommit(false);
    }

    static enum StoredFieldsType {
        Default(false, options -> {
            options.remove("optimizedStoredFieldsFormatEnabled");
            options.remove("primaryKeySegmentIndexV2Enabled");
        }),
        File(false, options -> {
            options.put("optimizedStoredFieldsFormatEnabled", "false");
            options.put("primaryKeySegmentIndexV2Enabled", "false");
        }),
        Optimized(true, options -> {
            options.put("optimizedStoredFieldsFormatEnabled", "true");
            options.put("primaryKeySegmentIndexV2Enabled", "false");
        }),
        PrimaryKeyV2(true, options -> {
            options.remove("optimizedStoredFieldsFormatEnabled");
            options.put("primaryKeySegmentIndexEnabled", "false");
            options.put("primaryKeySegmentIndexV2Enabled", "true");
        });

        private final boolean usesOptimizedStoredFields;
        private final Index simpleIndex;
        private final Index complexIndex;

        private StoredFieldsType(boolean usesOptimizedStoredFields, Consumer<Map<String, String>> optionsBuilder) {
            this.usesOptimizedStoredFields = usesOptimizedStoredFields;
            this.simpleIndex = LuceneIndexTestUtils.simpleTextSuffixesIndex(optionsBuilder);
            this.complexIndex = LuceneIndexTestUtils.textAndStoredComplexIndex(optionsBuilder);
        }
    }
}

