/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.lucene.LuceneQueryClause;
import com.apple.foundationdb.record.lucene.LuceneScanQueryParameters;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanParameters;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIndexPlan;
import javax.annotation.Nonnull;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class LucenePlanMatchers {
    public static Matcher<RecordQueryIndexPlan> scanParams(@Nonnull Matcher<IndexScanParameters> scanMatcher) {
        return new ScanParamsMatcher(scanMatcher);
    }

    public static Matcher<IndexScanParameters> query(@Nonnull Matcher<LuceneQueryClause> queryMatcher) {
        return new QueryMatcher(queryMatcher);
    }

    public static Matcher<IndexScanParameters> group(@Nonnull Matcher<ScanComparisons> boundsMatcher) {
        return new GroupBoundsMatcher(boundsMatcher);
    }

    public static class ScanParamsMatcher
    extends TypeSafeMatcher<RecordQueryIndexPlan> {
        @Nonnull
        private final Matcher<IndexScanParameters> scanMatcher;

        public ScanParamsMatcher(@Nonnull Matcher<IndexScanParameters> scanMatcher) {
            this.scanMatcher = scanMatcher;
        }

        public boolean matchesSafely(@Nonnull RecordQueryIndexPlan plan) {
            return this.scanMatcher.matches((Object)plan.getScanParameters());
        }

        public void describeTo(Description description) {
            description.appendText("scan=(");
            this.scanMatcher.describeTo(description);
            description.appendText(")");
        }
    }

    public static class QueryMatcher
    extends TypeSafeMatcher<IndexScanParameters> {
        @Nonnull
        private final Matcher<LuceneQueryClause> queryMatcher;

        public QueryMatcher(@Nonnull Matcher<LuceneQueryClause> queryMatcher) {
            this.queryMatcher = queryMatcher;
        }

        public boolean matchesSafely(@Nonnull IndexScanParameters scan) {
            return scan instanceof LuceneScanQueryParameters && this.queryMatcher.matches((Object)((LuceneScanQueryParameters)scan).getQuery());
        }

        public void describeTo(Description description) {
            description.appendText("query=(");
            this.queryMatcher.describeTo(description);
            description.appendText(")");
        }
    }

    public static class GroupBoundsMatcher
    extends TypeSafeMatcher<IndexScanParameters> {
        @Nonnull
        private final Matcher<ScanComparisons> boundsMatcher;

        public GroupBoundsMatcher(@Nonnull Matcher<ScanComparisons> boundsMatcher) {
            this.boundsMatcher = boundsMatcher;
        }

        public boolean matchesSafely(@Nonnull IndexScanParameters scan) {
            return scan instanceof LuceneScanQueryParameters && this.boundsMatcher.matches((Object)((LuceneScanQueryParameters)scan).getGroupComparisons());
        }

        public void describeTo(Description description) {
            description.appendText("group=(");
            this.boundsMatcher.describeTo(description);
            description.appendText(")");
        }
    }
}

