/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataBuilder;
import com.apple.foundationdb.record.TestRecordsTextProto;
import com.apple.foundationdb.record.lucene.LuceneIndexOptions;
import com.apple.foundationdb.record.lucene.LuceneIndexValidator;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LuceneIndexValidatorTest {
    @Test
    void testInvalidIndexOptions() {
        ImmutableMap options = ImmutableMap.of((Object)"luceneAnalyzerNamePerField", (Object)" text1 :NGRAM,text2: SYNONYM");
        Assertions.assertDoesNotThrow(() -> this.lambda$testInvalidIndexOptions$0((Map)options), (String)"Whitespaces should be stripped out they are valid option values");
        Map parsedMap = LuceneIndexOptions.parseKeyValuePairOptionValue((String)" text1 :NGRAM,text2:SYNONYM");
        Set parsedSet = LuceneIndexOptions.parseMultipleElementsOptionValue((String)"text2, text3");
        Assertions.assertEquals((Object)parsedMap, Map.of("text1", "NGRAM", "text2", "SYNONYM"));
        Assertions.assertEquals((Object)parsedSet, Set.of("text2", "text3"));
        ImmutableMap options2 = ImmutableMap.of((Object)"luceneAnalyzerNamePerField", (Object)"text:NGRAM,text2:SYNONYM,");
        Assertions.assertThrows(MetaDataException.class, () -> this.lambda$testInvalidIndexOptions$1((Map)options2));
        ImmutableMap options3 = ImmutableMap.of((Object)"luceneAnalyzerNamePerField", (Object)"text:NGRAM,,text2:SYNONYM");
        Assertions.assertThrows(MetaDataException.class, () -> this.lambda$testInvalidIndexOptions$2((Map)options3));
        ImmutableMap options4 = ImmutableMap.of((Object)"luceneAnalyzerNamePerField", (Object)"text:NGRAM,text2");
        Assertions.assertThrows(MetaDataException.class, () -> this.lambda$testInvalidIndexOptions$3((Map)options4));
        ImmutableMap options7 = ImmutableMap.of((Object)"luceneAnalyzerNamePerField", (Object)"text,text2");
        Assertions.assertThrows(MetaDataException.class, () -> this.lambda$testInvalidIndexOptions$4((Map)options7));
    }

    void validateIndexOptions(@Nonnull Map<String, String> indexOptions) {
        Index index = new Index("Complex$text_index", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2")), (KeyExpression[])new KeyExpression[0]), "lucene", indexOptions);
        RecordMetaDataBuilder metadataBuilder = RecordMetaData.newBuilder().setRecords(TestRecordsTextProto.getDescriptor());
        metadataBuilder.getRecordType("ComplexDocument").setPrimaryKey((KeyExpression)Key.Expressions.field((String)"doc_id"));
        metadataBuilder.addIndex("ComplexDocument", index);
        LuceneIndexValidator.validateIndexOptions((Index)index, (RecordMetaData)metadataBuilder.getRecordMetaData());
    }

    private /* synthetic */ void lambda$testInvalidIndexOptions$4(Map options7) throws Throwable {
        this.validateIndexOptions(options7);
    }

    private /* synthetic */ void lambda$testInvalidIndexOptions$3(Map options4) throws Throwable {
        this.validateIndexOptions(options4);
    }

    private /* synthetic */ void lambda$testInvalidIndexOptions$2(Map options3) throws Throwable {
        this.validateIndexOptions(options3);
    }

    private /* synthetic */ void lambda$testInvalidIndexOptions$1(Map options2) throws Throwable {
        this.validateIndexOptions(options2);
    }

    private /* synthetic */ void lambda$testInvalidIndexOptions$0(Map options) throws Throwable {
        this.validateIndexOptions(options);
    }
}

