/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.lucene.LuceneIndexMaintainer;
import com.apple.foundationdb.record.lucene.LuceneIndexTestUtils;
import com.apple.foundationdb.record.lucene.LucenePartitionInfoProto;
import com.apple.foundationdb.record.lucene.LucenePrimaryKeySegmentIndex;
import com.apple.foundationdb.record.lucene.LuceneQueryClause;
import com.apple.foundationdb.record.lucene.LuceneQuerySearchClause;
import com.apple.foundationdb.record.lucene.LuceneQueryType;
import com.apple.foundationdb.record.lucene.LuceneScanBounds;
import com.apple.foundationdb.record.lucene.LuceneScanQuery;
import com.apple.foundationdb.record.lucene.LuceneScanQueryParameters;
import com.apple.foundationdb.record.lucene.directory.FDBDirectoryManager;
import com.apple.foundationdb.record.lucene.search.LuceneOptimizedIndexSearcher;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.base.Verify;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexTestValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneIndexTestValidator.class);
    private final Supplier<FDBRecordContext> contextProvider;
    private final Function<FDBRecordContext, FDBRecordStore> schemaSetup;

    public LuceneIndexTestValidator(Supplier<FDBRecordContext> contextProvider, Function<FDBRecordContext, FDBRecordStore> schemaSetup) {
        this.contextProvider = contextProvider;
        this.schemaSetup = schemaSetup;
    }

    void validate(Index index, Map<Tuple, ? extends Map<Tuple, Tuple>> expectedDocumentInformation, String universalSearch) throws IOException {
        this.validate(index, expectedDocumentInformation, universalSearch, false);
    }

    void validate(Index index, Map<Tuple, ? extends Map<Tuple, Tuple>> expectedDocumentInformation, String universalSearch, boolean allowDuplicatePrimaryKeys) throws IOException {
        int partitionHighWatermark = LuceneIndexTestValidator.getPartitionHighWatermark(index);
        int partitionLowWatermark = LuceneIndexTestValidator.getPartitionLowWatermark(index);
        HashMap<Tuple, Map<Tuple, Tuple>> missingDocuments = new HashMap<Tuple, Map<Tuple, Tuple>>();
        expectedDocumentInformation.forEach((groupingKey, groupedIds) -> missingDocuments.put((Tuple)groupingKey, new HashMap(groupedIds)));
        for (Map.Entry<Tuple, ? extends Map<Tuple, Tuple>> entry2 : expectedDocumentInformation.entrySet()) {
            Tuple groupingKey2 = entry2.getKey();
            LOGGER.debug(KeyValueLogMessage.of((String)"Validating group", (Object[])new Object[]{"group", groupingKey2, "expectedCount", entry2.getValue().size()}));
            List<Tuple> records = entry2.getValue().entrySet().stream().sorted(Map.Entry.comparingByValue().thenComparing(Map.Entry.comparingByKey())).map(Map.Entry::getKey).collect(Collectors.toList());
            if (partitionHighWatermark > 0) {
                this.validatePartitionedGroup(index, universalSearch, allowDuplicatePrimaryKeys, groupingKey2, partitionLowWatermark, partitionHighWatermark, records, missingDocuments);
                continue;
            }
            this.validateUnpartitionedGroup(index, universalSearch, allowDuplicatePrimaryKeys, groupingKey2, partitionLowWatermark, partitionHighWatermark, records, missingDocuments);
        }
        missingDocuments.entrySet().removeIf(entry -> ((Map)entry.getValue()).isEmpty());
        Assertions.assertEquals(Map.of(), missingDocuments, (String)"We should have found all documents in the index");
    }

    private void validateUnpartitionedGroup(Index index, String universalSearch, boolean allowDuplicatePrimaryKeys, Tuple groupingKey, int partitionLowWatermark, int partitionHighWatermark, List<Tuple> records, Map<Tuple, Map<Tuple, Tuple>> missingDocuments) throws IOException {
        try (FDBRecordContext context = this.contextProvider.get();){
            FDBRecordStore recordStore = this.schemaSetup.apply(context);
            LOGGER.debug(KeyValueLogMessage.of((String)"Visiting group", (Object[])new Object[]{"group", groupingKey, "documentsInGroup", records.size()}));
            LuceneIndexTestValidator.validateDocsInPartition(recordStore, index, null, groupingKey, Set.copyOf(records), universalSearch);
            LuceneIndexTestValidator.validatePrimaryKeySegmentIndex(recordStore, index, groupingKey, null, Set.copyOf(records), allowDuplicatePrimaryKeys);
            Set.copyOf(records).forEach(primaryKey -> ((Map)missingDocuments.get(groupingKey)).remove(primaryKey));
        }
    }

    private void validatePartitionedGroup(Index index, String universalSearch, boolean allowDuplicatePrimaryKeys, Tuple groupingKey, int partitionLowWatermark, int partitionHighWatermark, List<Tuple> records, Map<Tuple, Map<Tuple, Tuple>> missingDocuments) throws IOException {
        List<LucenePartitionInfoProto.LucenePartitionInfo> partitionInfos = this.getPartitionMeta(index, groupingKey);
        partitionInfos.sort(Comparator.comparing(info -> Tuple.fromBytes((byte[])info.getFrom().toByteArray())));
        String allCounts = partitionInfos.stream().map(info -> Tuple.fromBytes((byte[])info.getFrom().toByteArray()).toString() + info.getCount()).collect(Collectors.joining(",", "[", "]"));
        HashSet<Integer> usedPartitionIds = new HashSet<Integer>();
        Tuple lastToTuple = null;
        int visitedCount = 0;
        try (FDBRecordContext context = this.contextProvider.get();){
            FDBRecordStore recordStore = this.schemaSetup.apply(context);
            for (int i = 0; i < partitionInfos.size(); ++i) {
                LucenePartitionInfoProto.LucenePartitionInfo partitionInfo = partitionInfos.get(i);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Group: " + String.valueOf(groupingKey) + " PartitionInfo[" + partitionInfo.getId() + "]: count:" + partitionInfo.getCount() + " " + String.valueOf(Tuple.fromBytes((byte[])partitionInfo.getFrom().toByteArray())) + "-> " + String.valueOf(Tuple.fromBytes((byte[])partitionInfo.getTo().toByteArray())));
                }
                Assertions.assertTrue((boolean)this.isParititionCountWithinBounds(partitionInfos, i, partitionLowWatermark, partitionHighWatermark), (String)("Group: " + String.valueOf(groupingKey) + " - " + allCounts + "\nlowWatermark: " + partitionLowWatermark + ", highWatermark: " + partitionHighWatermark + "\nCurrent count: " + partitionInfo.getCount()));
                Assertions.assertTrue((boolean)usedPartitionIds.add(partitionInfo.getId()), () -> "Duplicate id: " + String.valueOf(partitionInfo));
                Tuple fromTuple = Tuple.fromBytes((byte[])partitionInfo.getFrom().toByteArray());
                if (i > 0) {
                    MatcherAssert.assertThat((Object)fromTuple, (Matcher)Matchers.greaterThan(lastToTuple));
                }
                lastToTuple = Tuple.fromBytes((byte[])partitionInfo.getTo().toByteArray());
                MatcherAssert.assertThat((Object)fromTuple, (Matcher)Matchers.lessThanOrEqualTo((Comparable)lastToTuple));
                LOGGER.debug(KeyValueLogMessage.of((String)"Visited partition", (Object[])new Object[]{"group", groupingKey, "documentsSoFar", visitedCount, "documentsInGroup", records.size(), "partitionInfo.count", partitionInfo.getCount()}));
                Set<Tuple> expectedPrimaryKeys = Set.copyOf(records.subList(visitedCount, visitedCount + partitionInfo.getCount()));
                LuceneIndexTestValidator.validateDocsInPartition(recordStore, index, partitionInfo.getId(), groupingKey, expectedPrimaryKeys, universalSearch);
                MatcherAssert.assertThat((Object)records.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(visitedCount += partitionInfo.getCount())));
                LuceneIndexTestValidator.validatePrimaryKeySegmentIndex(recordStore, index, groupingKey, partitionInfo.getId(), expectedPrimaryKeys, allowDuplicatePrimaryKeys);
                expectedPrimaryKeys.forEach(primaryKey -> ((Map)missingDocuments.get(groupingKey)).remove(primaryKey));
            }
        }
    }

    private static int getPartitionLowWatermark(Index index) {
        String partitionLowWaterMarkStr = index.getOption("partitionLowWatermark");
        if (partitionLowWaterMarkStr == null) {
            return Math.max(0, 1);
        }
        return Integer.parseInt(partitionLowWaterMarkStr);
    }

    private static int getPartitionHighWatermark(Index index) {
        String option = index.getOption("partitionHighWatermark");
        if (option == null) {
            return -1;
        }
        return Integer.parseInt(option);
    }

    List<LucenePartitionInfoProto.LucenePartitionInfo> getPartitionMeta(Index index, Tuple groupingKey) {
        try (FDBRecordContext context = this.contextProvider.get();){
            FDBRecordStore recordStore = this.schemaSetup.apply(context);
            LuceneIndexMaintainer indexMaintainer = (LuceneIndexMaintainer)recordStore.getIndexMaintainer(index);
            List list = (List)indexMaintainer.getPartitioner().getAllPartitionMetaInfo(groupingKey).join();
            return list;
        }
    }

    boolean isParititionCountWithinBounds(@Nonnull List<LucenePartitionInfoProto.LucenePartitionInfo> partitionInfos, int currentPartitionIndex, int lowWatermark, int highWatermark) {
        int currentCount = partitionInfos.get(currentPartitionIndex).getCount();
        if (currentCount > highWatermark) {
            return false;
        }
        if (currentCount >= lowWatermark) {
            return true;
        }
        int leftNeighborCapacity = currentPartitionIndex == 0 ? 0 : this.getPartitionExtraCapacity(partitionInfos.get(currentPartitionIndex - 1).getCount(), highWatermark);
        int rightNeighborCapacity = currentPartitionIndex == partitionInfos.size() - 1 ? 0 : this.getPartitionExtraCapacity(partitionInfos.get(currentPartitionIndex + 1).getCount(), highWatermark);
        return currentCount > 0 && leftNeighborCapacity + rightNeighborCapacity < currentCount;
    }

    int getPartitionExtraCapacity(int count, int highWatermark) {
        return Math.max(0, highWatermark - count);
    }

    public static void validateDocsInPartition(FDBRecordStore recordStore, Index index, @Nullable Integer partitionId, Tuple groupingKey, Set<Tuple> expectedPrimaryKeys, String universalSearch) throws IOException {
        LuceneScanQuery scanQuery = groupingKey.isEmpty() ? (LuceneScanQuery)LuceneIndexTestUtils.fullSortTextSearch(recordStore, index, universalSearch, null) : (LuceneScanQuery)LuceneIndexTestValidator.groupedSortedTextSearch(recordStore, index, universalSearch, null, (Object)groupingKey.getLong(0));
        IndexReader indexReader = LuceneIndexTestValidator.getIndexReader(recordStore, index, groupingKey, partitionId);
        LuceneOptimizedIndexSearcher searcher = new LuceneOptimizedIndexSearcher(indexReader);
        TopDocs newTopDocs = searcher.search(scanQuery.getQuery(), Integer.MAX_VALUE);
        Assertions.assertNotNull((Object)newTopDocs);
        Assertions.assertNotNull((Object)newTopDocs.scoreDocs);
        Assertions.assertEquals((int)expectedPrimaryKeys.size(), (int)newTopDocs.scoreDocs.length);
        Set<String> fields = Set.of("_p");
        Assertions.assertEquals(expectedPrimaryKeys.stream().sorted().collect(Collectors.toList()), Arrays.stream(newTopDocs.scoreDocs).map(scoreDoc -> {
            try {
                Document document = searcher.doc(scoreDoc.doc, fields);
                IndexableField primaryKey = document.getField("_p");
                return Tuple.fromBytes((byte[])primaryKey.binaryValue().bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).sorted().collect(Collectors.toList()), () -> String.valueOf(index.getRootExpression()) + " " + String.valueOf(groupingKey) + ":" + partitionId);
    }

    public static IndexReader getIndexReader(FDBRecordStore recordStore, Index index, Tuple groupingKey, @Nullable Integer partitionId) throws IOException {
        FDBDirectoryManager manager = LuceneIndexTestValidator.getDirectoryManager(recordStore, index);
        return manager.getIndexReader(groupingKey, partitionId);
    }

    @Nonnull
    private static FDBDirectoryManager getDirectoryManager(FDBRecordStore recordStore, Index index) {
        IndexMaintainerState state = new IndexMaintainerState(recordStore, index, recordStore.getIndexMaintenanceFilter());
        return FDBDirectoryManager.getManager((IndexMaintainerState)state);
    }

    public static LuceneScanBounds groupedSortedTextSearch(FDBRecordStoreBase<?> recordStore, Index index, String search, Sort sort, Object group) {
        return LuceneIndexTestValidator.groupedSortedTextSearch(recordStore, index, (LuceneQueryClause)new LuceneQuerySearchClause(LuceneQueryType.QUERY, search, false), sort, group);
    }

    public static LuceneScanBounds groupedSortedTextSearch(FDBRecordStoreBase<?> recordStore, Index index, LuceneQueryClause search, Sort sort, Object group) {
        LuceneScanQueryParameters scan = new LuceneScanQueryParameters((ScanComparisons)Verify.verifyNotNull((Object)ScanComparisons.from((Comparisons.Comparison)new Comparisons.SimpleComparison(Comparisons.Type.EQUALS, group))), search, sort, null, null, null);
        return scan.bind(recordStore, index, EvaluationContext.EMPTY);
    }

    public static void validatePrimaryKeySegmentIndex(@Nonnull FDBRecordStore recordStore, @Nonnull Index index, @Nonnull Tuple groupingKey, @Nullable Integer partitionId, @Nonnull Set<Tuple> expectedPrimaryKeys, boolean allowDuplicates) throws IOException {
        FDBDirectoryManager directoryManager = LuceneIndexTestValidator.getDirectoryManager(recordStore, index);
        LucenePrimaryKeySegmentIndex primaryKeySegmentIndex = directoryManager.getDirectory(groupingKey, partitionId).getPrimaryKeySegmentIndex();
        String message = "Group: " + String.valueOf(groupingKey) + ", partition: " + partitionId;
        if (Boolean.parseBoolean(index.getOption("primaryKeySegmentIndexEnabled")) || Boolean.parseBoolean(index.getOption("primaryKeySegmentIndexV2Enabled"))) {
            Assertions.assertNotNull((Object)primaryKeySegmentIndex, (String)message);
            List allEntries = primaryKeySegmentIndex.readAllEntries();
            if (allowDuplicates) {
                Assertions.assertEquals(new HashSet<Tuple>(expectedPrimaryKeys), allEntries.stream().map(entry -> Tuple.fromList(entry.subList(0, entry.size() - 2))).collect(Collectors.toSet()), (String)message);
            } else {
                Assertions.assertEquals(expectedPrimaryKeys.stream().sorted().collect(Collectors.toList()), allEntries.stream().map(entry -> Tuple.fromList(entry.subList(0, entry.size() - 2))).sorted().collect(Collectors.toList()), (String)message);
            }
            directoryManager.getIndexWriter(groupingKey, partitionId);
            DirectoryReader directoryReader = directoryManager.getWriterReader(groupingKey, partitionId);
            for (Tuple primaryKey : expectedPrimaryKeys) {
                Assertions.assertNotNull((Object)primaryKeySegmentIndex.findDocument(directoryReader, primaryKey), (String)(message + " " + String.valueOf(primaryKey) + " " + String.valueOf(primaryKeySegmentIndex.findSegments(primaryKey))));
            }
        } else {
            Assertions.assertNull((Object)primaryKeySegmentIndex, (String)message);
        }
    }
}

