/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.lucene.FDBLuceneTestBase;
import com.apple.foundationdb.record.lucene.LuceneConcurrency;
import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.LuceneIndexTestUtils;
import com.apple.foundationdb.record.lucene.LucenePartitionInfoProto;
import com.apple.foundationdb.record.lucene.LuceneRecordContextProperties;
import com.apple.foundationdb.record.lucene.LuceneScanBounds;
import com.apple.foundationdb.record.lucene.directory.InjectedFailureRepository;
import com.apple.foundationdb.record.lucene.directory.MockedLuceneIndexMaintainerFactory;
import com.apple.foundationdb.record.lucene.directory.TestingIndexMaintainerRegistry;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBExceptions;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerFactory;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanBounds;
import com.apple.foundationdb.record.provider.foundationdb.OnlineIndexer;
import com.apple.foundationdb.record.provider.foundationdb.properties.RecordLayerPropertyStorage;
import com.apple.foundationdb.record.query.plan.QueryPlanner;
import com.apple.foundationdb.record.util.pair.Pair;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.util.LoggableException;
import com.apple.test.BooleanSource;
import com.google.protobuf.Message;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@Tag(value="RequiresFDB")
public class FDBLuceneIndexFailureTest
extends FDBLuceneTestBase {
    private TestingIndexMaintainerRegistry registry;
    private InjectedFailureRepository injectedFailures;

    @BeforeEach
    public void setup() {
        this.registry = new TestingIndexMaintainerRegistry();
        this.injectedFailures = new InjectedFailureRepository();
        this.registry.overrideFactory((IndexMaintainerFactory)new MockedLuceneIndexMaintainerFactory(this.injectedFailures));
    }

    @ParameterizedTest
    @BooleanSource
    void basicGroupedPartitionedTest(boolean useLegacyAsyncToSync) {
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_USE_LEGACY_ASYNC_TO_SYNC, (Object)useLegacyAsyncToSync).build();
        try (FDBRecordContext context = this.openContext(contextProps);){
            this.rebuildIndexMetaData(context, "ComplexDocument", COMPLEX_PARTITIONED);
            LuceneScanBounds scanBounds = this.groupedTextSearch(COMPLEX_PARTITIONED, "text:propose", 2);
            this.injectedFailures.addFailure(InjectedFailureRepository.Methods.LUCENE_GET_FDB_LUCENE_FILE_REFERENCE_ASYNC, (Exception)new FDBExceptions.FDBStoreTransactionIsTooOldException("Blah", new FDBException("Blah", 7)), 0L);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(6666L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 1L, Instant.now().toEpochMilli()));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(7777L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2L, Instant.now().toEpochMilli()));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(8888L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 2L, Instant.now().plus(1L, ChronoUnit.DAYS).toEpochMilli()));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(9999L, "hello world!", 1L, Instant.now().plus(2L, ChronoUnit.DAYS).toEpochMilli()));
            Assertions.assertThrows(FDBExceptions.FDBStoreTransactionIsTooOldException.class, () -> LuceneConcurrency.asyncToSync((StoreTimer.Wait)LuceneEvents.Waits.WAIT_LUCENE_GET_FILE_REFERENCE, (CompletableFuture)this.recordStore.scanIndex(COMPLEX_PARTITIONED, (IndexScanBounds)scanBounds, null, ScanProperties.FORWARD_SCAN).asList(), (FDBRecordContext)context));
            Assertions.assertNull((Object)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY));
        }
    }

    @ParameterizedTest
    @BooleanSource
    void basicNonGroupedPartitionedTest(boolean useLegacyAsyncToSync) {
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_USE_LEGACY_ASYNC_TO_SYNC, (Object)useLegacyAsyncToSync).build();
        try (FDBRecordContext context = this.openContext(contextProps);){
            this.rebuildIndexMetaData(context, "ComplexDocument", COMPLEX_PARTITIONED_NOGROUP);
            LuceneScanBounds scanBounds = this.fullTextSearch(COMPLEX_PARTITIONED_NOGROUP, "text:propose");
            this.injectedFailures.addFailure(InjectedFailureRepository.Methods.LUCENE_GET_FDB_LUCENE_FILE_REFERENCE_ASYNC, (Exception)new LuceneConcurrency.AsyncToSyncTimeoutException("Blah", (Throwable)new TimeoutException("Blah")), 0L);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(6666L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 1L, Instant.now().toEpochMilli()));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(7777L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2L, Instant.now().toEpochMilli()));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(8888L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 2L, Instant.now().plus(1L, ChronoUnit.DAYS).toEpochMilli()));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(9999L, "hello world!", 1L, Instant.now().plus(2L, ChronoUnit.DAYS).toEpochMilli()));
            Assertions.assertThrows(LuceneConcurrency.AsyncToSyncTimeoutException.class, () -> LuceneConcurrency.asyncToSync((StoreTimer.Wait)LuceneEvents.Waits.WAIT_LUCENE_GET_FILE_REFERENCE, (CompletableFuture)this.recordStore.scanIndex(COMPLEX_PARTITIONED_NOGROUP, (IndexScanBounds)scanBounds, null, ScanProperties.FORWARD_SCAN).asList(), (FDBRecordContext)context));
        }
    }

    public static Stream<Arguments> legacySyncAndMapping() {
        return Stream.of(true, false).flatMap(useLegacyAsyncToSync -> Stream.of(true, false).map(useExceptionMapping -> Arguments.of((Object[])new Object[]{useLegacyAsyncToSync, useExceptionMapping})));
    }

    @ParameterizedTest
    @MethodSource(value={"legacySyncAndMapping"})
    void repartitionGroupedTestWithExceptionMapping(boolean useLegacyAsyncToSync, boolean useExceptionMapping) throws IOException {
        Index index = COMPLEX_PARTITIONED;
        Tuple groupingKey = Tuple.from((Object[])new Object[]{1L});
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)6).addProp(LuceneRecordContextProperties.LUCENE_USE_LEGACY_ASYNC_TO_SYNC, (Object)useLegacyAsyncToSync).build();
        this.setupExceptionMapping(useExceptionMapping);
        int totalDocCount = 20;
        Consumer<FDBRecordContext> schemaSetup = context -> this.rebuildIndexMetaData((FDBRecordContext)context, "ComplexDocument", index);
        long docGroupFieldValue = groupingKey.isEmpty() ? 0L : groupingKey.getLong(0);
        try (FDBRecordContext context2 = this.openContext(contextProps);){
            schemaSetup.accept(context2);
            long start = Instant.now().toEpochMilli();
            for (int i = 0; i < 20; ++i) {
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1000L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", docGroupFieldValue, start + (long)(i * 100)));
            }
            this.commit(context2);
        }
        List<LucenePartitionInfoProto.LucenePartitionInfo> partitionInfos = this.getPartitionMeta(index, groupingKey, contextProps, schemaSetup);
        Assertions.assertEquals((int)1, (int)partitionInfos.size());
        Assertions.assertEquals((int)20, (int)partitionInfos.get(0).getCount());
        if (useExceptionMapping) {
            Assertions.assertThrows(UnknownLoggableException.class, () -> this.explicitMergeIndex(index, contextProps, schemaSetup, true, 0));
        } else {
            Assertions.assertThrows(LuceneConcurrency.AsyncToSyncTimeoutException.class, () -> this.explicitMergeIndex(index, contextProps, schemaSetup, true, 0));
        }
        this.explicitMergeIndex(index, contextProps, schemaSetup, false, 0);
        try (FDBRecordContext context3 = this.openContext(contextProps);){
            schemaSetup.accept(context3);
            Assertions.assertEquals((int)2, (int)this.getCounter(context3, (StoreTimer.Event)LuceneEvents.Counts.LUCENE_REPARTITION_CALLS).getCount());
        }
        partitionInfos = this.getPartitionMeta(index, groupingKey, contextProps, schemaSetup);
        Assertions.assertEquals(List.of(Integer.valueOf(6), Integer.valueOf(6), Integer.valueOf(8)), partitionInfos.stream().sorted(Comparator.comparing(partitionInfo -> Tuple.fromBytes((byte[])partitionInfo.getFrom().toByteArray()))).map(LucenePartitionInfoProto.LucenePartitionInfo::getCount).collect(Collectors.toList()));
        Assertions.assertEquals(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(0)), partitionInfos.stream().sorted(Comparator.comparing(partitionInfo -> Tuple.fromBytes((byte[])partitionInfo.getFrom().toByteArray()))).map(LucenePartitionInfoProto.LucenePartitionInfo::getId).collect(Collectors.toList()));
    }

    @Tag(value="Slow")
    @ParameterizedTest
    @BooleanSource
    void repartitionAndMerge(boolean useLegacyAsyncToSync) throws IOException {
        Index index = COMPLEX_PARTITIONED;
        Tuple groupingKey = Tuple.from((Object[])new Object[]{1});
        int mergeSegmentsPerTier = 2;
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)2).addProp(LuceneRecordContextProperties.LUCENE_MERGE_SEGMENTS_PER_TIER, (Object)mergeSegmentsPerTier).addProp(LuceneRecordContextProperties.LUCENE_USE_LEGACY_ASYNC_TO_SYNC, (Object)useLegacyAsyncToSync).build();
        Consumer<FDBRecordContext> schemaSetup = context -> this.rebuildIndexMetaData((FDBRecordContext)context, "ComplexDocument", index);
        long docGroupFieldValue = groupingKey.isEmpty() ? 0L : groupingKey.getLong(0);
        int transactionCount = 100;
        int docsPerTransaction = 2;
        long id = 0L;
        ArrayList<Long> allIds = new ArrayList<Long>();
        for (int i = 0; i < transactionCount; ++i) {
            try (FDBRecordContext context2 = this.openContext(contextProps);){
                schemaSetup.accept(context2);
                this.recordStore.getIndexDeferredMaintenanceControl().setAutoMergeDuringCommit(false);
                long start = Instant.now().toEpochMilli();
                for (int j = 0; j < docsPerTransaction; ++j) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(++id, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", docGroupFieldValue, start + id));
                    allIds.add(id);
                }
                this.commit(context2);
                continue;
            }
        }
        Assertions.assertEquals(Map.of(0, transactionCount), this.getSegmentCounts(index, groupingKey, contextProps, schemaSetup));
        Assertions.assertThrows(LuceneConcurrency.AsyncToSyncTimeoutException.class, () -> this.explicitMergeIndex(index, contextProps, schemaSetup, true, 0));
        Assertions.assertThrows(LuceneConcurrency.AsyncToSyncTimeoutException.class, () -> this.explicitMergeIndex(index, contextProps, schemaSetup, true, 5));
        Assertions.assertThrows(LuceneConcurrency.AsyncToSyncTimeoutException.class, () -> this.explicitMergeIndex(index, contextProps, schemaSetup, true, 10));
        this.timer.reset();
        this.explicitMergeIndex(index, contextProps, schemaSetup, false, 0);
        Map<Integer, Integer> segmentCounts = this.getSegmentCounts(index, groupingKey, contextProps, schemaSetup);
        int partitionSize = 10;
        int partitionCount = allIds.size() / 10;
        MatcherAssert.assertThat(segmentCounts, (Matcher)Matchers.aMapWithSize((int)partitionCount));
        Assertions.assertEquals(IntStream.range(0, partitionCount).boxed().collect(Collectors.toMap(Function.identity(), partitionId -> 2)), segmentCounts);
        try (FDBRecordContext context3 = this.openContext(contextProps);){
            schemaSetup.accept(context3);
            this.validateDocsInPartition(index, 0, groupingKey, allIds.stream().skip(190L).map(idLong -> Tuple.from((Object[])new Object[]{docGroupFieldValue, idLong})).collect(Collectors.toSet()), "text:propose");
            for (int i = 1; i < 20; ++i) {
                this.validateDocsInPartition(index, i, groupingKey, allIds.stream().skip((i - 1) * 10).limit(10L).map(idLong -> Tuple.from((Object[])new Object[]{docGroupFieldValue, idLong})).collect(Collectors.toSet()), "text:propose");
            }
            List<LucenePartitionInfoProto.LucenePartitionInfo> partitionInfos = this.getPartitionMeta(index, groupingKey, contextProps, schemaSetup);
            Assertions.assertEquals((int)partitionCount, (int)partitionInfos.size());
        }
    }

    @ParameterizedTest
    @BooleanSource
    void optimizedPartitionInsertionTest(boolean useLegacyAsyncToSync) throws IOException {
        int i;
        Index index = COMPLEX_PARTITIONED;
        Tuple groupingKey = Tuple.from((Object[])new Object[]{1L});
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)6).addProp(LuceneRecordContextProperties.LUCENE_USE_LEGACY_ASYNC_TO_SYNC, (Object)useLegacyAsyncToSync).build();
        int totalDocCount = 10;
        Consumer<FDBRecordContext> schemaSetup = context -> this.rebuildIndexMetaData((FDBRecordContext)context, "ComplexDocument", index);
        long docGroupFieldValue = groupingKey.isEmpty() ? 0L : groupingKey.getLong(0);
        long start = Instant.now().toEpochMilli();
        try (FDBRecordContext context2 = this.openContext(contextProps);){
            schemaSetup.accept(context2);
            for (i = 0; i < 10; ++i) {
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1000L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", docGroupFieldValue, start + (long)(i * 100)));
            }
            this.commit(context2);
        }
        context2 = this.openContext(contextProps);
        try {
            schemaSetup.accept(context2);
            this.validateDocsInPartition(index, 0, groupingKey, this.makeKeyTuples(docGroupFieldValue, 1000, 1009), "text:propose");
        }
        finally {
            if (context2 != null) {
                context2.close();
            }
        }
        context2 = this.openContext(contextProps);
        try {
            schemaSetup.accept(context2);
            this.injectedFailures.addFailure(InjectedFailureRepository.Methods.LUCENE_GET_PRIMARY_KEY_SEGMENT_INDEX, (Exception)new LuceneConcurrency.AsyncToSyncTimeoutException("Blah", (Throwable)new TimeoutException("Blah")), 0L);
            Assertions.assertThrows(LuceneConcurrency.AsyncToSyncTimeoutException.class, () -> this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1010L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", docGroupFieldValue, start - 1L)));
        }
        finally {
            if (context2 != null) {
                context2.close();
            }
        }
        context2 = this.openContext(contextProps);
        try {
            schemaSetup.accept(context2);
            this.injectedFailures.clear();
            for (i = 0; i < 20; ++i) {
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1010L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", docGroupFieldValue, start - (long)i - 1L));
            }
            this.validateDocsInPartition(index, 1, groupingKey, this.makeKeyTuples(docGroupFieldValue, 1010, 1019), "text:propose");
            this.validateDocsInPartition(index, 2, groupingKey, this.makeKeyTuples(docGroupFieldValue, 1020, 1029), "text:propose");
        }
        finally {
            if (context2 != null) {
                context2.close();
            }
        }
    }

    @ParameterizedTest
    @BooleanSource
    void addDocumentTest(boolean useLegacyAsyncToSync) throws IOException {
        Index index = COMPLEX_PARTITIONED;
        Tuple groupingKey = Tuple.from((Object[])new Object[]{1L});
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_USE_LEGACY_ASYNC_TO_SYNC, (Object)useLegacyAsyncToSync).build();
        Consumer<FDBRecordContext> schemaSetup = context -> this.rebuildIndexMetaData((FDBRecordContext)context, "ComplexDocument", index);
        long docGroupFieldValue = groupingKey.isEmpty() ? 0L : groupingKey.getLong(0);
        try (FDBRecordContext context2 = this.openContext(contextProps);){
            schemaSetup.accept(context2);
            this.injectedFailures.addFailure(InjectedFailureRepository.Methods.LUCENE_GET_PRIMARY_KEY_SEGMENT_INDEX, (Exception)new LuceneConcurrency.AsyncToSyncTimeoutException("Blah", (Throwable)new TimeoutException("Blah")), 0L);
            Assertions.assertThrows(LuceneConcurrency.AsyncToSyncTimeoutException.class, () -> this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1000L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", docGroupFieldValue, 1L)));
        }
    }

    @ParameterizedTest
    @BooleanSource
    void updateDocumentFailedTest(boolean useLegacyAsyncToSync) throws IOException {
        Index index = COMPLEX_PARTITIONED;
        Tuple groupingKey = Tuple.from((Object[])new Object[]{1L});
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_USE_LEGACY_ASYNC_TO_SYNC, (Object)useLegacyAsyncToSync).build();
        Consumer<FDBRecordContext> schemaSetup = context -> this.rebuildIndexMetaData((FDBRecordContext)context, "ComplexDocument", index);
        long docGroupFieldValue = groupingKey.isEmpty() ? 0L : groupingKey.getLong(0);
        try (FDBRecordContext context2 = this.openContext(contextProps);){
            schemaSetup.accept(context2);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1000L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", docGroupFieldValue, 1L));
            context2.commit();
        }
        context2 = this.openContext(contextProps);
        try {
            schemaSetup.accept(context2);
            this.injectedFailures.addFailure(InjectedFailureRepository.Methods.LUCENE_READ_BLOCK, (Exception)new LuceneConcurrency.AsyncToSyncTimeoutException("Blah", (Throwable)new TimeoutException("Blah")), 5L);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1000L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", docGroupFieldValue, 2L));
            Assertions.assertThrows(LuceneConcurrency.AsyncToSyncTimeoutException.class, () -> context2.commit());
        }
        finally {
            if (context2 != null) {
                context2.close();
            }
        }
    }

    @ParameterizedTest
    @BooleanSource
    void addDocumentWithUnknownExceptionTest(boolean useLegacyAsyncToSync) throws IOException {
        Index index = COMPLEX_PARTITIONED;
        Tuple groupingKey = Tuple.from((Object[])new Object[]{1L});
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_USE_LEGACY_ASYNC_TO_SYNC, (Object)useLegacyAsyncToSync).build();
        Consumer<FDBRecordContext> schemaSetup = context -> this.rebuildIndexMetaData((FDBRecordContext)context, "ComplexDocument", index);
        long docGroupFieldValue = groupingKey.isEmpty() ? 0L : groupingKey.getLong(0);
        try (FDBRecordContext context2 = this.openContext(contextProps);){
            schemaSetup.accept(context2);
            this.injectedFailures.addFailure(InjectedFailureRepository.Methods.LUCENE_GET_PRIMARY_KEY_SEGMENT_INDEX, (Exception)((Object)new UnknownRecordCoreException("Blah")), 0L);
            Assertions.assertThrows(UnknownRecordCoreException.class, () -> this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1000L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", docGroupFieldValue, 1L)));
        }
        context2 = this.openContext(contextProps);
        try {
            schemaSetup.accept(context2);
            this.injectedFailures.addFailure(InjectedFailureRepository.Methods.LUCENE_LIST_ALL, new IOException((Throwable)((Object)new UnknownRecordCoreException("Blah"))), 0L);
            Assertions.assertThrows(UnknownRecordCoreException.class, () -> this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1000L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", docGroupFieldValue, 1L)));
        }
        finally {
            if (context2 != null) {
                context2.close();
            }
        }
        context2 = this.openContext(contextProps);
        try {
            schemaSetup.accept(context2);
            this.injectedFailures.addFailure(InjectedFailureRepository.Methods.LUCENE_LIST_ALL, new IOException(new UnknownRuntimeException("Blah")), 0L);
            Assertions.assertThrows(UnknownRuntimeException.class, () -> this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1000L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", docGroupFieldValue, 1L)));
        }
        finally {
            if (context2 != null) {
                context2.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"legacySyncAndMapping"})
    void saveDocumentWithMappedInjectedException(boolean useLegacyAsyncToSync, boolean useExceptionMapping) {
        Index index = COMPLEX_PARTITIONED;
        Tuple groupingKey = Tuple.from((Object[])new Object[]{1L});
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_USE_LEGACY_ASYNC_TO_SYNC, (Object)useLegacyAsyncToSync).build();
        this.setupExceptionMapping(useExceptionMapping);
        Consumer<FDBRecordContext> schemaSetup = context -> this.rebuildIndexMetaData((FDBRecordContext)context, "ComplexDocument", index);
        long docGroupFieldValue = groupingKey.isEmpty() ? 0L : groupingKey.getLong(0);
        try (FDBRecordContext context2 = this.openContext(contextProps);){
            schemaSetup.accept(context2);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1000L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", docGroupFieldValue, 100L));
            this.commit(context2);
        }
        context2 = this.openContext(contextProps);
        try {
            schemaSetup.accept(context2);
            this.injectedFailures.addFailure(InjectedFailureRepository.Methods.LUCENE_GET_ALL_FIELDS_INFO_STREAM, (Exception)new FDBExceptions.FDBStoreTransactionIsTooOldException("Blah", new FDBException("Blah", 7)), 0L);
            if (useExceptionMapping) {
                Assertions.assertThrows(UnknownLoggableException.class, () -> this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1000L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", docGroupFieldValue, 1L)));
            } else {
                Assertions.assertThrows(FDBExceptions.FDBStoreTransactionIsTooOldException.class, () -> LuceneConcurrency.asyncToSync((StoreTimer.Wait)FDBStoreTimer.Waits.WAIT_SAVE_RECORD, (CompletableFuture)this.recordStore.saveRecordAsync((Message)LuceneIndexTestUtils.createComplexDocument(1000L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", docGroupFieldValue, 1L)), (FDBRecordContext)context2));
            }
        }
        finally {
            if (context2 != null) {
                context2.close();
            }
        }
        context2 = this.openContext(contextProps);
        try {
            schemaSetup.accept(context2);
            this.injectedFailures.addFailure(InjectedFailureRepository.Methods.LUCENE_GET_ALL_FIELDS_INFO_STREAM, (Exception)new FDBExceptions.FDBStoreTransactionIsTooOldException("Blah", new FDBException("Blah", 7)), 0L);
            if (useLegacyAsyncToSync && useExceptionMapping) {
                Assertions.assertThrows(UnknownLoggableException.class, () -> LuceneConcurrency.asyncToSync((StoreTimer.Wait)FDBStoreTimer.Waits.WAIT_SAVE_RECORD, (CompletableFuture)this.recordStore.saveRecordAsync((Message)LuceneIndexTestUtils.createComplexDocument(1000L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", docGroupFieldValue, 1L)), (FDBRecordContext)context2));
            } else {
                Assertions.assertThrows(FDBExceptions.FDBStoreTransactionIsTooOldException.class, () -> LuceneConcurrency.asyncToSync((StoreTimer.Wait)FDBStoreTimer.Waits.WAIT_SAVE_RECORD, (CompletableFuture)this.recordStore.saveRecordAsync((Message)LuceneIndexTestUtils.createComplexDocument(1000L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", docGroupFieldValue, 1L)), (FDBRecordContext)context2));
            }
        }
        finally {
            if (context2 != null) {
                context2.close();
            }
        }
    }

    private RuntimeException mapExceptions(Throwable throwable, StoreTimer.Event event) {
        if (throwable instanceof ExecutionException) {
            throwable = throwable.getCause();
        }
        return new UnknownLoggableException(throwable);
    }

    private void rebuildIndexMetaData(FDBRecordContext context, String document, Index index) {
        Pair<FDBRecordStore, QueryPlanner> pair = LuceneIndexTestUtils.rebuildIndexMetaData(context, this.path, document, index, this.isUseCascadesPlanner(), this.registry);
        this.recordStore = (FDBRecordStore)pair.getLeft();
        this.planner = (QueryPlanner)pair.getRight();
        this.recordStore.getIndexDeferredMaintenanceControl().setAutoMergeDuringCommit(true);
    }

    private void setupExceptionMapping(boolean useExceptionMapping) {
        try (FDBRecordContext context = this.openContext();){
            if (useExceptionMapping) {
                context.getDatabase().setAsyncToSyncExceptionMapper(this::mapExceptions);
            } else {
                context.getDatabase().setAsyncToSyncExceptionMapper((ex, ev) -> FDBExceptions.wrapException((Throwable)ex));
            }
        }
    }

    private void explicitMergeIndex(Index index, RecordLayerPropertyStorage contextProps, Consumer<FDBRecordContext> schemaSetup, boolean injectFailure, int failureAtCount) {
        try (FDBRecordContext context = this.openContext(contextProps);){
            schemaSetup.accept(context);
            if (injectFailure) {
                this.injectedFailures.addFailure(InjectedFailureRepository.Methods.LUCENE_GET_FDB_LUCENE_FILE_REFERENCE_ASYNC, (Exception)new LuceneConcurrency.AsyncToSyncTimeoutException("Blah", (Throwable)new TimeoutException("Blah")), failureAtCount);
            } else {
                this.injectedFailures.removeFailure(InjectedFailureRepository.Methods.LUCENE_GET_FDB_LUCENE_FILE_REFERENCE_ASYNC);
            }
            try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(this.recordStore)).setIndex(index).setTimer(this.timer)).build();){
                indexBuilder.mergeIndex();
            }
        }
    }

    private class UnknownLoggableException
    extends LoggableException {
        private static final long serialVersionUID = 0L;

        public UnknownLoggableException(Throwable cause) {
            super(cause);
        }
    }

    private class UnknownRecordCoreException
    extends RecordCoreException {
        private static final long serialVersionUID = 0L;

        public UnknownRecordCoreException(String msg) {
            super(msg, (Throwable)new Exception(msg));
        }
    }

    private class UnknownRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;

        public UnknownRuntimeException(String msg) {
            super(msg);
        }
    }
}

