/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.icu;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.common.text.TextCollator;
import com.apple.foundationdb.record.provider.common.text.TextCollatorRegistry;
import com.apple.foundationdb.record.util.MapUtils;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.protobuf.ByteString;
import com.google.protobuf.ZeroCopyByteString;
import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class TextCollatorRegistryICU
implements TextCollatorRegistry {
    public static final TextCollatorRegistryICU INSTANCE = new TextCollatorRegistryICU();
    private static final String DEFAULT_LOCALE = "";
    private Map<NonnullPair<String, Integer>, TextCollatorICU> collators = new ConcurrentHashMap<NonnullPair<String, Integer>, TextCollatorICU>();

    public static TextCollatorRegistry instance() {
        return INSTANCE;
    }

    private TextCollatorRegistryICU() {
    }

    @Nonnull
    public String getName() {
        return "icu";
    }

    @Nonnull
    public TextCollator getTextCollator(int strength) {
        return this.getTextCollator(DEFAULT_LOCALE, strength);
    }

    @Nonnull
    public TextCollator getTextCollator(@Nonnull String locale, int strength) {
        return (TextCollator)MapUtils.computeIfAbsent(this.collators, (Object)NonnullPair.of((Object)locale, (Object)strength), key -> {
            Collator collator = DEFAULT_LOCALE.equals(locale) ? Collator.getInstance((ULocale)ULocale.forLocale((Locale)Locale.ROOT)) : Collator.getInstance((ULocale)new ULocale(locale));
            collator.setStrength(strength);
            return new TextCollatorICU(collator.freeze());
        });
    }

    protected static class TextCollatorICU
    implements TextCollator {
        @Nonnull
        private final Collator collator;

        protected TextCollatorICU(@Nonnull Collator collator) {
            this.collator = collator;
        }

        public int compare(@Nonnull String str1, @Nonnull String str2) {
            return this.collator.compare(str1, str2);
        }

        @Nonnull
        public ByteString getKey(@Nonnull String str) {
            return ZeroCopyByteString.wrap((byte[])this.collator.getCollationKey(str).toByteArray());
        }
    }
}

