/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.icu;

import com.apple.foundationdb.record.icu.TextCollatorRegistryICU;
import com.apple.foundationdb.record.provider.common.text.TextCollatorTest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class TextCollatorICUTest
extends TextCollatorTest {
    public TextCollatorICUTest() {
        super(TextCollatorRegistryICU.instance());
    }

    @Test
    public void localeType() {
        List<String> names = Arrays.asList("M\u00fcller, A", "Mueller, B", "M\u00fcller, C");
        ArrayList<String> sortNormal = new ArrayList<String>(names);
        sortNormal.sort((Comparator<String>)this.registry.getTextCollator("de_DE"));
        ArrayList<String> sortPhonebook = new ArrayList<String>(names);
        sortPhonebook.sort((Comparator<String>)this.registry.getTextCollator("de_DE@collation=PHONEBOOK"));
        MatcherAssert.assertThat(sortNormal, (Matcher)Matchers.not((Matcher)Matchers.equalTo(names)));
        MatcherAssert.assertThat(sortPhonebook, (Matcher)Matchers.equalTo(names));
    }
}

