/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.icu;

import com.apple.foundationdb.record.provider.foundationdb.query.FDBCollateQueryTest;
import org.junit.jupiter.api.Test;

public class FDBCollateICUQueryTest
extends FDBCollateQueryTest {
    protected static final String[] NUMBERS = new String[]{"1.2.3", "12.0.0", "1.10.0"};

    public FDBCollateICUQueryTest() {
        super("collate_icu");
    }

    @Test
    public void sortNumbersDefault() throws Exception {
        this.sortOnly(null, NUMBERS, new String[]{"1.10.0", "1.2.3", "12.0.0"});
    }

    @Test
    public void sortNumbersLocale() throws Exception {
        this.sortOnly("en", NUMBERS, new String[]{"1.10.0", "1.2.3", "12.0.0"});
    }

    @Test
    public void sortNumbersNumeric() throws Exception {
        this.sortOnly("en@colNumeric=yes", NUMBERS, new String[]{"1.2.3", "1.10.0", "12.0.0"});
    }

    @Test
    public void sortNumbersNonNumeric() throws Exception {
        this.sortOnly("en@colNumeric=no", NUMBERS, new String[]{"1.10.0", "1.2.3", "12.0.0"});
    }
}

