/*
 * Copyright (C) 2007 ETH Zurich
 *
 * This file is part of Fosstrak (www.fosstrak.org).
 *
 * Fosstrak is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1, as published by the Free Software Foundation.
 *
 * Fosstrak is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Fosstrak; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

package org.fosstrak.hal;

/**
 * This exception is thrown if the called method is not supported by the current
 * hardware abstraction implementation.
 */
public class UnsupportedOperationException extends HardwareException {
	
	private static final long serialVersionUID = 1L;

	/**
	 * Constructor.
	 */
	public UnsupportedOperationException() {
		super();
	}

	/**
	 * Constructor specifying a message.
	 * 
	 * @param message
	 *            The message
	 */
	public UnsupportedOperationException(String message) {
		super(message);
	}

	/**
	 * Constructor using a cause.
	 * 
	 * @param cause
	 *            The cause
	 */
	public UnsupportedOperationException(Throwable cause) {
		super(cause);
	}
	
	/**
	 * Constructor specifying a message and a cause.
	 * 
	 * @param message
	 *            The message
	 * @param cause
	 *            The cause
	 */
	public UnsupportedOperationException(String message, Throwable cause) {
		super(message, cause);
	}

}
