/*
 * Decompiled with CFR 0.152.
 */
package org.fosstrak.hal.util;

import java.io.File;
import java.net.URI;
import java.net.URL;
import org.apache.log4j.Logger;

public final class ResourceLocator {
    private static Logger log = Logger.getLogger(ResourceLocator.class);
    private static final String DEFAULT_SUFFIX = "_default";

    public static URL getURL(String resourceFileName, String defaultResourceFileName, Class caller) {
        if (resourceFileName == null && defaultResourceFileName != null) {
            resourceFileName = defaultResourceFileName;
        }
        if (!resourceFileName.startsWith("/")) {
            resourceFileName = "/" + resourceFileName;
        }
        if (defaultResourceFileName == null) {
            defaultResourceFileName = resourceFileName.substring(0, resourceFileName.lastIndexOf(".")) + DEFAULT_SUFFIX + resourceFileName.substring(resourceFileName.lastIndexOf("."));
        }
        URL url = null;
        ClassLoader loader = ResourceLocator.getBestClassLoader(caller);
        if (url == null) {
            try {
                String userdirectorypath = "file:/" + System.getProperty("user.dir").replace(System.getProperty("file.separator").charAt(0), '/') + resourceFileName;
                url = ResourceLocator.locateAbsolute(userdirectorypath);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (url == null) {
            url = ResourceLocator.locate(resourceFileName, loader, caller);
        }
        if (url == null) {
            url = ResourceLocator.locateAbsolute("file:/" + resourceFileName.replace(System.getProperty("file.separator").charAt(0), '/'));
        }
        if (url == null) {
            url = ResourceLocator.locateAbsolute("file:/" + resourceFileName.substring(1).replace(System.getProperty("file.separator").charAt(0), '/'));
        }
        if (url == null) {
            url = ResourceLocator.locateDefault(defaultResourceFileName, resourceFileName, caller);
        }
        if (url == null) {
            url = ResourceLocator.locate(defaultResourceFileName, loader, caller);
        }
        if (url != null) {
            log.debug((Object)("Resource URL is: " + url.toString()));
        } else {
            log.debug((Object)("Resource '" + resourceFileName + "' and '" + defaultResourceFileName + "' not found."));
        }
        return url;
    }

    private static ClassLoader getBestClassLoader(Class caller) {
        ClassLoader callerLoader = caller.getClassLoader();
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
        ClassLoader loader = ResourceLocator.isChild(contextLoader, callerLoader) ? callerLoader : (ResourceLocator.isChild(callerLoader, contextLoader) ? contextLoader : contextLoader);
        if (loader != systemLoader && ResourceLocator.isChild(loader, systemLoader)) {
            loader = systemLoader;
        }
        return loader;
    }

    private static boolean isChild(ClassLoader parent, ClassLoader child) {
        if (parent == child) {
            return true;
        }
        if (child == null) {
            return false;
        }
        if (parent == null) {
            return true;
        }
        while (child != null) {
            if (child == parent) {
                return true;
            }
            child = child.getParent();
        }
        return false;
    }

    private static URL locate(String resourceFileName, ClassLoader loader, Class caller) {
        if (!resourceFileName.startsWith("/")) {
            resourceFileName = "/" + resourceFileName;
        }
        String shortResourceFileName = resourceFileName.substring(1, resourceFileName.length());
        URL url = null;
        if (loader != null) {
            url = loader.getResource(shortResourceFileName);
        }
        if (url == null && caller != null) {
            url = caller.getResource(resourceFileName);
        }
        if (url == null && caller != null) {
            url = caller.getResource(shortResourceFileName);
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(shortResourceFileName);
        }
        return url;
    }

    private static URL locateAbsolute(String resourceFile) {
        boolean exists;
        URL url = null;
        try {
            exists = new File(new URI(resourceFile)).exists();
        }
        catch (Exception e) {
            exists = false;
        }
        if (exists) {
            try {
                url = new URL(resourceFile);
            }
            catch (Exception e) {
                url = null;
            }
        }
        return url;
    }

    private static URL locateDefault(String defaultResourceFileName, String resourceFileName, Class caller) {
        if (!defaultResourceFileName.startsWith("/")) {
            defaultResourceFileName = "/" + defaultResourceFileName;
        }
        if (!resourceFileName.startsWith("/")) {
            resourceFileName = "/" + resourceFileName;
        }
        URL url = null;
        String codesourcelocation = caller.getProtectionDomain().getCodeSource().getLocation().toString();
        if (codesourcelocation.endsWith("jar")) {
            String urlstring = codesourcelocation.substring(0, codesourcelocation.lastIndexOf("/")) + resourceFileName;
            url = ResourceLocator.locateAbsolute(urlstring);
            if (url == null) {
                urlstring = codesourcelocation.substring(0, codesourcelocation.lastIndexOf("/")) + defaultResourceFileName;
                url = ResourceLocator.locateAbsolute(urlstring);
            }
            if (url == null) {
                boolean exists;
                urlstring = "jar:" + codesourcelocation + "!" + defaultResourceFileName;
                try {
                    exists = new File(new URI(urlstring)).exists();
                }
                catch (Exception e) {
                    exists = false;
                }
                if (exists) {
                    try {
                        url = new URL(urlstring);
                    }
                    catch (Exception e) {
                        url = null;
                    }
                }
            }
        } else {
            String urlstring = codesourcelocation.substring(0, codesourcelocation.lastIndexOf("/")) + resourceFileName;
            url = ResourceLocator.locateAbsolute(urlstring);
            if (url == null) {
                urlstring = codesourcelocation.substring(0, codesourcelocation.lastIndexOf("/")) + defaultResourceFileName;
                url = ResourceLocator.locateAbsolute(urlstring);
            }
        }
        return url;
    }
}

