/*
 * Decompiled with CFR 0.152.
 */
package org.fosstrak.hal.transponder;

import org.fosstrak.hal.util.ByteBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TransponderType {
    ICode1(0, 10),
    TagItHF(1, 10),
    ISO15693(3, 10),
    ICodeEPC(6, 13),
    ICodeUID(7, 20),
    ISO18000_6A(128, 0),
    ISO18000_6B(129, 0),
    EM4222(131, 0),
    EPCclass1Gen2(132, 0),
    EPCclass0Gen1(136, 0),
    EPCclass1Gen1(137, 0),
    UNKNOWN(255, 10);

    private final int code;
    private final int dataSize;

    private TransponderType(int code, int dataSize) {
        this.code = code;
        this.dataSize = dataSize;
    }

    public int code() {
        return this.code;
    }

    public int dataSize() {
        return this.dataSize;
    }

    public static TransponderType getType(byte trType) {
        int typeno = ByteBlock.byteToNumber(trType) & 0xFF;
        for (TransponderType t : TransponderType.values()) {
            if (t.code != typeno) continue;
            return t;
        }
        return UNKNOWN;
    }

    public static TransponderType getType(String trTypeName) {
        for (TransponderType t : TransponderType.values()) {
            if (!((Object)((Object)t)).getClass().getName().equalsIgnoreCase(trTypeName)) continue;
            return t;
        }
        return UNKNOWN;
    }
}

