/*
 * Decompiled with CFR 0.152.
 */
package org.fosstrak.hal.transponder;

import org.fosstrak.hal.util.ByteBlock;

public class TransponderSystemInformationISO {
    private boolean isSupported = false;
    private byte dsfid = 0;
    private String uid = "";
    private byte afi = 0;
    private int memSize = 0;
    private byte icReference = 0;

    public TransponderSystemInformationISO() {
        this.isSupported = false;
    }

    public TransponderSystemInformationISO(byte[] data) {
        if (data.length != 13) {
            throw new IllegalArgumentException("Data has unexpected size");
        }
        this.dsfid = data[0];
        this.uid = ByteBlock.byteArrayToHexString(this.copyOfRange(data, 1, 9));
        this.afi = data[9];
        this.memSize = ByteBlock.bytesToNumber(this.copyOfRange(data, 10, 12));
        this.icReference = data[12];
        this.isSupported = true;
    }

    private byte[] copyOfRange(byte[] data, int from, int to) {
        if (to < from) {
            return null;
        }
        byte[] res = new byte[to - from];
        for (int i = 0; i < res.length; ++i) {
            res[i] = from + i < data.length ? data[from + i] : (byte)0;
        }
        return res;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DSFID: 0x");
        sb.append(Integer.toHexString(this.dsfid));
        sb.append("/n");
        sb.append("UID: ");
        sb.append(this.uid);
        sb.append("/n");
        sb.append("AFI: ");
        sb.append(Integer.toHexString(this.dsfid));
        sb.append("/n");
        sb.append("Memory size: ");
        sb.append(String.valueOf(this.memSize));
        sb.append("/n");
        return sb.toString();
    }

    public byte getAFI() {
        return this.afi;
    }

    public byte getDSFID() {
        return this.dsfid;
    }

    public byte getICreference() {
        return this.icReference;
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    public int getMemSize() {
        return this.memSize;
    }

    public String getUID() {
        return this.uid;
    }
}

