/*
 * Decompiled with CFR 0.152.
 */
package org.fosstrak.hal.transponder;

import org.fosstrak.hal.util.ByteBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RFTechnology {
    HF(0),
    UHF(2),
    UNKNOWN(3);

    private final int trType;

    private RFTechnology(int code) {
        this.trType = code;
    }

    public int code() {
        return this.trType;
    }

    public static RFTechnology getType(byte trType) {
        int rfTec = (ByteBlock.byteToNumber(trType) & 0xC0) >> 6;
        for (RFTechnology t : RFTechnology.values()) {
            if (rfTec != t.code()) continue;
            return t;
        }
        return UNKNOWN;
    }
}

