/*
 * Decompiled with CFR 0.152.
 */
package org.fosstrak.hal.transponder;

import java.net.URL;
import java.util.HashMap;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.fosstrak.hal.util.ResourceLocator;

public class IDType {
    private static String defaultConfigFile = "/props/IDTypes_default.xml";
    private static XMLConfiguration config = null;
    private static HashMap<String, String> type2key;
    private String idType;
    private String description;

    private IDType(String idType, String description) {
        this.idType = idType;
        this.description = description;
    }

    public String getIdType() {
        return this.idType;
    }

    public String getDescription() {
        return this.description;
    }

    public static IDType getIdType(String type, String configFile) {
        if (configFile == null) {
            configFile = defaultConfigFile;
        }
        if (config == null && !IDType.initialize(configFile)) {
            config = null;
            return new IDType("Unknown", "Unknown");
        }
        if (!type2key.containsKey(type.toLowerCase())) {
            type = "Unknown";
        }
        String key = type2key.get(type.toLowerCase());
        String idType = config.getString(key + "idType");
        String description = config.getString(key + "description");
        IDType t = new IDType(idType, description);
        return t;
    }

    private static boolean initialize(String configFile) {
        try {
            config = new XMLConfiguration();
            type2key = new HashMap();
            Exception ex = new Exception();
            StackTraceElement[] sTrace = ex.getStackTrace();
            String className = sTrace[0].getClassName();
            Class<?> c = Class.forName(className);
            URL fileurl = ResourceLocator.getURL(configFile, defaultConfigFile, c);
            config.load(fileurl);
            int types = config.getMaxIndex("type") + 1;
            for (int i = 0; i < types; ++i) {
                String typekey = "type(" + i + ").";
                String idType = config.getString(typekey + "idType");
                type2key.put(idType.toLowerCase(), typekey);
            }
        }
        catch (ConfigurationException ce) {
            return false;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        return true;
    }
}

