/*
 * Decompiled with CFR 0.152.
 */
package org.fosstrak.hal.transponder;

import java.net.URL;
import java.util.HashMap;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.fosstrak.hal.transponder.TransponderType;
import org.fosstrak.hal.util.ByteBlock;
import org.fosstrak.hal.util.ResourceLocator;

public class EPCTransponderModel {
    private static String defaultConfigFile = "/props/EPCTransponderModels_default.xml";
    private static XMLConfiguration config = null;
    private static HashMap<String, String> tid2key;
    private String tid;
    private TransponderType type;
    private String manufacturer;
    private String modelName;
    private int reservedSize;
    private boolean reservedRead;
    private boolean reservedWrite;
    private int epcSize;
    private boolean epcRead;
    private boolean epcWrite;
    private int tidSize;
    private boolean tidRead;
    private boolean tidWrite;
    private int userSize;
    private boolean userRead;
    private boolean userWrite;

    private EPCTransponderModel(TransponderType type, String manufacturer, String modelName, int reservedSize, boolean reservedRead, boolean reservedWrite, int epcSize, boolean epcRead, boolean epcWrite, int tidSize, boolean tidRead, boolean tidWrite, int userSize, boolean userRead, boolean userWrite) {
        this.type = type;
        this.manufacturer = manufacturer;
        this.modelName = modelName;
        this.reservedSize = reservedSize;
        this.reservedRead = reservedRead;
        this.reservedWrite = reservedWrite;
        this.epcSize = epcSize;
        this.epcRead = epcRead;
        this.epcWrite = epcWrite;
        this.tidSize = tidSize;
        this.tidRead = tidRead;
        this.tidWrite = tidWrite;
        this.userSize = userSize;
        this.userRead = userRead;
        this.userWrite = userWrite;
    }

    private void setTID(String tid) {
        this.tid = tid;
    }

    public String getTID() {
        return this.tid;
    }

    public TransponderType getType() {
        return this.type;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getModelName() {
        return this.modelName;
    }

    public int getReservedSize() {
        return this.reservedSize;
    }

    public boolean getReservedReadable() {
        return this.reservedRead;
    }

    public boolean getReservedWriteable() {
        return this.reservedWrite;
    }

    public int getEpcSize() {
        return this.epcSize;
    }

    public boolean getEpcReadable() {
        return this.epcRead;
    }

    public boolean getEpcWriteable() {
        return this.epcWrite;
    }

    public int getTidSize() {
        return this.tidSize;
    }

    public boolean getTidReadable() {
        return this.tidRead;
    }

    public boolean getTidWriteable() {
        return this.tidWrite;
    }

    public int getUserSize() {
        return this.userSize;
    }

    public boolean getUserReadable() {
        return this.userRead;
    }

    public boolean getUserWriteable() {
        return this.userWrite;
    }

    public static EPCTransponderModel getEpcTrasponderModel(byte[] tid, String configFile) {
        if (config == null && !EPCTransponderModel.initialize(configFile)) {
            config = null;
            return new EPCTransponderModel(TransponderType.EPCclass1Gen2, "Unknown", "Unknown", 8, false, false, 16, true, false, 4, true, false, 0, false, false);
        }
        String hextid = ByteBlock.byteArrayToHexString(tid);
        if (!tid2key.containsKey(hextid)) {
            hextid = "E2000000";
        }
        String key = tid2key.get(hextid);
        String typename = config.getString(key + "type");
        TransponderType type = TransponderType.getType(typename);
        String manufacturer = config.getString(key + "manufacturer");
        String modelName = config.getString(key + "modelName");
        int reservedSize = config.getInt(key + "reservedSize");
        boolean reservedRead = config.getBoolean(key + "reservedRead");
        boolean reservedWrite = config.getBoolean(key + "reservedWrite");
        int epcSize = config.getInt(key + "epcSize");
        boolean epcRead = config.getBoolean(key + "epcRead");
        boolean epcWrite = config.getBoolean(key + "epcWrite");
        int tidSize = config.getInt(key + "tidSize");
        boolean tidRead = config.getBoolean(key + "tidRead");
        boolean tidWrite = config.getBoolean(key + "tidWrite");
        int userSize = config.getInt(key + "userSize");
        boolean userRead = config.getBoolean(key + "userRead");
        boolean userWrite = config.getBoolean(key + "userWrite");
        EPCTransponderModel model = new EPCTransponderModel(type, manufacturer, modelName, reservedSize, reservedRead, reservedWrite, epcSize, epcRead, epcWrite, tidSize, tidRead, tidWrite, userSize, userRead, userWrite);
        model.setTID(hextid);
        return model;
    }

    private static boolean initialize(String configFile) {
        try {
            config = new XMLConfiguration();
            tid2key = new HashMap();
            Exception ex = new Exception();
            StackTraceElement[] sTrace = ex.getStackTrace();
            String className = sTrace[0].getClassName();
            Class<?> c = Class.forName(className);
            URL fileurl = ResourceLocator.getURL(configFile, defaultConfigFile, c);
            config.load(fileurl);
            HashMap<String, String> name2CiMdi = new HashMap<String, String>();
            int manufacturers = config.getMaxIndex("manufacturer") + 1;
            for (int i = 0; i < manufacturers; ++i) {
                String mankey = "manufacturer(" + i + ").";
                String manname = config.getString(mankey + "name");
                String manci = config.getString(mankey + "classIdentifier");
                String manmdi = config.getString(mankey + "maskDesignerIdentifier");
                String mancimdi = manci.substring(2) + manmdi.substring(2);
                name2CiMdi.put(manname, mancimdi);
            }
            int tags = config.getMaxIndex("tag") + 1;
            for (int i = 0; i < tags; ++i) {
                String tagkey = "tag(" + i + ").";
                String tagmanufacturer = config.getString(tagkey + "manufacturer");
                String cimdi = (String)name2CiMdi.get(tagmanufacturer);
                int tagmodels = config.getMaxIndex(tagkey + "modelID") + 1;
                for (int j = 0; j < tagmodels; ++j) {
                    String tagmodelid = config.getString(tagkey + "modelID(" + j + ")").substring(2);
                    String tagtid = cimdi + tagmodelid;
                    tid2key.put(tagtid, tagkey);
                }
            }
        }
        catch (ConfigurationException ce) {
            return false;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        return true;
    }
}

