/*
 * Decompiled with CFR 0.152.
 */
package org.fosstrak.hal;

import org.fosstrak.hal.AsynchronousIdentifyListener;
import org.fosstrak.hal.HardwareException;
import org.fosstrak.hal.Observation;
import org.fosstrak.hal.OutOfBoundsException;
import org.fosstrak.hal.ReadPointNotFoundException;
import org.fosstrak.hal.Trigger;
import org.fosstrak.hal.UnsignedByteArray;
import org.fosstrak.hal.UnsupportedOperationException;

public interface HardwareAbstraction {
    public Observation[] identify(String[] var1) throws ReadPointNotFoundException, HardwareException;

    public void startAsynchronousIdentify(String[] var1, Trigger var2) throws ReadPointNotFoundException, HardwareException, UnsupportedOperationException;

    public void stopAsynchronousIdentify() throws HardwareException, UnsupportedOperationException;

    public boolean isAsynchronousIdentifyRunning() throws HardwareException, UnsupportedOperationException;

    public void addAsynchronousIdentifyListener(AsynchronousIdentifyListener var1) throws HardwareException, UnsupportedOperationException;

    public void removeAsynchronousIdentifyListener(AsynchronousIdentifyListener var1) throws HardwareException, UnsupportedOperationException;

    public boolean supportsAsynchronousIdentify();

    public UnsignedByteArray readBytes(String var1, String var2, int var3, int var4, int var5, String[] var6) throws ReadPointNotFoundException, OutOfBoundsException, HardwareException, UnsupportedOperationException;

    public boolean supportsReadBytes();

    public void writeBytes(String var1, String var2, int var3, int var4, UnsignedByteArray var5, String[] var6) throws ReadPointNotFoundException, OutOfBoundsException, HardwareException, UnsupportedOperationException;

    public boolean supportsWriteBytes();

    public void kill(String var1, String var2, String[] var3) throws ReadPointNotFoundException, HardwareException, UnsupportedOperationException;

    public boolean supportsKill();

    public void writeId(String var1, String var2, String[] var3) throws ReadPointNotFoundException, HardwareException, UnsupportedOperationException;

    public boolean supportsWriteId();

    public String getHALName();

    public String[] getReadPointNames();

    public String[] getAllParameterNames() throws HardwareException, UnsupportedOperationException;

    public String getParameter(String var1) throws HardwareException, UnsupportedOperationException;

    public void setParameter(String var1, String var2) throws HardwareException, UnsupportedOperationException;

    public boolean supportsParameters();

    public void reset() throws HardwareException;

    public boolean supportsReset();

    public int getReadPointPowerLevel(String var1, boolean var2) throws ReadPointNotFoundException, HardwareException, UnsupportedOperationException;

    public boolean supportsGetReadPointPowerLevel();

    public int getReadPointNoiseLevel(String var1, boolean var2) throws ReadPointNotFoundException, HardwareException, UnsupportedOperationException;

    public boolean supportsGetReadPointNoiseLevel();

    public void startUpReadPoint(String var1) throws ReadPointNotFoundException, HardwareException, UnsupportedOperationException;

    public boolean supportsStartUpReadPoint();

    public void shutDownReadPoint(String var1) throws ReadPointNotFoundException, HardwareException, UnsupportedOperationException;

    public boolean supportsShutDownReadPoint();

    public boolean isReadPointReady(String var1) throws ReadPointNotFoundException, HardwareException, UnsupportedOperationException;

    public boolean supportsIsReadPointReady();
}

