/*
 * Decompiled with CFR 0.152.
 */
package org.fosstrak.hal;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fosstrak.hal.util.ResourceLocator;

public class ControllerProperties {
    private static Log log = LogFactory.getLog(ControllerProperties.class);
    private String configFile = null;
    private String defaultConfigFile = null;
    private XMLConfiguration conf = null;

    public ControllerProperties(String configFile, String defaultConfigFile) {
        this.configFile = configFile;
        this.defaultConfigFile = defaultConfigFile;
        log.debug((Object)("PropertiesFile: " + configFile + " and " + defaultConfigFile));
    }

    public String getParameter(String param) throws Exception {
        String value = null;
        if (this.conf == null) {
            this.loadConfig();
        }
        log.debug((Object)("Trying to get Parameter " + param));
        value = this.conf.getString(param, null);
        if (value != null) {
            log.debug((Object)("Property found: " + param + " = " + value));
        } else {
            log.debug((Object)("Property '" + param + "' not found, returning null."));
        }
        return value;
    }

    public void setParameter(String param, String value) {
    }

    public String[] getParameterNames() throws Exception {
        String[] names = new String[]{""};
        if (this.conf == null) {
            this.loadConfig();
        }
        log.debug((Object)"Trying to get Parameters");
        Iterator keyiterator = this.conf.getKeys();
        ArrayList<String> arraylist = new ArrayList<String>();
        String element = null;
        Object object = null;
        Class<?> stringclass = Class.forName("java.lang.String");
        while (keyiterator.hasNext()) {
            object = keyiterator.next();
            if (!stringclass.isInstance(object)) continue;
            element = object;
            arraylist.add(element);
        }
        names = arraylist.toArray(names);
        return names;
    }

    private void loadConfig() throws IOException {
        this.conf = new XMLConfiguration();
        URL url = ResourceLocator.getURL(this.configFile, this.defaultConfigFile, this.getClass());
        try {
            this.conf.load(url);
        }
        catch (ConfigurationException e) {
            log.error((Object)("Could not find properties file: " + this.configFile));
            throw new IOException("Properties file not found.");
        }
    }
}

